/*
 * Decompiled with CFR 0.152.
 */
package com.trs.util.dbcp.impl;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class SqlTraceImplPreparedStatement
implements PreparedStatement {
    private static Logger m_Logger;
    private PreparedStatement m_TracedPreparedStatement = null;
    private String m_LastSql = "";
    private int m_SwitchUseTime = 200;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.util.dbcp.impl.SqlTraceImplPreparedStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        m_Logger = Logger.getLogger((Class)clazz);
    }

    public SqlTraceImplPreparedStatement(PreparedStatement tracedPstmt) {
        this.m_TracedPreparedStatement = tracedPstmt;
    }

    public SqlTraceImplPreparedStatement(PreparedStatement tracedPstmt, String strSQL) {
        this.m_TracedPreparedStatement = tracedPstmt;
        this.m_LastSql = strSQL;
    }

    public String getStackTraceText(Throwable _ex) {
        StringWriter strWriter = null;
        PrintWriter prtWriter = null;
        try {
            strWriter = new StringWriter();
            prtWriter = new PrintWriter(strWriter);
            _ex.printStackTrace(prtWriter);
            prtWriter.flush();
            String string = strWriter.toString();
            return string;
        }
        catch (Exception ex2) {
            String string = _ex.getMessage();
            return string;
        }
        finally {
            if (strWriter != null) {
                try {
                    strWriter.close();
                }
                catch (Exception exception) {}
            }
            if (prtWriter != null) {
                try {
                    prtWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void addBatch() throws SQLException {
        this.m_TracedPreparedStatement.addBatch();
    }

    public void clearParameters() throws SQLException {
        this.m_TracedPreparedStatement.clearBatch();
    }

    public boolean execute() throws SQLException {
        long lStartTime = System.currentTimeMillis();
        boolean bExecuteResult = this.m_TracedPreparedStatement.execute();
        this.trace(lStartTime);
        return bExecuteResult;
    }

    public ResultSet executeQuery() throws SQLException {
        long lStartTime = System.currentTimeMillis();
        ResultSet rsExecuteResult = this.m_TracedPreparedStatement.executeQuery();
        this.trace(lStartTime);
        return rsExecuteResult;
    }

    public int executeUpdate() throws SQLException {
        long lStartTime = System.currentTimeMillis();
        int nExecuteResult = this.m_TracedPreparedStatement.executeUpdate();
        this.trace(lStartTime);
        return nExecuteResult;
    }

    private void trace(long startTime) {
        long lExecTime = System.currentTimeMillis() - startTime;
        if (lExecTime <= (long)this.m_SwitchUseTime) {
            return;
        }
        if (m_Logger.isInfoEnabled()) {
            m_Logger.info((Object)("[SqlTrace]" + this.m_LastSql + " execTime[" + lExecTime + "ms]"));
        }
        if (m_Logger.isDebugEnabled()) {
            String sDebugInfo = this.getStackTraceText(new Exception("[SqlTraceStack]" + this.m_LastSql + " execTime[" + lExecTime + "ms]"));
            m_Logger.debug((Object)("[SqlTraceStack]" + sDebugInfo));
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.m_TracedPreparedStatement.getMetaData();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.m_TracedPreparedStatement.getParameterMetaData();
    }

    public void setArray(int i, Array x) throws SQLException {
        this.m_TracedPreparedStatement.setArray(i, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.m_TracedPreparedStatement.setAsciiStream(parameterIndex, x, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.m_TracedPreparedStatement.setBigDecimal(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.m_TracedPreparedStatement.setBinaryStream(parameterIndex, x, length);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.m_TracedPreparedStatement.setBlob(i, x);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.m_TracedPreparedStatement.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.m_TracedPreparedStatement.setByte(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.m_TracedPreparedStatement.setBytes(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.m_TracedPreparedStatement.setCharacterStream(parameterIndex, reader, length);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.m_TracedPreparedStatement.setClob(i, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.m_TracedPreparedStatement.setDate(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.m_TracedPreparedStatement.setDate(parameterIndex, x, cal);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.m_TracedPreparedStatement.setDouble(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.m_TracedPreparedStatement.setFloat(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.m_TracedPreparedStatement.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.m_TracedPreparedStatement.setLong(parameterIndex, x);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.m_TracedPreparedStatement.setNull(parameterIndex, sqlType);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.m_TracedPreparedStatement.setNull(paramIndex, sqlType, typeName);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.m_TracedPreparedStatement.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.m_TracedPreparedStatement.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.m_TracedPreparedStatement.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.m_TracedPreparedStatement.setRef(i, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.m_TracedPreparedStatement.setShort(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.m_TracedPreparedStatement.setString(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.m_TracedPreparedStatement.setTime(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.m_TracedPreparedStatement.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.m_TracedPreparedStatement.setTimestamp(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.m_TracedPreparedStatement.setTimestamp(parameterIndex, x, cal);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.m_TracedPreparedStatement.setURL(parameterIndex, x);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.m_TracedPreparedStatement.setUnicodeStream(parameterIndex, x, length);
    }

    public void addBatch(String sql) throws SQLException {
        this.m_TracedPreparedStatement.addBatch(sql);
    }

    public void cancel() throws SQLException {
        this.m_TracedPreparedStatement.cancel();
    }

    public void clearBatch() throws SQLException {
        this.m_TracedPreparedStatement.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.m_TracedPreparedStatement.clearWarnings();
    }

    public void close() throws SQLException {
        this.m_TracedPreparedStatement.close();
    }

    public boolean execute(String sql) throws SQLException {
        this.m_LastSql = sql;
        long lStartTime = System.currentTimeMillis();
        boolean bExecuteResult = this.m_TracedPreparedStatement.execute(sql);
        this.trace(lStartTime);
        return bExecuteResult;
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.m_TracedPreparedStatement.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.m_TracedPreparedStatement.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.m_TracedPreparedStatement.execute(sql, columnNames);
    }

    public int[] executeBatch() throws SQLException {
        return this.m_TracedPreparedStatement.executeBatch();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return this.m_TracedPreparedStatement.executeQuery(sql);
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.m_TracedPreparedStatement.executeUpdate(sql);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.m_TracedPreparedStatement.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.m_TracedPreparedStatement.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.m_TracedPreparedStatement.executeUpdate(sql, columnNames);
    }

    public Connection getConnection() throws SQLException {
        return this.m_TracedPreparedStatement.getConnection();
    }

    public int getFetchDirection() throws SQLException {
        return this.m_TracedPreparedStatement.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.m_TracedPreparedStatement.getFetchSize();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.m_TracedPreparedStatement.getGeneratedKeys();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.m_TracedPreparedStatement.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.m_TracedPreparedStatement.getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        return this.m_TracedPreparedStatement.getMoreResults();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.m_TracedPreparedStatement.getMoreResults(current);
    }

    public int getQueryTimeout() throws SQLException {
        return this.m_TracedPreparedStatement.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.m_TracedPreparedStatement.getResultSet();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.m_TracedPreparedStatement.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.m_TracedPreparedStatement.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.m_TracedPreparedStatement.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this.m_TracedPreparedStatement.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_TracedPreparedStatement.getWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.m_TracedPreparedStatement.setCursorName(name);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.m_TracedPreparedStatement.setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.m_TracedPreparedStatement.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.m_TracedPreparedStatement.setFetchSize(rows);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.m_TracedPreparedStatement.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.m_TracedPreparedStatement.setMaxRows(max);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.m_TracedPreparedStatement.setQueryTimeout(seconds);
    }
}

