/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster;

import com.trs.infra.cluster.Streamable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class StreamType {
    private static final Logger s_logger;
    private static final Map mapClazz;
    private static final Map mapNames;
    private static final StreamType[] mapTypes;
    private final Class clazz;
    private final String clazzName;
    private final short clazzType;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.StreamType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
        mapClazz = new HashMap();
        mapNames = new HashMap();
        mapTypes = new StreamType[Short.MAX_VALUE];
    }

    public static final synchronized boolean add(StreamType streamType) {
        if (mapTypes[streamType.clazzType] != null) {
            s_logger.error((Object)("Duplicate StreamType: " + streamType));
            return false;
        }
        if (mapNames.containsKey(streamType.clazzName)) {
            s_logger.error((Object)("Duplicate StreamType: " + streamType));
            return false;
        }
        if (mapClazz.containsKey(streamType.clazz)) {
            s_logger.error((Object)("Duplicate StreamType: " + streamType));
            return false;
        }
        mapClazz.put(streamType.clazz, streamType);
        mapClazz.put(streamType.clazzName, streamType);
        StreamType.mapTypes[streamType.clazzType] = streamType;
        return true;
    }

    public static final boolean add(short type, String name) throws ClassNotFoundException {
        if (mapTypes[type] != null) {
            s_logger.error((Object)("Duplicate StreamType: " + type));
            return false;
        }
        if (mapNames.containsKey(name)) {
            s_logger.error((Object)("Duplicate StreamType: " + name));
            return false;
        }
        return StreamType.add(new StreamType(type, name));
    }

    public static final boolean add(short type, Class clazz) {
        if (mapTypes[type] != null) {
            s_logger.error((Object)("Duplicate StreamType: " + type));
            return false;
        }
        if (mapClazz.containsKey(clazz)) {
            s_logger.error((Object)("Duplicate StreamType: " + clazz));
            return false;
        }
        return StreamType.add(new StreamType(type, clazz));
    }

    public static final StreamType valueOf(Class clazz) {
        return (StreamType)mapClazz.get(clazz);
    }

    public static final StreamType valueOf(short clazzType) {
        return mapTypes[clazzType];
    }

    public static final StreamType valueOf(String clazzName) {
        return (StreamType)mapNames.get(clazzName);
    }

    public static final Iterator values() {
        return mapClazz.values().iterator();
    }

    public StreamType(short clazzType, String clazzName) throws ClassNotFoundException {
        this.clazzType = clazzType;
        this.clazzName = clazzName;
        this.clazz = Class.forName(clazzName);
    }

    public StreamType(short clazzType, Class clazz) {
        this.clazzType = clazzType;
        this.clazzName = clazz.getName();
        this.clazz = clazz;
    }

    public final Class getClazz() {
        return this.clazz;
    }

    public final int getClazzType() {
        return this.clazzType;
    }

    public final String getClazzName() {
        return this.clazzName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StreamType) {
            StreamType other = (StreamType)obj;
            if (other.clazzType == this.clazzType && other.clazz == this.clazz) {
                return other.clazzName.equals(this.clazzName);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.clazzType;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Type:").append(this.clazzType);
        sb.append("Name:").append(this.clazzName);
        return sb.toString();
    }

    public Streamable newInstance() {
        try {
            return (Streamable)this.clazz.newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException("New instance failed for: " + this.toString(), e);
        }
    }
}

