/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster;

import com.trs.infra.cluster.ACK;
import com.trs.infra.cluster.Address;
import com.trs.infra.cluster.Callbackable;
import com.trs.infra.cluster.Streamable;
import com.trs.infra.cluster.io.ByteArrayStreamReader;
import com.trs.infra.cluster.io.ByteArrayStreamWriter;
import com.trs.infra.cluster.io.StreamDataUtil;
import java.net.InetAddress;
import org.apache.log4j.Logger;

public abstract class ClusterMessage
implements Streamable {
    private static final Logger s_logger;
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 0;
    public static final int MAX_UDP_BUFFER_SIZE = 32768;
    public static final int HEADER_SIZE = 32;
    public static final int DEFAULT_MAGIC = 257;
    public static final int FLAG_NEEDACK = 1;
    public static final int FLAG_DELAY_SEND = 2;
    public static final int FLAG_DELAY_RECEIVE = 4;
    public static final int FLAG_ENCRYPTED = 8;
    public static final int FLAG_SIGNED = 16;
    public static final int FLAG_BROADCAST = 32;
    public static final int MAX_MAJOR_ID = 255;
    public static final int MIN_MAJOR_ID = 0;
    public static final int MAX_MINOR_ID = 255;
    public static final int MIN_MINOR_ID = 0;
    public static final int EXTENSION_ID = 127;
    private long createTime = System.currentTimeMillis();
    private InetAddress sourceAddress;
    private int sourcePort;
    private InetAddress targetAddress;
    private int targetPort;
    private ACK waitACK;
    private Callbackable callback;
    private int magicNumber;
    private int flag;
    private int sequence;
    private int majorId;
    private int minorId;
    private int length;
    private long sendTime;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.ClusterMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public static final int getDefaultMagic() {
        return 257;
    }

    public static final boolean checkVersion(int majorVersion, int minorVersion) {
        return majorVersion == 2 && minorVersion == 0;
    }

    public final int flush(byte[] buffer, int offset) {
        int dataLength = 0;
        dataLength += this.flushBody(buffer, offset);
        return dataLength += this.flushHead(buffer, offset);
    }

    public final int flushHead(byte[] buffer, int offset) {
        StreamDataUtil.write_short(buffer, offset, (short)this.magicNumber);
        buffer[offset + 2] = 2;
        buffer[offset + 3] = 0;
        StreamDataUtil.write_int(buffer, offset + 4, this.flag);
        StreamDataUtil.write_int(buffer, offset + 8, this.sequence);
        buffer[offset + 12] = (byte)this.majorId;
        buffer[offset + 13] = (byte)this.minorId;
        StreamDataUtil.write_short(buffer, offset + 14, (short)this._type().getClazzType());
        StreamDataUtil.write_int(buffer, offset + 28, this.length);
        return 32;
    }

    public final int flushBody(byte[] buffer, int offset) {
        ByteArrayStreamWriter writer = new ByteArrayStreamWriter(buffer, offset + 32);
        try {
            this._save(writer);
        }
        catch (Throwable e) {
            s_logger.fatal((Object)"Flush message body failed", e);
        }
        this.setLength((int)writer.size());
        return this.getLength();
    }

    public final void stuff(byte[] buffer, int offset) {
        this.stuffHead(buffer, offset);
        this.stuffBody(buffer, offset);
    }

    public final void stuffHead(byte[] buffer, int offset) {
    }

    public void stuffBody(byte[] buffer, int offset) {
        try {
            this._load(new ByteArrayStreamReader(buffer, offset + 32));
        }
        catch (Throwable e) {
            s_logger.fatal((Object)"Flush message body failed", e);
        }
    }

    public final void setSourceAddress(Address address) {
        this.sourceAddress = address.getInetAddress();
        this.sourcePort = address.getPort();
    }

    public final void setTargetAddress(Address address) {
        this.targetAddress = address.getInetAddress();
        this.targetPort = address.getPort();
    }

    public final InetAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public final void setSourceAddress(InetAddress sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public final int getSourcePort() {
        return this.sourcePort;
    }

    public final void setSourcePort(int sourcePort) {
        this.sourcePort = sourcePort;
    }

    public final InetAddress getTargetAddress() {
        return this.targetAddress;
    }

    public final int getTargetPort() {
        return this.targetPort;
    }

    public final void setTargetPort(int targetPort) {
        this.targetPort = targetPort;
    }

    public final void setTargetAddress(InetAddress targetAddress) {
        this.targetAddress = targetAddress;
    }

    public final ACK getWaitACK() {
        return this.waitACK;
    }

    public final void setWaitACK(ACK waitACK) {
        this.waitACK = waitACK;
    }

    public final Callbackable getCallback() {
        return this.callback;
    }

    public final void setCallback(Callbackable callback) {
        this.callback = callback;
    }

    public final int getMagicNumber() {
        return this.magicNumber;
    }

    public final void setMagicNumber(int magicNumber) {
        this.magicNumber = magicNumber;
    }

    public final int getMajorVersion() {
        return 2;
    }

    public final int getMinorVersion() {
        return 0;
    }

    public final boolean isNeedACK() {
        return (this.flag & 1) != 0;
    }

    public final void setNeedACK(boolean needACK) {
        this.flag = needACK ? (this.flag |= 1) : (this.flag &= 0xFFFFFFFE);
    }

    public final boolean isDelaySend() {
        return (this.flag & 2) != 0;
    }

    public final void setDelaySend(boolean delaySend) {
        this.flag = delaySend ? (this.flag |= 2) : (this.flag &= 0xFFFFFFFD);
    }

    public final boolean isDelayReceive() {
        return (this.flag & 4) != 0;
    }

    public final void setDelayReceive(boolean delayReceive) {
        this.flag = delayReceive ? (this.flag |= 4) : (this.flag &= 0xFFFFFFFB);
    }

    public final boolean isEncrypted() {
        return (this.flag & 8) != 0;
    }

    public final void setEncrypted(boolean encrypted) {
        this.flag = encrypted ? (this.flag |= 8) : (this.flag &= 0xFFFFFFF7);
    }

    public final boolean isSigned() {
        return (this.flag & 0x10) != 0;
    }

    public final void setSigned(boolean signed) {
        this.flag = signed ? (this.flag |= 0x10) : (this.flag &= 0xFFFFFFEF);
    }

    public final boolean isBroadcast() {
        return (this.flag & 0x20) != 0;
    }

    public final void setBroadcast(boolean broadcast) {
        this.flag = broadcast ? (this.flag |= 0x20) : (this.flag &= 0xFFFFFFDF);
    }

    public final int getFlag() {
        return this.flag;
    }

    public final void setFlag(int flag) {
        this.flag = flag;
    }

    public final int getSequence() {
        return this.sequence;
    }

    public final void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public final int getMajorId() {
        return this.majorId;
    }

    public final void setMajorId(int majorId) {
        this.majorId = majorId & 0xFF;
    }

    public final int getMinorId() {
        return this.minorId;
    }

    public final void setMinorId(int minorId) {
        this.minorId = minorId & 0xFF;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int length) {
        this.length = length;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(128);
        buff.append("ClusterMessage");
        buff.append('{');
        buff.append("sequence:").append(this.sequence);
        buff.append(",majorId:").append(this.majorId);
        buff.append(",minorId:").append(this.minorId);
        buff.append(",source:").append(this.sourceAddress).append('/').append(this.sourcePort);
        buff.append(",target:").append(this.targetAddress).append('/').append(this.targetPort);
        buff.append('}');
        return buff.toString();
    }

    public final long getSendTime() {
        return this.sendTime;
    }

    public final void setSendTime(long sendTime) {
        this.sendTime = sendTime;
    }

    public final void setSendTime() {
        this.sendTime = System.currentTimeMillis();
    }

    public final long getCreateTime() {
        return this.createTime;
    }
}

