/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import com.trs.cis4.util.GenerateUtil;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class PasswordUtil {
    private static String hexits = "0123456789abcdef";

    public static boolean check(String encodedPwd, String password) {
        MessageDigest sha;
        byte[][] hs;
        if (encodedPwd == null || password == null) {
            return false;
        }
        if (encodedPwd.regionMatches(true, 0, "{SHA}", 0, 5)) {
            encodedPwd = encodedPwd.substring(5);
        } else if (encodedPwd.regionMatches(true, 0, "{SSHA}", 0, 6)) {
            encodedPwd = encodedPwd.substring(6);
        }
        BASE64Decoder base64 = new BASE64Decoder();
        try {
            hs = PasswordUtil.split(base64.decodeBuffer(encodedPwd), 20);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        byte[] hash = hs[0];
        byte[] salt = hs[1];
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return false;
        }
        sha.update(password.getBytes());
        sha.update(salt);
        byte[] pwhash = sha.digest();
        return MessageDigest.isEqual(hash, pwhash);
    }

    private static byte[][] split(byte[] src, int n) {
        byte[] r;
        byte[] l;
        if (src == null || src.length <= n) {
            l = src;
            r = new byte[]{};
        } else {
            l = new byte[n];
            r = new byte[src.length - n];
            System.arraycopy(src, 0, l, 0, n);
            System.arraycopy(src, n, r, 0, r.length);
        }
        return new byte[][]{l, r};
    }

    public static String encoder(String password) {
        MessageDigest sha;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
        String s = Integer.toHexString(GenerateUtil.generate6());
        byte[] salt = PasswordUtil.fromHex(s);
        BASE64Encoder base64 = new BASE64Encoder();
        sha.update(password.getBytes());
        sha.update(salt);
        byte[] pwhash = sha.digest();
        return "{SSHA}" + base64.encode(PasswordUtil.concatenate(pwhash, salt));
    }

    private static byte[] fromHex(String s) {
        s = s.toLowerCase();
        byte[] b = new byte[(s.length() + 1) / 2];
        int j = 0;
        int nybble = -1;
        int i = 0;
        while (i < s.length()) {
            int h = hexits.indexOf(s.charAt(i));
            if (h >= 0) {
                if (nybble < 0) {
                    nybble = h;
                } else {
                    b[j++] = (byte)((nybble << 4) + h);
                    nybble = -1;
                }
            }
            ++i;
        }
        if (nybble >= 0) {
            b[j++] = (byte)(nybble << 4);
        }
        if (j < b.length) {
            byte[] b2 = new byte[j];
            System.arraycopy(b, 0, b2, 0, j);
            b = b2;
        }
        return b;
    }

    private static byte[] concatenate(byte[] l, byte[] r) {
        byte[] b = new byte[l.length + r.length];
        System.arraycopy(l, 0, b, 0, l.length);
        System.arraycopy(r, 0, b, l.length, r.length);
        return b;
    }

    private PasswordUtil() {
    }
}

