/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericAttr;
import org.apache.batik.dom.GenericAttrNS;
import org.apache.batik.dom.GenericCDATASection;
import org.apache.batik.dom.GenericComment;
import org.apache.batik.dom.GenericDocumentFragment;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.GenericEntityReference;
import org.apache.batik.dom.GenericProcessingInstruction;
import org.apache.batik.dom.GenericText;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class GenericDocument
extends AbstractDocument {
    protected boolean readonly;

    protected GenericDocument() {
    }

    public GenericDocument(DocumentType documentType, DOMImplementation dOMImplementation) {
        super(dOMImplementation);
        if (documentType != null) {
            this.appendChild(documentType);
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    public Element createElement(String string) throws DOMException {
        return new GenericElement(string.intern(), this);
    }

    public DocumentFragment createDocumentFragment() {
        return new GenericDocumentFragment(this);
    }

    public Text createTextNode(String string) {
        return new GenericText(string, this);
    }

    public Comment createComment(String string) {
        return new GenericComment(string, this);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new GenericCDATASection(string, this);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        return new GenericProcessingInstruction(string, string2, this);
    }

    public Element getElementById(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        Element element = this.getDocumentElement();
        if (element == null) {
            return null;
        }
        return GenericDocument.getById(string, element);
    }

    protected static Element getById(String string, Node node) {
        if (!(node instanceof Element)) {
            return null;
        }
        Element element = (Element)node;
        if (element.getAttribute("id").equals(string)) {
            return element;
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Element element2 = GenericDocument.getById(string, node2);
            if (element2 != null) {
                return element2;
            }
            node2 = node2.getNextSibling();
        }
        return null;
    }

    public Attr createAttribute(String string) throws DOMException {
        return new GenericAttr(string.intern(), this);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        return new GenericEntityReference(string, this);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        if (string == null) {
            return new GenericElement(string2.intern(), this);
        }
        return new GenericElementNS(string.intern(), string2.intern(), this);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        if (string == null) {
            return new GenericAttr(string2.intern(), this);
        }
        return new GenericAttrNS(string.intern(), string2.intern(), this);
    }

    protected Node newNode() {
        return new GenericDocument();
    }
}

