/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.FileScanner;

public class DirectoryScanner
implements FileScanner {
    protected static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/%*%", "**/CVS", "**/CVS/*", "**/.cvsignore"};
    protected File basedir;
    protected String[] includes;
    protected String[] excludes;
    protected Vector filesIncluded;
    protected Vector filesNotIncluded;
    protected Vector filesExcluded;
    protected Vector dirsIncluded;
    protected Vector dirsNotIncluded;
    protected Vector dirsExcluded;
    protected boolean haveSlowResults = false;

    public void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + DEFAULTEXCLUDES.length];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        int i = 0;
        while (i < DEFAULTEXCLUDES.length) {
            newExcludes[i + excludesLength] = DEFAULTEXCLUDES[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
            ++i;
        }
        this.excludes = newExcludes;
    }

    protected boolean couldHoldIncluded(String name) {
        int i = 0;
        while (i < this.includes.length) {
            if (DirectoryScanner.matchPatternStart(this.includes[i], name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public String[] getExcludedDirectories() {
        this.slowScan();
        int count = this.dirsExcluded.size();
        String[] directories = new String[count];
        int i = 0;
        while (i < count) {
            directories[i] = (String)this.dirsExcluded.elementAt(i);
            ++i;
        }
        return directories;
    }

    public String[] getExcludedFiles() {
        this.slowScan();
        int count = this.filesExcluded.size();
        String[] files = new String[count];
        int i = 0;
        while (i < count) {
            files[i] = (String)this.filesExcluded.elementAt(i);
            ++i;
        }
        return files;
    }

    public String[] getIncludedDirectories() {
        int count = this.dirsIncluded.size();
        String[] directories = new String[count];
        int i = 0;
        while (i < count) {
            directories[i] = (String)this.dirsIncluded.elementAt(i);
            ++i;
        }
        return directories;
    }

    public String[] getIncludedFiles() {
        int count = this.filesIncluded.size();
        String[] files = new String[count];
        int i = 0;
        while (i < count) {
            files[i] = (String)this.filesIncluded.elementAt(i);
            ++i;
        }
        return files;
    }

    public String[] getNotIncludedDirectories() {
        this.slowScan();
        int count = this.dirsNotIncluded.size();
        String[] directories = new String[count];
        int i = 0;
        while (i < count) {
            directories[i] = (String)this.dirsNotIncluded.elementAt(i);
            ++i;
        }
        return directories;
    }

    public String[] getNotIncludedFiles() {
        this.slowScan();
        int count = this.filesNotIncluded.size();
        String[] files = new String[count];
        int i = 0;
        while (i < count) {
            files[i] = (String)this.filesNotIncluded.elementAt(i);
            ++i;
        }
        return files;
    }

    protected boolean isExcluded(String name) {
        int i = 0;
        while (i < this.excludes.length) {
            if (DirectoryScanner.matchPath(this.excludes[i], name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isIncluded(String name) {
        int i = 0;
        while (i < this.includes.length) {
            if (DirectoryScanner.matchPath(this.includes[i], name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean match(String pattern, String str) {
        patArr = pattern.toCharArray();
        strArr = str.toCharArray();
        patIdxStart = 0;
        patIdxEnd = patArr.length - 1;
        strIdxStart = 0;
        strIdxEnd = strArr.length - 1;
        containsStar = false;
        i = 0;
        while (i < patArr.length) {
            if (patArr[i] == '*') {
                containsStar = true;
                break;
            }
            ++i;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            while (i <= patIdxEnd) {
                ch = patArr[i];
                if (ch != '?' && ch != strArr[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxEnd != 0) ** GOTO lbl32
        return true;
lbl-1000:
        // 1 sources

        {
            if (ch != '?' && ch != strArr[strIdxStart]) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
lbl32:
            // 2 sources

            ** while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl33:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl45
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (ch != '?' && ch != strArr[strIdxEnd]) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
lbl45:
            // 2 sources

            ** while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl46:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl86
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patArr[i] == '*') {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block24: {
                    j = 0;
                    while (j < patLength) {
                        ch = patArr[patIdxStart + j + 1];
                        if (ch == '?' || ch == strArr[strIdxStart + i + j]) {
                            ++j;
                            continue;
                        }
                        break block24;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl86:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl87:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean matchPath(String pattern, String str) {
        if (str.startsWith(File.separator) != pattern.startsWith(File.separator)) {
            return false;
        }
        patDirs = new Vector<String>();
        st = new StringTokenizer(pattern, File.separator);
        while (st.hasMoreTokens()) {
            patDirs.addElement(st.nextToken());
        }
        strDirs = new Vector<String>();
        st = new StringTokenizer(str, File.separator);
        while (st.hasMoreTokens()) {
            strDirs.addElement(st.nextToken());
        }
        patIdxStart = 0;
        patIdxEnd = patDirs.size() - 1;
        strIdxStart = 0;
        strIdxEnd = strDirs.size() - 1;
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd) {
            patDir = (String)patDirs.elementAt(patIdxStart);
            if (patDir.equals("**")) break;
            if (!DirectoryScanner.match(patDir, (String)strDirs.elementAt(strIdxStart))) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            i = patIdxStart;
            while (i <= patIdxEnd) {
                if (!patDirs.elementAt(i).equals("**")) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxStart <= patIdxEnd) ** GOTO lbl40
        return false;
        while (!(patDir = (String)patDirs.elementAt(patIdxEnd)).equals("**")) {
            if (!DirectoryScanner.match(patDir, (String)strDirs.elementAt(strIdxEnd))) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
lbl40:
            // 2 sources

            if (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd) continue;
        }
        if (strIdxStart <= strIdxEnd) ** GOTO lbl81
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (!patDirs.elementAt(i).equals("**")) {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patDirs.elementAt(i).equals("**")) {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block22: {
                    j = 0;
                    while (j < patLength) {
                        subPat = (String)patDirs.elementAt(patIdxStart + j + 1);
                        if (DirectoryScanner.match(subPat, subStr = (String)strDirs.elementAt(strIdxStart + i + j))) {
                            ++j;
                            continue;
                        }
                        break block22;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl81:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl82:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (!patDirs.elementAt(i).equals("**")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static boolean matchPatternStart(String pattern, String str) {
        if (str.startsWith(File.separator) != pattern.startsWith(File.separator)) {
            return false;
        }
        Vector<String> patDirs = new Vector<String>();
        StringTokenizer st = new StringTokenizer(pattern, File.separator);
        while (st.hasMoreTokens()) {
            patDirs.addElement(st.nextToken());
        }
        Vector<String> strDirs = new Vector<String>();
        st = new StringTokenizer(str, File.separator);
        while (st.hasMoreTokens()) {
            strDirs.addElement(st.nextToken());
        }
        int patIdxStart = 0;
        int patIdxEnd = patDirs.size() - 1;
        int strIdxStart = 0;
        int strIdxEnd = strDirs.size() - 1;
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd) {
            String patDir = (String)patDirs.elementAt(patIdxStart);
            if (patDir.equals("**")) break;
            if (!DirectoryScanner.match(patDir, (String)strDirs.elementAt(strIdxStart))) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            return true;
        }
        return patIdxStart <= patIdxEnd;
    }

    public void scan() {
        if (this.basedir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!this.basedir.exists()) {
            throw new IllegalStateException("basedir does not exist");
        }
        if (!this.basedir.isDirectory()) {
            throw new IllegalStateException("basedir is not a directory");
        }
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.scandir(this.basedir, "", true);
    }

    protected void scandir(File dir, String vpath, boolean fast) {
        String[] newfiles = dir.list();
        if (newfiles == null) {
            throw new BuildException("IO error scanning directory" + dir.getAbsolutePath());
        }
        int i = 0;
        while (i < newfiles.length) {
            String name = String.valueOf(vpath) + newfiles[i];
            File file = new File(dir, newfiles[i]);
            if (file.isDirectory()) {
                if (this.isIncluded(name)) {
                    if (!this.isExcluded(name)) {
                        this.dirsIncluded.addElement(name);
                        if (fast) {
                            this.scandir(file, String.valueOf(name) + File.separator, fast);
                        }
                    } else {
                        this.dirsExcluded.addElement(name);
                    }
                } else {
                    this.dirsNotIncluded.addElement(name);
                    if (fast && this.couldHoldIncluded(name)) {
                        this.scandir(file, String.valueOf(name) + File.separator, fast);
                    }
                }
                if (!fast) {
                    this.scandir(file, String.valueOf(name) + File.separator, fast);
                }
            } else if (file.isFile()) {
                if (this.isIncluded(name)) {
                    if (!this.isExcluded(name)) {
                        this.filesIncluded.addElement(name);
                    } else {
                        this.filesExcluded.addElement(name);
                    }
                } else {
                    this.filesNotIncluded.addElement(name);
                }
            }
            ++i;
        }
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setBasedir(String basedir) {
        this.setBasedir(new File(basedir.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            int i = 0;
            while (i < excludes.length) {
                String pattern = excludes[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = String.valueOf(pattern) + "**";
                }
                this.excludes[i] = pattern;
                ++i;
            }
        }
    }

    public void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            int i = 0;
            while (i < includes.length) {
                String pattern = includes[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = String.valueOf(pattern) + "**";
                }
                this.includes[i] = pattern;
                ++i;
            }
        }
    }

    protected void slowScan() {
        if (this.haveSlowResults) {
            return;
        }
        Object[] excl = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(excl);
        Object[] notIncl = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(notIncl);
        int i = 0;
        while (i < excl.length) {
            this.scandir(new File(this.basedir, (String)excl[i]), String.valueOf(excl[i]) + File.separator, false);
            ++i;
        }
        int i2 = 0;
        while (i2 < notIncl.length) {
            if (!this.couldHoldIncluded((String)notIncl[i2])) {
                this.scandir(new File(this.basedir, (String)notIncl[i2]), String.valueOf(notIncl[i2]) + File.separator, false);
            }
            ++i2;
        }
        this.haveSlowResults = true;
    }
}

