/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ckm.soap;

import com.trs.ckm.soap.CkmSoapException;
import com.trs.ckm.soap.PTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;

public class Dir2SFX {
    private final String CONST_SFX_VERSION = "sfx100\u0000";
    private final int CONST_MAX_SFX_PATH = 256;

    private String convSFXPath(String _sSFXPath) {
        int nPos = _sSFXPath.indexOf(0);
        if (nPos != -1) {
            _sSFXPath = _sSFXPath.substring(0, nPos);
        }
        return _sSFXPath;
    }

    private int writeIntToSFXStream(FileOutputStream _fOut, int _iValue) throws Exception {
        byte[] bData = new byte[4];
        int i = 0;
        while (i < 4) {
            bData[i] = (byte)(_iValue >> i * 8 & 0xFF);
            ++i;
        }
        _fOut.write(bData, 0, 4);
        return 4;
    }

    private int readIntFromSFXStream(FileInputStream _fIn) throws Exception {
        byte[] bData = new byte[4];
        _fIn.read(bData);
        int iValue = 0;
        int i = 0;
        while (i < 4) {
            iValue |= (bData[i] & 0xFF) << i * 8;
            ++i;
        }
        return iValue;
    }

    private int writeStringToSFXStream(FileOutputStream _fOut, String _sValue) throws Exception {
        return this.writeStringToSFXStream(_fOut, _sValue, _sValue.length());
    }

    private int writeStringToSFXStream(FileOutputStream _fOut, String _sValue, int _iSize) throws Exception {
        if (_sValue.length() > _iSize) {
            _sValue = _sValue.substring(0, _iSize - 1);
        }
        byte[] bData = _sValue.getBytes();
        _fOut.write(bData);
        if (bData.length < _iSize) {
            bData = new byte[_iSize - bData.length];
            _fOut.write(bData);
        }
        return _iSize;
    }

    private String readStringFromSFXStream(FileInputStream _fIn, int _iLen) throws Exception {
        byte[] bData = new byte[_iLen];
        _fIn.read(bData);
        String sValue = new String(bData);
        return sValue;
    }

    private int writeFileToSFXStream(FileOutputStream _fOut, int _iOffset, File _fFile, String _sPath) throws Exception {
        this.writeStringToSFXStream(_fOut, _sPath, 256);
        this.writeIntToSFXStream(_fOut, 0);
        int ibOffset = _iOffset + 256 + 12;
        int ieOffset = ibOffset + (int)_fFile.length();
        int iLen = 256 + 12 + (int)_fFile.length();
        this.writeIntToSFXStream(_fOut, ibOffset);
        this.writeIntToSFXStream(_fOut, ieOffset);
        FileInputStream fIn = null;
        try {
            int iBuf;
            fIn = new FileInputStream(_fFile);
            byte[] bData = new byte[1024];
            while ((iBuf = fIn.read(bData)) > 0) {
                _fOut.write(bData, 0, iBuf);
            }
        }
        finally {
            if (fIn != null) {
                fIn.close();
            }
        }
        return iLen;
    }

    public boolean SureFilePath(String path) throws CkmSoapException {
        File fFile = new File(path);
        if (fFile.exists() && fFile.isDirectory()) {
            return true;
        }
        if (!fFile.exists() && fFile.mkdirs()) {
            fFile.delete();
            return true;
        }
        return false;
    }

    private int ListFiles(String _sDirPath, String _sRoot, int _iLevel, Vector _vResult) throws CkmSoapException {
        if (_iLevel > 12) {
            return 0;
        }
        File fFile = new File(_sDirPath);
        if (!fFile.exists()) {
            return 0;
        }
        File[] fFiles = fFile.listFiles();
        if (fFiles != null) {
            int i = 0;
            while (i < fFiles.length) {
                String sPath;
                String sRoot = _sRoot.equals("") ? _sRoot : String.valueOf(_sRoot) + "/";
                if (fFiles[i].isFile()) {
                    sPath = String.valueOf(sRoot) + fFiles[i].getName();
                    _vResult.add(sPath);
                } else {
                    sPath = String.valueOf(_sDirPath) + "/" + fFiles[i].getName();
                    sRoot = String.valueOf(sRoot) + fFiles[i].getName();
                    this.ListFiles(sPath, sRoot, _iLevel + 1, _vResult);
                }
                ++i;
            }
        }
        return 0;
    }

    public int convDir2SFX(String _sDirPath, String _sSFXPath) throws CkmSoapException {
        int nOffset;
        FileOutputStream fOut = null;
        try {
            try {
                Vector vFiles = new Vector();
                this.ListFiles(_sDirPath, "", 0, vFiles);
                if (vFiles.size() == 0) {
                    throw new CkmSoapException("\u6e90\u76ee\u5f55\u4e0d\u5b58\u5728\u6216\u4e0d\u5305\u542b\u4efb\u4f55\u6587\u4ef6");
                }
                fOut = new FileOutputStream(_sSFXPath);
                this.writeStringToSFXStream(fOut, "sfx100\u0000");
                nOffset = "sfx100\u0000".length();
                int i = 0;
                while (i < vFiles.size()) {
                    String sFilePath = (String)vFiles.get(i);
                    nOffset += this.writeFileToSFXStream(fOut, nOffset, new File(String.valueOf(_sDirPath) + "/" + sFilePath), sFilePath);
                    ++i;
                }
            }
            catch (Exception ex) {
                throw new CkmSoapException(ex);
            }
        }
        finally {
            try {
                if (fOut != null) {
                    fOut.close();
                }
            }
            catch (Exception exception) {}
        }
        return nOffset;
    }

    public int convSFX2Dir(String _sSFXName, String _sDirName) throws CkmSoapException {
        int iId = 0;
        int nOffset = 0;
        byte[] bData = new byte[4096];
        FileInputStream fIn = null;
        FileOutputStream fOut = null;
        try {
            try {
                fIn = new FileInputStream(_sSFXName);
                String sVerInfo = this.readStringFromSFXStream(fIn, "sfx100\u0000".length());
                if (!sVerInfo.equals("sfx100\u0000")) {
                    throw new Exception("wrong SFX version.");
                }
                nOffset = "sfx100\u0000".length();
                while (fIn.available() > 0) {
                    String sFilePath = this.readStringFromSFXStream(fIn, 256);
                    sFilePath = this.convSFXPath(sFilePath);
                    iId = this.readIntFromSFXStream(fIn);
                    int ibOffset = this.readIntFromSFXStream(fIn);
                    int ieOffset = this.readIntFromSFXStream(fIn);
                    int nLeft = ieOffset - ibOffset;
                    if (ibOffset <= 0 || ieOffset <= 0 || nLeft < 0) {
                        throw new Exception("Bad SFX Item Offset");
                    }
                    if (sFilePath == null || sFilePath.charAt(0) == '\u0000' || sFilePath.indexOf("..") != -1) {
                        throw new Exception("Bad FileName in SFX");
                    }
                    try {
                        sFilePath = String.valueOf(_sDirName) + "/" + sFilePath;
                        PTools.createDir(false, sFilePath);
                        fOut = new FileOutputStream(sFilePath);
                        while (nLeft > 0) {
                            int nRead = bData.length;
                            if (nLeft <= bData.length) {
                                nRead = nLeft;
                            }
                            if ((nRead = fIn.read(bData, 0, nRead)) <= 0) {
                                throw new Exception("Read SFX failed, Bad data block");
                            }
                            fOut.write(bData, 0, nRead);
                            if (nLeft > nRead) {
                                nLeft -= nRead;
                                continue;
                            }
                            nLeft = 0;
                        }
                    }
                    finally {
                        if (fOut != null) {
                            fOut.close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new CkmSoapException(ex);
            }
        }
        finally {
            try {
                if (fIn != null) {
                    fIn.close();
                }
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    public void CopyFile(File in, File out) throws Exception {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }
}

