/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.ftp.protocol;

import com.trs.net.ftp.protocol.FtpClientPI;
import com.trs.net.ftp.protocol.FtpProtocolException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class TransferInputStream
extends FilterInputStream {
    private boolean m_zBinary;
    private boolean m_zLastCR = false;
    private boolean m_zCRLFNL = "\r\n".equals(System.getProperty("line.separator"));
    private FtpClientPI m_oClient;

    public TransferInputStream(FtpClientPI ftpClientPI, InputStream in) {
        super(in);
        this.m_zBinary = ftpClientPI.getDataType() == 73;
        this.m_oClient = ftpClientPI;
    }

    public int read() throws IOException {
        if (this.isClosed()) {
            return -1;
        }
        if (this.m_zBinary) {
            int c = this.in.read();
            if (c == -1) {
                this.close();
            }
            return c;
        }
        if (this.m_zLastCR) {
            this.m_zLastCR = false;
            return 10;
        }
        int c = this.in.read();
        if (c == 13) {
            c = this.in.read();
            switch (c) {
                case -1: {
                    this.close();
                    return 13;
                }
                case 0: {
                    return 13;
                }
                case 10: {
                    if (this.m_zCRLFNL) {
                        this.m_zLastCR = true;
                        return 13;
                    }
                    return 10;
                }
            }
            throw new FtpProtocolException("Unexpected CR's follower:" + c);
        }
        return c;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isClosed()) {
            return -1;
        }
        if (this.m_zBinary) {
            int iLength = this.in.read(b, off, len);
            if (iLength == -1) {
                this.close();
            }
            return iLength;
        }
        int c = 0;
        int old = off;
        while (--len >= 0) {
            c = this.read();
            if (c == -1) break;
            b[off++] = (byte)c;
        }
        return off > old ? off - old : -1;
    }

    public int read(byte[] b) throws IOException {
        if (this.isClosed()) {
            return -1;
        }
        if (this.m_zBinary) {
            int iLength = this.in.read(b, 0, b.length);
            if (iLength == -1) {
                this.close();
            }
            return iLength;
        }
        return this.read(b, 0, b.length);
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        super.close();
        this.m_oClient.shutDataConnection();
        this.m_oClient = null;
    }

    private final boolean isClosed() {
        return this.m_oClient == null;
    }
}

