/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.view.util;

import com.trs.cis4.gateway.bean.AgentConfig;
import com.trs.cis4.gateway.bean.FieldData;
import com.trs.cis4.gateway.bean.MachineData;
import com.trs.cis4.gateway.bean.RdbConfig;
import com.trs.cis4.gateway.bean.RunConfig;
import com.trs.cis4.gateway.bean.TrsConfig;
import com.trs.cis4.util.ExceptionUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissionValidate {
    public static void validateMission(AgentConfig agentConfig) throws ExceptionUtil {
        String task_name = agentConfig.getTask_name();
        if (task_name == null || "".equals(task_name) || "temp".equalsIgnoreCase(task_name)) {
            throw new ExceptionUtil(1, "\u4efb\u52a1\u540d\u4e3a\u7a7a", "\u4efb\u52a1\u540d\u4e3a\u552f\u4e00\u6807\u8bc6\uff0c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        int rdb_type = agentConfig.getRdbConfig().getRdb_type();
        int trs_policy = agentConfig.getTrsConfig().getTrs_policy();
        if (rdb_type == 0) {
            if (trs_policy == 0) {
                MissionValidate.validateTrs(agentConfig.getTrsConfig());
                MissionValidate.validateMachineDatas(agentConfig.getMachine_list());
            } else {
                MissionValidate.validateMachineDatas(agentConfig.getMachine_list());
            }
        } else if (trs_policy == 0) {
            MissionValidate.validateRdb(agentConfig.getRdbConfig());
            MissionValidate.validateFieldDatas(agentConfig.getField_list());
            MissionValidate.validateTrs2(agentConfig.getTrsConfig());
            MissionValidate.validateRunconfig(agentConfig.getRunConfig());
            MissionValidate.validateUpdateMode(agentConfig);
            MissionValidate.validateSynchronizeMode(agentConfig);
        } else {
            MissionValidate.validateRdb(agentConfig.getRdbConfig());
            MissionValidate.validateFieldDatas(agentConfig.getField_list());
            MissionValidate.validateTrs(agentConfig.getTrsConfig());
            MissionValidate.validateMachineDatas(agentConfig.getMachine_list());
            MissionValidate.validateRunconfig(agentConfig.getRunConfig());
            MissionValidate.validateUpdateMode(agentConfig);
            MissionValidate.validateSynchronizeMode(agentConfig);
        }
    }

    private static void validateRdb(RdbConfig rdbConfig) throws ExceptionUtil {
        String rdb_server = rdbConfig.getRdb_server();
        if (rdb_server == null || "".equals(rdb_server)) {
            throw new ExceptionUtil(1, "\u6e90\u6570\u636e\u5e93\u5730\u5740\u4e3a\u7a7a\uff01", "\u5173\u7cfb\u6570\u636e\u5e93\u7684\u8fde\u63a5\u5730\u5740\u5fc5\u987b\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3010\u6e90\u6570\u636e\u5e93\u3011\u9875\uff01");
        }
        String rdb_username = rdbConfig.getRdb_username();
        if (rdb_username == null || "".equals(rdb_username)) {
            throw new ExceptionUtil(1, "\u6e90\u6570\u636e\u5e93\u7528\u6237\u540d\u4e3a\u7a7a\uff01", "\u5173\u7cfb\u6570\u636e\u5e93\u7684\u8fde\u63a5\u5730\u5740\u7684\u7528\u6237\u540d\u5fc5\u987b\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3010\u6e90\u6570\u636e\u5e93\u3011\u9875\uff01");
        }
        String rdb_password = rdbConfig.getRdb_password();
        if (rdb_password == null || "".equals(rdb_password)) {
            throw new ExceptionUtil(1, "\u6e90\u6570\u636e\u5e93\u53e3\u4ee4\u4e3a\u7a7a\uff01", "\u5173\u7cfb\u6570\u636e\u5e93\u7684\u8fde\u63a5\u5730\u5740\u7684\u53e3\u4ee4\u5fc5\u987b\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3010\u6e90\u6570\u636e\u5e93\u3011\u9875\uff01");
        }
        if (rdbConfig.isRdb_view()) {
            String rdb_vname = rdbConfig.getRdb_vname();
            if (rdb_vname == null || "".equals(rdb_vname)) {
                throw new ExceptionUtil(1, "\u6e90\u6570\u636e\u5e93\u89c6\u56fe\u4e3a\u7a7a\uff01", "\u6e90\u6570\u636e\u5e93\u89c6\u56fe\u5fc5\u987b\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3010\u5b57\u6bb5\u8bbe\u7f6e\u3011\u9875\uff01");
            }
            String rdb_table = rdbConfig.getRdb_table();
            if (rdb_table == null || "".equals(rdb_table)) {
                throw new ExceptionUtil(1, "\u6e90\u6570\u636e\u5e93\u89c6\u56fe\u4e3b\u8868\u4e3a\u7a7a\uff01", "\u6e90\u6570\u636e\u5e93\u89c6\u56fe\u4e3b\u8868\u5fc5\u987b\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3010\u5b57\u6bb5\u8bbe\u7f6e\u3011\u9875\uff01");
            }
        } else {
            String rdb_table = rdbConfig.getRdb_table();
            if (rdb_table == null || "".equals(rdb_table)) {
                throw new ExceptionUtil(1, "\u6e90\u6570\u636e\u5e93\u6e90\u8868\u4e3a\u7a7a\uff01", "\u6e90\u6570\u636e\u5e93\u6e90\u8868\u5fc5\u987b\u4e0d\u4e3a\u7a7a\uff01\u8bf7\u68c0\u67e5\u3010\u5b57\u6bb5\u8bbe\u7f6e\u3011\u9875");
            }
        }
    }

    private static void validateFieldDatas(List<FieldData> fieldDatas) throws ExceptionUtil {
        if (fieldDatas == null || fieldDatas.size() < 1) {
            throw new ExceptionUtil(1, "\u76ee\u6807\u6570\u636e\u5e93\u7684\u5b57\u6bb5\u4e2a\u6570\u4e3a0", "\u76ee\u6807\u6570\u636e\u5e93\u7684\u5b57\u6bb5\u4e2a\u6570\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u3010\u5b57\u6bb5\u8bbe\u7f6e\u3011\u9875\uff01");
        }
        for (FieldData fieldData : fieldDatas) {
            String field_name2;
            if (!fieldData.isField_upk() || (field_name2 = fieldData.getFieldData2().getField_name2()) != null && !field_name2.equals("")) continue;
            throw new ExceptionUtil(1, "\u5b57\u6bb5\u6620\u5c04\u4e3b\u952e\u672a\u5339\u914d", "\u5b57\u6bb5\u6620\u5c04\u4e3b\u952e\u672a\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3010\u5b57\u6bb5\u6620\u5c04\u3011\u9875\uff01");
        }
    }

    private static void validateTrs(TrsConfig trsConfig) throws ExceptionUtil {
        int node_num = trsConfig.getNode_num();
        if (node_num < 1) {
            throw new ExceptionUtil(1, "\u76ee\u6807\u670d\u52a1\u5668\u5730\u5740\u4e2a\u6570\u4e3a0", "\u672a\u914d\u7f6e\u76ee\u6807\u670d\u52a1\u5668\u5730\u5740\uff0c\u8bf7\u68c0\u67e5\u3010\u76ee\u6807\u5e93\u3011\u9875\u7684\u670d\u52a1\u5668\u8fde\u63a5\u5730\u5740\uff01");
        }
        String trs_directory = trsConfig.getTrs_directory();
        if (trs_directory == null || trs_directory.equals("")) {
            throw new ExceptionUtil(1, "\u683c\u5f0f\u6587\u4ef6\u4e34\u65f6\u76ee\u5f55\u4e3a\u7a7a", "\u683c\u5f0f\u6587\u4ef6\u4e34\u65f6\u76ee\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u9875\uff01");
        }
    }

    private static void validateTrs2(TrsConfig trsConfig) throws ExceptionUtil {
        String trs_directory = trsConfig.getTrs_directory();
        if (trs_directory == null || trs_directory.equals("")) {
            throw new ExceptionUtil(1, "\u683c\u5f0f\u6587\u4ef6\u4e34\u65f6\u76ee\u5f55\u4e3a\u7a7a", "\u683c\u5f0f\u6587\u4ef6\u4e34\u65f6\u76ee\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3010\u5b57\u6bb5\u9009\u62e9\u3011\u9875\uff01");
        }
    }

    private static void validateMachineDatas(List<MachineData> machineDatas) throws ExceptionUtil {
        if (machineDatas == null || machineDatas.size() < 1) {
            throw new ExceptionUtil(1, "\u672a\u914d\u7f6e\u76ee\u6807\u670d\u52a1\u5668\u5730\u5740", "\u672a\u914d\u7f6e\u76ee\u6807\u670d\u52a1\u5668\u5730\u5740\uff0c\u8bf7\u68c0\u67e5\u3010\u76ee\u6807\u5e93\u3011\u9875\u7684\u670d\u52a1\u5668\u8fde\u63a5\u5730\u5740\uff01");
        }
    }

    private static void validateRunconfig(RunConfig runConfig) throws ExceptionUtil {
        if (runConfig == null) {
            throw new ExceptionUtil(1, "\u8fd0\u884c\u8ba1\u5212\u6a21\u5757\u672a\u914d\u7f6e", "\u8fd0\u884c\u8ba1\u5212\u6a21\u5757\u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3010\u8fd0\u884c\u8ba1\u5212\u3011\u9875\uff01");
        }
    }

    private static void validateUpdateMode(AgentConfig agentConfig) throws ExceptionUtil {
        int rdb_seg_thread = agentConfig.getRdbConfig().getRdb_seg_thread();
        if (rdb_seg_thread == 0) {
            throw new ExceptionUtil(1, "\u7ebf\u7a0b\u603b\u6570\u4e3a0", "\u7ebf\u7a0b\u603b\u6570\u4e0d\u80fd\u5c11\u4e8e1\uff0c\u8bf7\u68c0\u67e5\u3010\u66f4\u65b0\u65b9\u5f0f\u3011\u9875\u201c\u9ad8\u7ea7\u201d\u9009\u9879\uff01");
        }
    }

    private static void validateSynchronizeMode(AgentConfig agentConfig) throws ExceptionUtil {
        List<String> node_list;
        TrsConfig trsConfig = agentConfig.getTrsConfig();
        if (trsConfig == null) {
            throw new ExceptionUtil(1, "\u76ee\u6807\u6570\u636e\u5e93\u7cfb\u5217\u914d\u7f6e\u4e3a\u7a7a");
        }
        int node_type = trsConfig.getNode_type();
        if (node_type == 2 && ((node_list = agentConfig.getNode_list()) == null || node_list.size() < 1)) {
            throw new ExceptionUtil(1, "\u6b63\u5219\u8868\u8fbe\u5f0f\u5217\u8868\u4e3a\u7a7a", "\u6b63\u5219\u8868\u8fbe\u5f0f\u5217\u8868\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3010\u540c\u6b65\u65b9\u5f0f\u3011\u9875\uff01");
        }
    }
}

