/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.dao.impl;

import com.trs.cis4.bean.SysUser;
import com.trs.cis4.gateway.dao.IBaseSysUserDAO;
import com.trs.cis4.gateway.logic.util.GWSysApplication;
import com.trs.cis4.util.ConstUtil;
import com.trs.cis4.util.ExceptionUtil;
import com.trs.cis4.util.XmlUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSysUserDAOImpl
implements IBaseSysUserDAO {
    private String config_xml_path;
    protected HashMap<String, SysUser> sysUserMap = new HashMap();

    public void setConfig_xml_path(String config_xml_path) {
        this.config_xml_path = config_xml_path;
    }

    public String getConfig_xml_path() {
        return this.config_xml_path;
    }

    @Override
    public void delete(String userid) throws ExceptionUtil {
        this.sysUserMap.remove(userid);
        this.writeSysUsers(this.sysUserMap);
    }

    @Override
    public SysUser get(String userid) throws ExceptionUtil {
        if (this.sysUserMap.isEmpty()) {
            this.sysUserMap = this.readSysUsers();
        }
        return this.sysUserMap.get(userid);
    }

    @Override
    public List<SysUser> getAlls() throws ExceptionUtil {
        if (this.sysUserMap.isEmpty()) {
            this.sysUserMap = this.readSysUsers();
        }
        ArrayList<SysUser> list = new ArrayList<SysUser>(this.sysUserMap.values());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((SysUser)o1).getUserid().compareToIgnoreCase(((SysUser)o2).getUserid());
            }
        });
        return list;
    }

    @Override
    public void saveOrUpdate(SysUser sysUser) throws ExceptionUtil {
        String userid = sysUser.getUserid();
        this.sysUserMap.put(userid, sysUser);
        this.writeSysUsers(this.sysUserMap);
    }

    protected HashMap<String, SysUser> readSysUsers() throws ExceptionUtil {
        try {
            String sep = ConstUtil.DIR_SEPERATOR;
            String filename = String.valueOf(GWSysApplication.getSystemExecuteFolder()) + this.config_xml_path + sep + "sysUsers.xml";
            File file = new File(filename);
            if (!file.exists()) {
                filename = String.valueOf(GWSysApplication.getSystemExecuteFolder()) + this.config_xml_path + sep + "init_sysUsers.xml";
            }
            return (HashMap)XmlUtil.readObject((String)filename);
        }
        catch (Exception e) {
            throw new ExceptionUtil(1, "\u4ecesysUsers.xml\u4e2d\u8bfb\u53d6\u7528\u6237\u65f6\u5931\u8d25!");
        }
    }

    protected void writeSysUsers(HashMap<String, SysUser> map) throws ExceptionUtil {
        try {
            String sep = ConstUtil.DIR_SEPERATOR;
            String filename = String.valueOf(GWSysApplication.getSystemExecuteFolder()) + sep + this.config_xml_path + sep + "sysUsers.xml";
            XmlUtil.writeObject((String)filename, map);
        }
        catch (Exception e) {
            throw new ExceptionUtil(1, "\u4fdd\u5b58\u7528\u6237\u5230sysUsers.xml\u65f6\u5931\u8d25!", (Throwable)e);
        }
    }
}

