/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmlutils;

import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class FragmentBuilder
implements ContentHandler {
    XMLReader xmlReader;
    Document doc;
    DocumentFragment fragment;
    Node current;
    boolean firstElement;
    private static String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static String PREFIXES = "http://xml.org/sax/features/namespace-prefixes";

    public FragmentBuilder(XMLReader xMLReader) throws SAXException {
        if (xMLReader == null) {
            throw new IllegalArgumentException("xmlReader argument must not be null.");
        }
        this.xmlReader = xMLReader;
        xMLReader.setContentHandler(this);
        xMLReader.setFeature(NAMESPACES, true);
        xMLReader.setFeature(PREFIXES, true);
    }

    public DocumentFragment parse(Document document, String string) throws SAXException, IOException {
        if (document == null || string == null) {
            throw new IllegalArgumentException("doc and xml arguments must not be null.");
        }
        this.doc = document;
        this.fragment = document.createDocumentFragment();
        this.current = this.fragment;
        this.firstElement = true;
        this.xmlReader.parse(new InputSource(new StringReader(string)));
        return this.fragment;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.firstElement) {
            this.firstElement = false;
            return;
        }
        Element element = this.doc.createElementNS(string, string3);
        this.current.appendChild(element);
        this.current = element;
        int n = 0;
        while (n < attributes.getLength()) {
            String string4 = attributes.getURI(n);
            String string5 = attributes.getQName(n);
            String string6 = attributes.getValue(n);
            element.setAttributeNS(string4, string5, string6);
            ++n;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.current = this.current.getParentNode();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Text text = this.doc.createTextNode(new String(cArray, n, n2));
        this.current.appendChild(text);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        ProcessingInstruction processingInstruction = this.doc.createProcessingInstruction(string, string2);
        this.current.appendChild(processingInstruction);
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
    }
}

