/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.publish;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.infra.util.store.FileService;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.ImageLibHelper;
import java.io.File;

public class WCMTagParserImage
extends BaseTagParser {
    IImageLibConfig m_oImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_IMAGE");
            tbi.setDesc("TRS_IMAGE");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("IMAGE");
            tbai.setEnumValue(new String[]{"IMAGE", "_RECURL", "UPLOADALL"});
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("INDEX");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("SIZE");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("75");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("EXTRA");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("WIDTH");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("HEIGHT");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("UPLOAD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("RETURNFILESIZE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbai.setEnumValue(new String[]{"true", "false"});
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("UPLOADALL");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOLINK");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TARGET");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("_self");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ORIGINAL");
            tbai.setDesc(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label1", "\u83b7\u53d6\u539f\u56fe"));
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("URLISABS");
            tbai.setDesc(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label2", "\u662f\u5426\u4f7f\u7528\u7edd\u5bf9\u8def\u5f84"));
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        IPublishElement upperHost = _context.getUpperHost();
        if (upperHost.isFolder()) {
            throw new WCMException(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label3", "TRS_IMAGE\u7f6e\u6807\u4e0d\u80fd\u5e94\u7528\u5230\u680f\u76ee[") + upperHost.getInfo() + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label4", "]\u4e0a\uff01"));
        }
        if (!(upperHost.getSubstance() instanceof Document)) {
            throw new WCMException(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label5", "TRS_IMAGE\u7f6e\u6807\u76ee\u524d\u53ea\u80fd\u7528\u5230\u6587\u6863\u5bf9\u8c61\u4e0a\uff0c\u4e0d\u80fd\u7528\u5230\u5176\u5b83\u5bf9\u8c61[") + upperHost.getInfo() + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label4", "]\u4e0a\uff01"));
        }
        Document document = (Document)upperHost.getSubstance();
        String field = _context.getAttribute("FIELD");
        if ("UPLOADALL".equalsIgnoreCase(field)) {
            String[] pAllImages = ImageLibHelper.getAllImageFiles(document);
            for (int i = 0; i < pAllImages.length; ++i) {
                this.distributeImageFile(_context, upperHost, pAllImages[i]);
            }
            if ("true".equalsIgnoreCase(_context.getAttribute("ORIGINAL"))) {
                Document tmpDocument = Document.findById(document.getId(), "attribute");
                String sSrcFile = tmpDocument.getAttributeValue("SRCFILE");
                this.distributeImageFile(_context, upperHost, sSrcFile);
            }
            return null;
        }
        String sImageFile = null;
        if ("true".equals(_context.getAttribute("ORIGINAL"))) {
            Document tmpDocument = Document.findById(document.getId(), "attribute");
            sImageFile = tmpDocument.getAttributeValue("SRCFILE");
        } else {
            int[] pAllScale = this.m_oImageLibConfig.getScaleSizes();
            int nIndex = _context.getAttribute("INDEX", -1);
            int nSize = _context.getAttribute("SIZE", -1);
            if (nIndex >= pAllScale.length) {
                nIndex = pAllScale.length - 1;
            }
            if (nIndex < 0) {
                nSize = this.makeNewSize(pAllScale, nSize);
            }
            if (nIndex == -1) {
                if (nSize <= 0) {
                    throw new WCMException(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label6", "TRS_IMAGE\u7f6e\u6807\u4e0a\u5fc5\u987b\u6307\u5b9aIndex\u6216\u8005Size!"));
                }
                sImageFile = ImageLibHelper.getImageFileNameByScale(document, nSize);
            } else {
                sImageFile = ImageLibHelper.getImageFileNameByScaleIndex(document, nIndex);
            }
            if (sImageFile == null || sImageFile.length() <= 0) {
                String[] pSrcImageFiles = ImageLibHelper.getAllImageFiles(document);
                if (pSrcImageFiles == null || pSrcImageFiles.length <= 0) {
                    return null;
                }
                sImageFile = pSrcImageFiles[pSrcImageFiles.length - 1];
            }
            if (sImageFile == null || sImageFile.length() <= 0) {
                _context.addWarning(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label7", "\u6839\u636eTRS_IMAGE\u7f6e\u6807\u4e0a\u627e\u4e0d\u5230[") + document + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label8", "]\u6307\u5b9aIndex[") + nIndex + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label9", "]\u6216\u8005Size[") + nSize + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label10", "]\u627e\u4e0d\u5230\u56fe\u7247!"));
                return null;
            }
        }
        if ("IMAGE".equalsIgnoreCase(field) || _context.getAttribute("UPLOAD", false) || CMyString.isEmpty(field)) {
            this.distributeImageFile(_context, upperHost, sImageFile);
        }
        PublishPathCompass compass = _context.getPathCompass();
        String sUrl = compass.getAbsoluteHttpPath(upperHost);
        if (_context.getAttribute("RETURNFILESIZE", false)) {
            FilesMan oFilesMan = FilesMan.getFilesMan();
            String sAbsoluteFileName = oFilesMan.mapFilePath(sImageFile, 0);
            FileService file = new FileService(sAbsoluteFileName + sImageFile);
            return new String[]{FileHelper.convertFileSize(file.length())};
        }
        if (!_context.getAttribute("URLISABS", false)) {
            sUrl = HtmlUtil.calRelativePath(sUrl, _context.getPageHttpPath());
        }
        sUrl = sUrl + sImageFile;
        if ("_RECURL".equalsIgnoreCase(field)) {
            return new String[]{sUrl};
        }
        Document docuemnt = (Document)upperHost.getSubstance();
        String sImageDesc = docuemnt.getTitle();
        String sExtra = _context.getAttribute("EXTRA");
        String sResult = HtmlUtil.renderImage(sUrl, sImageDesc, sExtra, _context.getAttribute("WIDTH"), _context.getAttribute("HEIGHT"));
        if (_context.getAttribute("AUTOLINK", true)) {
            sResult = WCMTagParserImage.addAutoLink(sResult, _context);
        }
        return new String[]{sResult};
    }

    private int makeNewSize(int[] _pAllScale, int _nOldSize) {
        int i;
        boolean bContainSize = false;
        for (i = 0; i < _pAllScale.length; ++i) {
            if (_pAllScale[i] != _nOldSize) continue;
            bContainSize = true;
            break;
        }
        for (i = _pAllScale.length - 1; !bContainSize && i >= 0; --i) {
            if (_pAllScale[i] >= _nOldSize) continue;
            if (i == _pAllScale.length - 1) {
                _nOldSize = _pAllScale[i];
                break;
            }
            int nPreOffset = _pAllScale[i + 1] - _nOldSize;
            int nCurrOffset = _nOldSize - _pAllScale[i];
            if (nPreOffset > nCurrOffset) {
                _nOldSize = _pAllScale[i];
                break;
            }
            _nOldSize = _pAllScale[i + 1];
            break;
        }
        return _nOldSize;
    }

    private void distributeImageFile(PublishTagContext _context, IPublishElement _upperHost, String _imageFile) throws WCMException {
        String sFileName = _imageFile;
        String sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName;
        if (!CMyFile.fileExists(sSrcFilePathName)) {
            _context.addWarning(_upperHost.getInfo() + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label11", "-\u56fe\u7247"), _upperHost.getId(), I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label12", "\u5728\u78c1\u76d8\u4e0a\u6ca1\u6709\u627e\u5230(") + _upperHost.getInfo() + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label13", ")\u7684\u56fe\u7247[") + sFileName + "]");
            return;
        }
        PublishPathCompass compass = _context.getPathCompass();
        boolean bPreview = _context.isPreview();
        String sLocalPath = CMyString.setStrEndWith(compass.getLocalPath(_upperHost, bPreview), File.separatorChar);
        PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
        try {
            CMyFile.copyFile(sSrcFilePathName, sLocalPath + sFileName);
        }
        catch (CMyException e) {
            e.printStackTrace();
            _context.addWarning(_upperHost.getInfo() + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label11", "-\u56fe\u7247"), _upperHost.getId(), I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label14", "\u62f7\u8d1d(") + _upperHost.getInfo() + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label13", ")\u7684\u56fe\u7247[") + sFileName + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label15", "]\u53d1\u751f\u5f02\u5e38:") + CMyException.getStackTraceText(e));
        }
        if (!bPreview) {
            IPublishFolder folder;
            if (_upperHost instanceof IPublishContent && (folder = _upperHost.getFolder()) == null) {
                IPublishContent content = (IPublishContent)_upperHost;
                content.setFolder(content.getOriginalHome());
                _upperHost = content;
            }
            _context.getFileDistributeShip().distributeFile(sSrcFilePathName, _upperHost);
        }
    }

    protected static String addAutoLink(String _sValue, PublishTagContext _context) throws WCMException {
        String sTarget = _context.getAttribute("TARGET");
        String sExtra = "";
        String sLinkText = _context.getAttribute("LINKTEXT");
        String sAltText = null;
        String sUrl = WCMTagParserImage.getAutoLinkUrl(_context);
        if (!_context.getUpperHost().isLink()) {
            sUrl = HtmlUtil.calRelativePath(sUrl, _context.getPageHttpPath());
        }
        return HtmlUtil.renderLink(sUrl, sTarget, sAltText, sExtra, _sValue, sLinkText);
    }

    protected static String getAutoLinkUrl(PublishTagContext _context) throws WCMException {
        IPublishElement element = _context.getUpperHost();
        if (element == null) {
            throw new WCMException(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label16", "\u6ca1\u6709\u627e\u5230UpperHost\u5bf9\u8c61!"));
        }
        if (!(element instanceof IPublishContent)) {
            throw new WCMException(I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label17", "\u5f53\u524dUpperHost[") + element.getInfo() + I18NMessage.get(WCMTagParserImage.class, "WCMTagParserImage.label18", "]\u4e0d\u662fIPublishContent\u5bf9\u8c61"));
        }
        IPublishContent content = (IPublishContent)element;
        PublishPathCompass compass = _context.getPathCompass();
        switch (content.getBodyType()) {
            case 40: {
                String sFileName = content.getFileName();
                return compass.getAbsoluteHttpPath(_context.getUpperHost()) + sFileName;
            }
            case 30: {
                return content.getLinkUrl();
            }
        }
        return compass.getHttpUrl((IPublishContent)_context.getUpperHost(), 0);
    }
}

