/*
 * Decompiled with CFR 0.152.
 */
package com.trs.util;

import com.trs.cms.ContextHelper;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.MetaView;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;

public class ResetClassInfoOfViewData {
    public String[] aFieldInfo = new String[]{"subcat", "themecat"};
    public int[] aClassInfoRootId = new int[]{23, 56};
    ClassInfos[] aClassInfos = new ClassInfos[2];
    public int nRecordTotalCount = 0;
    public int nCurrIndex = 0;
    public int nCountForEach = 500;
    private MetaView view = null;

    public void execute() throws WCMException {
        this.nRecordTotalCount = this.getCountOfViewDatas();
        for (int i = 0; i < this.aClassInfoRootId.length; ++i) {
            this.aClassInfos[i] = this.getLeafClassInfo(this.aClassInfoRootId[i]);
        }
        this.view = MetaView.findById(39);
        this.handleViewDatas();
    }

    public int getCountOfViewDatas() throws WCMException {
        WCMFilter filter = new WCMFilter();
        filter.setFrom("WCMMetaTableGovInfo");
        int nCount = DBManager.getDBManager().sqlExecuteCountQuery(filter);
        System.out.println("--------------------------------------------");
        System.out.println(I18NMessage.get(ResetClassInfoOfViewData.class, "ResetClassInfoOfViewData.label1", "\u83b7\u53d6\u8bb0\u5f55\u603b\u6570\uff1a") + nCount);
        System.out.println("--------------------------------------------");
        return nCount;
    }

    private ClassInfos getLeafClassInfo(int nClassInfoId) throws WCMException {
        System.out.println("--------------------------------------------");
        System.out.println(I18NMessage.get(ResetClassInfoOfViewData.class, "ResetClassInfoOfViewData.label2", "\u52a0\u8f7d\u5206\u7c7b\u6811\uff1a") + nClassInfoId + I18NMessage.get(ResetClassInfoOfViewData.class, "ResetClassInfoOfViewData.label3", "\u4e0b\u7684\u53f6\u5b50\u8282\u70b9\u4fe1\u606f"));
        System.out.println("--------------------------------------------");
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append("rootId=").append(nClassInfoId);
        sbWhere.append(" and not exists");
        sbWhere.append(" (select 1 from XWCMClassInfo innerT");
        sbWhere.append(" where innerT.parentId = outerT.classInfoid)");
        WCMFilter filter = new WCMFilter("XWCMClassInfo outerT", sbWhere.toString(), "");
        ClassInfos oClassInfos = ClassInfos.openWCMObjs(ContextHelper.getLoginUser(), filter);
        System.out.println("--------------------------------------------");
        System.out.println(I18NMessage.get(ResetClassInfoOfViewData.class, "ResetClassInfoOfViewData.label4", "\u53f6\u5b50\u8282\u70b9\u6570\u4e3a\uff1a") + oClassInfos.size());
        System.out.println("--------------------------------------------");
        return oClassInfos;
    }

    public void handleViewDatas() throws WCMException {
        int nRows = this.nRecordTotalCount / this.nCountForEach;
        System.out.println("--------------------------------------------");
        System.out.println(I18NMessage.get(ResetClassInfoOfViewData.class, "ResetClassInfoOfViewData.label5", "\u603b\u5171\u9700\u8981\u5904\u7406") + nRows + I18NMessage.get(ResetClassInfoOfViewData.class, "ResetClassInfoOfViewData.label6", "\u9875\u7684\u6570\u636e"));
        System.out.println("--------------------------------------------");
        for (int i = 0; i < nRows; ++i) {
            MetaViewDatas oViewDatas = this.getViewDatas(i + 1);
            this.handleViewDatas(oViewDatas, i);
        }
    }

    private MetaViewDatas getViewDatas(int nPageIndex) throws WCMException {
        System.out.println("--------------------------------------------");
        System.out.println(I18NMessage.get(ResetClassInfoOfViewData.class, "ResetClassInfoOfViewData.label7", "\u83b7\u53d6\u7b2c\uff1a") + nPageIndex + I18NMessage.get(ResetClassInfoOfViewData.class, "ResetClassInfoOfViewData.label6", "\u9875\u7684\u6570\u636e"));
        System.out.println("--------------------------------------------");
        MetaViewDatas oViewDatas = new MetaViewDatas(this.view);
        oViewDatas.setSelectFieldsOfMetaTable("MetaDataId");
        oViewDatas.setPageSize(this.nCountForEach);
        oViewDatas.setCurrPage(nPageIndex);
        oViewDatas.open(new WCMFilter());
        return oViewDatas;
    }

    private void handleViewDatas(MetaViewDatas oViewDatas, int nPageIndex) throws WCMException {
        int nStartIndex = nPageIndex * this.nCountForEach;
        int nEndIndex = (nPageIndex + 1) * this.nCountForEach;
        if (nEndIndex > oViewDatas.size()) {
            nEndIndex = oViewDatas.size();
        }
        System.out.println("--------------------------------");
        System.out.println(I18NMessage.get(ResetClassInfoOfViewData.class, "ResetClassInfoOfViewData.label8", "\u53d6\u6570\u636e[") + nStartIndex + "~" + nEndIndex + "];size:" + oViewDatas.size());
        System.out.println("--------------------------------");
        for (int i = nStartIndex; i < nEndIndex; ++i) {
            MetaViewData oViewData = (MetaViewData)oViewDatas.getAt(i);
            if (oViewData == null) continue;
            for (int j = 0; j < this.aFieldInfo.length; ++j) {
                oViewData.setProperty(this.aFieldInfo[j], this.getClassInfoId(j));
            }
            oViewData.save();
            ++this.nCurrIndex;
            if (this.nCurrIndex % 50 != 0) continue;
            System.out.println("--------------------------------");
            System.out.println(I18NMessage.get(ResetClassInfoOfViewData.class, "ResetClassInfoOfViewData.label9", "\u5df2\u5904\u7406\u7b2c\uff1a") + this.nCurrIndex + I18NMessage.get(ResetClassInfoOfViewData.class, "ResetClassInfoOfViewData.label10", "\u6761\u8bb0\u5f55\uff0cid\uff1a") + oViewData.getId());
            System.out.println("--------------------------------");
        }
    }

    private int getClassInfoId(int index) {
        int nClassInfoCount = this.aClassInfos[index].size();
        return this.aClassInfos[index].getIdAt(this.nCurrIndex % nClassInfoCount);
    }
}

