/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.tools.BlockCommentLocaleChecker;
import com.trs.tools.FCKLANGLocaleChecker;
import com.trs.tools.HTMLCommentLocaleChecker;
import com.trs.tools.ILocaleChecker;
import com.trs.tools.JSPCommentLocaleChecker;
import com.trs.tools.LocaleInfo;
import com.trs.tools.LocaleServerLocaleChecker;
import com.trs.tools.ScriptLineCommentLocaleChecker;
import com.trs.tools.StyleLocaleChecker;
import com.trs.tools.WCMAntParamLocaleChecker;
import com.trs.tools.wcmLANGLocaleChecker;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class LocaleAnalyzer {
    private static Logger logger = Logger.getLogger(LocaleAnalyzer.class);
    private static Pattern chinesePattern = Pattern.compile("([\u4e00-\u9fbb])");
    private String m_sRootPath;
    private String m_sOutputFile;
    private ILocaleChecker[] m_oLocaleCheckers;
    private StringBuffer m_sbResult;
    private String[] m_sFileType = new String[]{".jsp,", ".html", ".htm", ".js"};

    public LocaleAnalyzer(String sRootPath, String sOutputFile, String sFileType) {
        this.m_sRootPath = new FileService(sRootPath.replace('/', File.separatorChar).replace('\\', File.separatorChar)).getAbsolutePath();
        this.m_sOutputFile = sOutputFile.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (!CMyString.isEmpty(sFileType)) {
            this.m_sFileType = sFileType.split(",");
        }
    }

    public static void main(String[] args) throws CMyException {
        if (args.length < 2) {
            StringBuffer sbInfo = new StringBuffer(200);
            sbInfo.append("\u6307\u5b9a\u7684\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u9700\u8981\u4e24\u4e2a\u53c2\u6570\n");
            sbInfo.append("\u7b2c\u4e00\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u5904\u7406\u7684\u76ee\u5f55\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("E:/MyWorkspace/TRS.WCM.V6.1.Std/SourceCode/WebApp/app");
            sbInfo.append("\n\u7b2c\u4e8c\u4e2a\u53c2\u6570\u6307\u5b9a\u751f\u6210\u7684\u8d44\u6e90\u6587\u4ef6\u5168\u8def\u5f84\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("E:/localeAnalyzer.txt");
            logger.error((Object)sbInfo);
            return;
        }
        LocaleAnalyzer oInstance = new LocaleAnalyzer(args[0], args[1], args.length > 2 ? args[2] : null);
        oInstance.analyze();
    }

    public void analyze() throws CMyException {
        DebugTimer timer = new DebugTimer();
        timer.start();
        this.m_sbResult = new StringBuffer(500);
        FileService root = new FileService(this.m_sRootPath);
        this.analyzeDir(root);
        CMyFile.writeFile(this.m_sOutputFile, this.m_sbResult.toString());
        timer.stop();
        logger.info((Object)("\u6b64\u6b21\u5206\u6790\u5171\u7528\u65f6[" + timer.getTime() + "]ms"));
    }

    private void analyzeDir(FileStore oDir) {
        if (!this.isAccept(oDir)) {
            return;
        }
        if (oDir.isDirectory()) {
            FileStore[] files = oDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.analyzeDir(files[i]);
            }
            return;
        }
        this.analyzeFile(oDir);
    }

    private boolean isAccept(FileStore oFile) {
        String sFileName = oFile.getAbsolutePath().toLowerCase();
        if (oFile.isDirectory()) {
            if (sFileName.endsWith(".svn") || sFileName.endsWith("cvs")) {
                return false;
            }
            if (sFileName.indexOf("locale") >= 0) {
                return false;
            }
            if (sFileName.indexOf("lang") >= 0) {
                return false;
            }
            if (sFileName.indexOf("easyexample") >= 0) {
                return false;
            }
            if (sFileName.indexOf("metaresource") >= 0) {
                return false;
            }
            if (sFileName.indexOf("video") >= 0) {
                return false;
            }
            if (sFileName.indexOf("39") >= 0) {
                return false;
            }
            if (sFileName.endsWith("special") || sFileName.endsWith("stat")) {
                return true;
            }
            return true;
        }
        if (sFileName.endsWith("cn.js") || sFileName.endsWith("en.js")) {
            return false;
        }
        for (int i = 0; i < this.m_sFileType.length; ++i) {
            if (!sFileName.endsWith(this.m_sFileType[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeFile(FileStore oFile) {
        String sFileName = oFile.getAbsolutePath();
        String encode = CharsetDetector.detect(sFileName);
        BufferedReader reader = null;
        try {
            String sContent = CMyFile.readFile(sFileName, encode);
            int nLength4Data = 0;
            int nLineNumber = 0;
            int nLength4Enter = "\n".length();
            reader = new BufferedReader(new InputStreamReader(oFile.getInputStream(), encode));
            String sLine = reader.readLine();
            while (sLine != null) {
                ++nLineNumber;
                Matcher matcher = chinesePattern.matcher(sLine);
                if (matcher.find()) {
                    int nIndexInLine = matcher.start();
                    LocaleInfo info = new LocaleInfo();
                    info.setContent(sContent);
                    info.setFileName(sFileName);
                    info.setIndexInContent(nLength4Data + nIndexInLine);
                    info.setIndexInLine(nIndexInLine);
                    info.setLine(sLine.toLowerCase());
                    if (!this.accept(info)) {
                        this.m_sbResult.append(sFileName).append("\n");
                        this.m_sbResult.append(nLineNumber).append(":");
                        this.m_sbResult.append(sLine).append("\n\n");
                    }
                }
                nLength4Data += sLine.length() + nLength4Enter;
                sLine = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean accept(LocaleInfo oLocaleInfo) {
        ILocaleChecker[] checkers = this.getLocaleCheckers();
        for (int i = 0; i < checkers.length; ++i) {
            if (!checkers[i].accept(oLocaleInfo)) continue;
            return true;
        }
        return false;
    }

    private ILocaleChecker[] getLocaleCheckers() {
        if (this.m_oLocaleCheckers == null) {
            this.m_oLocaleCheckers = new ILocaleChecker[]{new LocaleServerLocaleChecker(), new wcmLANGLocaleChecker(), new FCKLANGLocaleChecker(), new ScriptLineCommentLocaleChecker(), new WCMAntParamLocaleChecker(), new BlockCommentLocaleChecker(), new HTMLCommentLocaleChecker(), new JSPCommentLocaleChecker(), new StyleLocaleChecker()};
        }
        return this.m_oLocaleCheckers;
    }
}

