/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template.domain;

import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.common.publish.persistent.template.TempAppendixes;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.util.ArrayList;

public class XTemplateExporter {
    private static final String DIRNAME_SRCFILE = "images";

    public String export(Templates _currTemplates) throws WCMException {
        if (_currTemplates == null || _currTemplates.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(XTemplateExporter.class, "XTemplateExporter.label1", "\u6ca1\u6709\u6307\u5b9a\u6709\u6548\u7684\u6a21\u677f,\u65e0\u6cd5\u5b8c\u6210\u5bfc\u51fa!"));
        }
        FilesMan oFilesMan = FilesMan.getFilesMan();
        String sTargetZipFilePath = oFilesMan.getNextFilePathName("ST", "zip");
        String sZipFileDir = oFilesMan.mapFilePath(sTargetZipFilePath, 0);
        ArrayList<String> arrTempSrcDir2Zip = new ArrayList<String>();
        try {
            Template currTemplate = null;
            String sExportedTemplateFile = null;
            for (int i = 0; i < _currTemplates.size(); ++i) {
                currTemplate = (Template)_currTemplates.getAt(i);
                sExportedTemplateFile = this.export(currTemplate, sZipFileDir);
                if (arrTempSrcDir2Zip.contains(sExportedTemplateFile)) continue;
                arrTempSrcDir2Zip.add(sExportedTemplateFile);
            }
        }
        catch (CMyException ex) {
            throw new WCMException(1100, I18NMessage.get(XTemplateExporter.class, "XTemplateExporter.label2", "\u5bfc\u51fa\u6a21\u677f\u65f6,\u751f\u6210\u76f8\u5173\u6587\u4ef6\u53d1\u751f\u5f02\u5e38!"), ex);
        }
        try {
            CMyZip oMyZip = new CMyZip();
            oMyZip.setZipFileName(sTargetZipFilePath);
            for (int nDirIndex = 0; nDirIndex < arrTempSrcDir2Zip.size(); ++nDirIndex) {
                String sTempSrcDir2Zip = (String)arrTempSrcDir2Zip.get(nDirIndex);
                FileStore[] files = new FileService(sTempSrcDir2Zip).listFiles();
                for (int nFIndex = 0; nFIndex < files.length; ++nFIndex) {
                    FileStore file = files[nFIndex];
                    if (file.isDirectory()) {
                        FileStore[] subDirFiles = file.listFiles();
                        for (int i = 0; i < subDirFiles.length; ++i) {
                            oMyZip.addToZip(subDirFiles[i].getPath(), true);
                        }
                        continue;
                    }
                    oMyZip.addToZip(file.getPath(), false);
                }
            }
            oMyZip.setZipWithChildDirPath(true);
            oMyZip.done();
            for (int i = 0; i < arrTempSrcDir2Zip.size(); ++i) {
                String sTempSrcDir2Zip = (String)arrTempSrcDir2Zip.get(i);
                CMyFile.deleteDir(sTempSrcDir2Zip);
            }
        }
        catch (Exception ex) {
            try {
                oFilesMan.deleteFile(sTargetZipFilePath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new WCMException(1100, I18NMessage.get(XTemplateExporter.class, "XTemplateExporter.label3", "\u5bfc\u51fa\u6a21\u677f\u65f6,\u538b\u7f29\u6587\u4ef6\u53d1\u751f\u5f02\u5e38!"), ex);
        }
        return CMyFile.extractFileName(sTargetZipFilePath);
    }

    private String export(Template _oCurrTemplate, String _sZipFileDir) throws WCMException, CMyException {
        String sTemplateSrc = _oCurrTemplate.getTextWithImgFilter("./images/", true, false);
        HierarchyEntity oDirHierarchicalEntity = this.makeHierarchicalDir4Template(_oCurrTemplate);
        String result = _sZipFileDir + oDirHierarchicalEntity.getBaseDir();
        String sTemplateExt = _oCurrTemplate.getOutputFileExt();
        sTemplateExt = !CMyString.isEmpty(sTemplateExt) ? "." + sTemplateExt : "";
        String sFileName = _sZipFileDir + oDirHierarchicalEntity.getFullDir() + _oCurrTemplate.getName() + sTemplateExt;
        try {
            String sEncoding = this.getTemplateFileWriteEncoding(_oCurrTemplate);
            CMyFile.writeFile(sFileName, sTemplateSrc, sEncoding);
        }
        catch (CMyException ex) {
            throw new WCMException(1100, I18NMessage.get(XTemplateExporter.class, "XTemplateExporter.label4", "\u6839\u636e\u6a21\u677f\u7684\u5185\u5bb9\u521b\u5efa\u76f8\u5bf9\u5e94\u7684\u6a21\u677f\u6587\u4ef6\u53d1\u751f\u5f02\u5e38!"), ex);
        }
        TempAppendixes aTempApds = _oCurrTemplate.getAppendixes(ContextHelper.getLoginUser());
        String sApdFilePath = FilesMan.getFilesMan().getTemplateAppendixPath(_oCurrTemplate.getRootType(), _oCurrTemplate.getRootId(), 0, true);
        String sTempApdFileName = null;
        String sSysApdSrcFileName = null;
        for (int i = 0; i < aTempApds.size(); ++i) {
            TempAppendix aTempApd = (TempAppendix)aTempApds.getAt(i);
            if (aTempApd == null) continue;
            sSysApdSrcFileName = sApdFilePath + aTempApd.getFile();
            sTempApdFileName = _sZipFileDir + oDirHierarchicalEntity.getFullDir() + DIRNAME_SRCFILE + File.separator + aTempApd.getFile();
            if (!CMyFile.fileExists(sSysApdSrcFileName)) continue;
            CMyFile.copyFile(sSysApdSrcFileName, sTempApdFileName);
        }
        return result;
    }

    private String getTemplateFileWriteEncoding(Template _oCurrTemplate) {
        String result = null;
        try {
            IPublishFolder root = _oCurrTemplate.getRoot();
            result = root.getEncoding();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public HierarchyEntity makeHierarchicalDir4Template(Template _oTemplate) throws WCMException {
        ArrayList<String> arChnlLoop = new ArrayList<String>();
        if (_oTemplate.getFolderType() == 103) {
            String sHierachy = WebSite.findById(_oTemplate.getRootId()).getName() + File.separator;
            return new HierarchyEntity(sHierachy, sHierachy);
        }
        Channel oChnl = Channel.findById(_oTemplate.getFolderId());
        arChnlLoop.add(oChnl.getName());
        for (Channel oParent = oChnl.getParent(); oParent != null; oParent = oParent.getParent()) {
            arChnlLoop.add(oParent.getName());
        }
        arChnlLoop.add(oChnl.getSite().getName());
        Object[] arReversed = new String[arChnlLoop.size()];
        int i = arReversed.length;
        while (i > 0) {
            arReversed[--i] = (String)arChnlLoop.get(arReversed.length - 1 - i);
        }
        String sChnlHierachy = CMyString.join(arReversed, File.separator);
        return new HierarchyEntity(oChnl.getSite().getName() + File.separator, sChnlHierachy + File.separator);
    }

    public class HierarchyEntity {
        private String m_sBaseDir;
        private String m_sFullDir;

        public HierarchyEntity() {
        }

        public HierarchyEntity(String _sBaseDir, String _sFullDir) {
            this.m_sBaseDir = _sBaseDir;
            this.m_sFullDir = _sFullDir;
        }

        public String getBaseDir() {
            return this.m_sBaseDir;
        }

        public void setBaseDir(String baseDir) {
            this.m_sBaseDir = baseDir;
        }

        public String getFullDir() {
            return this.m_sFullDir;
        }

        public void setFullDir(String fullDir) {
            this.m_sFullDir = fullDir;
        }
    }
}

