/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.scm.domain.SCMAuthServer;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.SCMGroup;
import com.trs.scm.persistent.SCMMicroContent;
import com.trs.scm.persistent.SCMMicroContents;
import com.trs.scm.publish.domain.ISCMMCPublishTaskMgr;
import com.trs.scm.publish.domain.SCMMCPublishServer;
import com.trs.scm.publish.persistent.SCMMCPublishTask;
import com.trs.scm.publish.persistent.SCMMCPublishTasks;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import org.apache.log4j.Logger;

public class SCMPublishTaskServiceProvider
implements ISelfDefinedServiceProvider {
    private static final Logger logger = Logger.getLogger((String)SCMPublishTaskServiceProvider.class.getName());
    private SCMMCPublishServer m_oSCMPublishServer = SCMMCPublishServer.getInstance();
    private ISCMMCPublishTaskMgr m_oSCMMCPbulishTaskMgr = (ISCMMCPublishTaskMgr)DreamFactory.createObjectById("ISCMMCPublishTaskMgr");

    public SCMMicroContents queryUnpublishedSCMMCs(MethodContext _methodContext) throws Exception {
        User oCurrUser = ContextHelper.getLoginUser();
        if (oCurrUser == null || oCurrUser.getStatus() != 30) {
            throw new WCMException("\u67e5\u627e\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        if (!SCMAuthServer.isGroupAdminOfSCM(oCurrUser)) {
            throw new WCMException("\u7528\u6237[" + oCurrUser.getName() + "]\u65e0\u53ef\u7ef4\u62a4\u7684\u5206\u7ec4\u6743\u9650\uff0c\u65e0\u6cd5\u67e5\u770b\u5fae\u535a\u53d1\u5e03\u961f\u5217\uff01");
        }
        return this.m_oSCMMCPbulishTaskMgr.getUnpublishedSCMMCs();
    }

    public SCMMCPublishTasks findByMCId(MethodContext _methodContext) throws Throwable {
        int nSCMMCId = _methodContext.getValue("SCMMicroContentId", 0);
        if (nSCMMCId == 0) {
            logger.error((Object)("\u67e5\u8be2\u7684\u5fae\u535aID[" + nSCMMCId + "]\u4e0d\u5408\u6cd5\uff01"));
            return null;
        }
        SCMMicroContent oTarget = SCMMicroContent.findById(nSCMMCId);
        if (oTarget == null) {
            logger.error((Object)("\u67e5\u8be2\u7684\u5fae\u535aID[" + nSCMMCId + "]\u4e0d\u5408\u6cd5\uff01"));
            return null;
        }
        SCMGroup oTargetGroup = SCMGroup.findById(oTarget.getGroupId());
        if (oTargetGroup == null) {
            logger.error((Object)"\u5fae\u535a\u6240\u53d1\u5e03\u7684\u5206\u7ec4\u5df2\u7ecf\u4e0d\u5b58\u5728\uff01");
            return null;
        }
        if (!SCMAuthServer.hasRight(this.getCurrLoginUser(), oTargetGroup, 6)) {
            logger.error((Object)"\u60a8\u65e0\u6743\u9650\u7ba1\u7406\u53d1\u5e03\u5fae\u535a\u7684\u6240\u5728\u5206\u7ec4\uff0c\u65e0\u6cd5\u67e5\u770b\u8be5\u5fae\u535a\u7684\u4fe1\u606f\uff01");
            return null;
        }
        return this.m_oSCMMCPbulishTaskMgr.getPublishingTasksOfSCMMC(nSCMMCId);
    }

    public SCMMCPublishTask queryRunningTask(MethodContext _methodContext) throws WCMException {
        return this.m_oSCMPublishServer.getRunningTask();
    }

    public SCMMicroContent queryRunningPublishContent(MethodContext _methodContext) throws WCMException {
        return this.m_oSCMPublishServer.getRunningPublishContent();
    }

    public int save(MethodContext _methodContext) throws Throwable {
        return 0;
    }

    public void deleteSCMMCPublishTask(MethodContext _methodContext) throws Throwable {
        int nTaskId = _methodContext.getValue("PublishTaskId", -1);
        if (nTaskId == -1) {
            throw new WCMException("\u63d0\u4ea4\u7684\u5f85\u5220\u9664\u53d1\u5e03\u4efb\u52a1ID\u9519\u8bef!");
        }
        SCMMCPublishTask oDeletingTask = SCMMCPublishTask.findById(nTaskId);
        if (oDeletingTask == null) {
            throw new WCMException("\u672a\u627e\u5230\u5f85\u5220\u9664\u53d1\u5e03\u4efb\u52a1\uff01\u4efb\u52a1ID[" + nTaskId + "]");
        }
        User oCurrUser = this.getCurrLoginUser();
        if (oCurrUser != null) {
            Account oCurrAccount = oDeletingTask.getAccount();
            if (oCurrAccount == null || oCurrAccount.getStatus() != -1) {
                this.m_oSCMPublishServer.deleteSCMMCPublishTask(oDeletingTask);
                return;
            }
            if (!SCMAuthServer.hasRight(oCurrUser, oCurrAccount, 44)) {
                throw new WCMException("\u60a8\u65e0\u6743\u9650\u7ef4\u62a4\u53d1\u5e03\u4efb\u52a1\u7684\u5fae\u535a\u8d26\u53f7\uff01");
            }
            this.m_oSCMPublishServer.deleteSCMMCPublishTask(oDeletingTask);
        } else {
            logger.error((Object)"\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5931\u8d25\uff01");
        }
    }

    public void deleteSCMMCPublishTasks(MethodContext _methodContext) throws Throwable {
        int nSCMMCId = _methodContext.getValue("SCMMicroContentId", -1);
        if (nSCMMCId == 0) {
            throw new WCMException("\u672a\u6307\u5b9a\u5f85\u5220\u9664\u7684\u5fae\u535aID\uff01");
        }
        SCMMicroContent oDeletingSCMMC = SCMMicroContent.findById(nSCMMCId);
        if (oDeletingSCMMC == null) {
            throw new WCMException("\u672a\u627e\u5230\u6307\u5b9a\u7684\u5f85\u5220\u9664\u5fae\u535a\uff01ID[" + nSCMMCId + "]");
        }
        if (!SCMAuthServer.hasRight(this.getCurrLoginUser(), SCMGroup.findById(oDeletingSCMMC.getGroupId()), 6)) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u5f53\u524d\u5fae\u535a\u7684\u53d1\u5e03\u4efb\u52a1\uff01");
        }
        this.m_oSCMPublishServer.deleteSCMMCPublishContent(oDeletingSCMMC);
    }

    public void pauseSCMMCPublishTask(MethodContext _methodContext) throws WCMException {
    }

    public void resumeSCMMCPublishTask(MethodContext _methodContext) throws WCMException {
    }

    public void cancelSCMMCPublishTask(MethodContext _methodContext) throws Exception {
    }

    public boolean updateSCMMCPublishTask(MethodContext _methodContext) throws Exception {
        return false;
    }

    public void redoPublishTask(MethodContext _methodContext) throws Throwable {
        Account oCurrAccount;
        int nTaskId = _methodContext.getValue("PublishTaskId", -1);
        if (nTaskId == -1) {
            throw new WCMException("\u63d0\u4ea4\u7684\u5f85\u5220\u9664\u53d1\u5e03\u4efb\u52a1ID\u9519\u8bef!");
        }
        SCMMCPublishTask oPublishingTask = SCMMCPublishTask.findById(nTaskId);
        if (oPublishingTask == null) {
            throw new WCMException("\u672a\u627e\u5230\u5f85\u5220\u9664\u53d1\u5e03\u4efb\u52a1\uff01\u4efb\u52a1ID[" + nTaskId + "]");
        }
        User oCurrUser = this.getCurrLoginUser();
        if (!SCMAuthServer.hasRight(oCurrUser, oCurrAccount = oPublishingTask.getAccount(), 44)) {
            throw new WCMException("\u60a8\u65e0\u6743\u9650\u7ef4\u62a4\u53d1\u5e03\u4efb\u52a1\u7684\u5fae\u535a\u8d26\u53f7\uff01");
        }
        this.m_oSCMPublishServer.redoSCMMCPublishTask(oPublishingTask);
    }

    private User getCurrLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

