/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.nav;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.io.ByteArrayOutputStream;
import java.util.List;

public class RadarTreeCreator {
    private static final char BLANK = ' ';
    private static String ENCODING = "GBK";
    private static final String CA_RADAR = "ca_radar_tree";
    private static final String TYPE_S = "s";
    private String userName;
    private int rightIndex;
    private String type;
    private int parentId;
    private int siteType = 0;
    private boolean addRoot = true;

    public RadarTreeCreator(String userName, int rightIndex, String type, int parentId) {
        this.userName = userName;
        this.rightIndex = rightIndex;
        this.type = type;
        this.parentId = parentId;
    }

    public void setAddRoot(boolean addRoot) {
        this.addRoot = addRoot;
    }

    public void setEncoding(String encoding) {
        ENCODING = encoding;
    }

    public void setSiteType(int siteType) {
        this.siteType = siteType;
    }

    public String getTreeInfo() throws Exception {
        String tree_encoding = ConfigServer.getServer().getSysConfigValue("TREE_STRUCTURE_ENCODING", "GBK");
        if (!tree_encoding.trim().equals("")) {
            this.setEncoding(tree_encoding);
        }
        if (CA_RADAR.equals(this.userName)) {
            return this.makeTree4Radar();
        }
        User user = User.findByName(this.userName);
        if (user == null) {
            throw new WCMException(200006, "user not found!usernmae=" + this.userName);
        }
        StringBuffer buff = null;
        if (this.parentId == 0) {
            WebSites sites = new WebSites(null);
            WCMFilter filter = new WCMFilter("", "SITETYPE=0 or SITETYPE=4", "");
            if (this.siteType > 0) {
                filter = new WCMFilter("", "SITETYPE=" + this.siteType, "");
            }
            sites.open(filter);
            buff = new StringBuffer(256 * sites.size() + 128);
            buff.append("<?xml version=\"1.0\" encoding=\"");
            buff.append(ENCODING);
            buff.append("\"?>");
            if (this.addRoot) {
                buff.append("<ss>");
            }
            int size = sites.size();
            for (int i = 0; i < size; ++i) {
                WebSite site = (WebSite)sites.getAt(i);
                if (site == null || site.isDeleted()) continue;
                buff.append("<s n=\"");
                buff.append(CMyString.filterForXML(site.getName()));
                buff.append("\" id=\"");
                buff.append(site.getId());
                buff.append("\" folder=\"");
                buff.append(site.getChildrenSize(user) > 0);
                buff.append("\" type=\"");
                buff.append(site.getProperty("SITETYPE"));
                buff.append("\" />");
            }
            if (this.addRoot) {
                buff.append("</ss>");
            }
        } else {
            List<Channel> channels = null;
            BaseChannel parent = null;
            parent = TYPE_S.equals(this.type) ? WebSite.findById(this.parentId) : Channel.findById(this.parentId);
            if (parent != null && !parent.isDeleted()) {
                channels = parent.getAllChildren(null);
            }
            if (channels != null) {
                buff = new StringBuffer(256 * channels.size() + 128);
                buff.append("<?xml version=\"1.0\" encoding=\"");
                buff.append(ENCODING);
                buff.append("\"?>");
                if (this.addRoot) {
                    buff.append("<cs>");
                }
                int size = channels.size();
                for (int i = 0; i < size; ++i) {
                    Channel channel = channels.get(i);
                    if (channel == null || channel.isDeleted() || !AuthServer.hasRight(user, (CMSObj)channel, 64)) continue;
                    buff.append("<c n=\"");
                    buff.append(CMyString.filterForXML(channel.getDesc()));
                    buff.append("\" id=\"");
                    buff.append(channel.getId());
                    buff.append("\" folder=\"");
                    buff.append(channel.getChildrenSize(user) > 0);
                    buff.append("\" type=\"");
                    buff.append(channel.getType());
                    buff.append("\" addable=\"");
                    buff.append(AuthServer.hasRight(user, (CMSObj)channel, this.rightIndex));
                    buff.append("\" />");
                }
                if (this.addRoot) {
                    buff.append("</cs>");
                }
            } else {
                buff = new StringBuffer(128);
                buff.append("<?xml version=\"1.0\" encoding=\"");
                buff.append(ENCODING);
                buff.append("\"?>");
                buff.append("<cs />");
            }
        }
        return RadarTreeCreator.encode(buff.toString());
    }

    private String makeTree4Radar() throws Exception {
        StringBuffer buff = null;
        if (this.parentId == 0) {
            WebSites sites = new WebSites(null);
            WCMFilter filter = new WCMFilter("", "SITETYPE=" + this.siteType, "");
            sites.open(filter);
            buff = new StringBuffer(256 * sites.size() + 128);
            buff.append("<?xml version=\"1.0\" encoding=\"");
            buff.append(ENCODING);
            buff.append("\"?>");
            buff.append("<WCMWEBSITES>");
            int size = sites.size();
            for (int i = 0; i < size; ++i) {
                WebSite site = (WebSite)sites.getAt(i);
                if (site == null || site.isDeleted()) continue;
                buff.append("<WCMWEBSITE><PROPERTIES><SITEID>");
                buff.append(site.getId());
                buff.append("</SITEID><SITENAME><![CDATA[");
                buff.append(CMyString.filterForXML(site.getName()));
                buff.append("]]></SITENAME><SITEDESC><![CDATA[");
                buff.append(CMyString.filterForXML(site.getDesc()));
                buff.append("]]></SITEDESC><FOLDER>");
                buff.append(site.getChildrenSize(null) > 0);
                buff.append("</FOLDER><TYPE>");
                buff.append(site.getProperty("SITETYPE"));
                buff.append("</TYPE></PROPERTIES></WCMWEBSITE>");
            }
            buff.append("</WCMWEBSITES>");
        } else {
            List<Channel> channels = null;
            BaseChannel parent = null;
            parent = TYPE_S.equals(this.type) ? WebSite.findById(this.parentId) : Channel.findById(this.parentId);
            if (parent != null && !parent.isDeleted()) {
                channels = parent.getAllChildren(null);
            }
            if (channels != null) {
                buff = new StringBuffer(256 * channels.size() + 128);
                buff.append("<?xml version=\"1.0\" encoding=\"");
                buff.append(ENCODING);
                buff.append("\"?>");
                buff.append("<WCMCHANNELS>");
                int size = channels.size();
                for (int i = 0; i < size; ++i) {
                    Channel channel = channels.get(i);
                    if (channel == null || channel.isDeleted()) continue;
                    buff.append("<WCMCHANNEL><PROPERTIES><CHANNELID>");
                    buff.append(channel.getId());
                    buff.append("</CHANNELID><CHNLNAME><![CDATA[");
                    buff.append(CMyString.filterForXML(channel.getName()));
                    buff.append("]]></CHNLNAME><CHNLDESC><![CDATA[");
                    buff.append(CMyString.filterForXML(channel.getDesc()));
                    buff.append("]]></CHNLDESC><FOLDER>");
                    buff.append(channel.getChildrenSize(null) > 0);
                    buff.append("</FOLDER><TYPE>");
                    buff.append(channel.getType());
                    buff.append("</TYPE></PROPERTIES></WCMCHANNEL>");
                }
                buff.append("</WCMCHANNELS>");
            } else {
                buff = new StringBuffer(128);
                buff.append("<?xml version=\"1.0\" encoding=\"");
                buff.append(ENCODING);
                buff.append("\"?>");
                buff.append("<WCMCHANNELS />");
            }
        }
        return buff.toString();
    }

    static String encode(String source) throws Exception {
        if (source == null || source.trim().length() == 0) {
            throw new IllegalArgumentException("no need to encode an empty string?");
        }
        byte[] data = source.getBytes(ENCODING);
        StringBuffer buff = new StringBuffer(data.length * 2);
        byte[] byteBuff = new byte[3];
        int len = data.length;
        for (int i = 0; i < len; i += 3) {
            for (int j = 0; j < 3 && i + j < len; ++j) {
                byteBuff[j] = data[i + j];
            }
            int a = (byteBuff[0] >>> 2 & 0x3F) + 32;
            int b = (byteBuff[0] << 4 & 0x30 | byteBuff[1] >>> 4 & 0xF) + 32;
            int c = (byteBuff[1] << 2 & 0x3C | byteBuff[2] >>> 6 & 3) + 32;
            int d = (byteBuff[2] & 0x3F) + 32;
            buff.append((char)a);
            buff.append((char)b);
            buff.append((char)c);
            buff.append((char)d);
            for (int j = 0; j < 3; ++j) {
                byteBuff[j] = 0;
            }
        }
        return buff.toString();
    }

    String standardEncode(String source) {
        byte[] data = source.getBytes();
        StringBuffer buff = new StringBuffer(data.length * 5);
        int pos = 0;
        int len = data.length;
        for (int i = 0; i < len; i += 45) {
            int j = 0;
            j = i + 45 > len ? len - i : 45;
            buff.append((char)(j + 32));
            for (int k = 0; k < j && pos < len; k += 3) {
                byte a = 0;
                byte b = 0;
                byte c = 0;
                a = data[pos++];
                if (pos < len) {
                    b = data[pos++];
                }
                if (pos < len) {
                    c = data[pos++];
                }
                int c1 = a >>> 2 & 0x3F;
                int c2 = a << 4 & 0x30 | b >>> 4 & 0xF;
                int c3 = b << 2 & 0x3C | c >>> 6 & 3;
                int c4 = c & 0x3F;
                buff.append((char)(c1 + 32));
                buff.append((char)(c2 + 32));
                buff.append((char)(c3 + 32));
                buff.append((char)(c4 + 32));
            }
            buff.append('\n');
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String decode(String source) throws Exception {
        if (source == null || source.trim().length() == 0) {
            throw new IllegalArgumentException("no need to decode an empty string?");
        }
        byte[] data = source.getBytes();
        if (data.length % 4 > 0) {
            throw new IllegalArgumentException("Bad data!");
        }
        byte[] buff = new byte[4];
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            int len = data.length;
            for (int i = 0; i < len; i += 4) {
                for (int j = 0; j < 4; ++j) {
                    buff[j] = (byte)(data[i + j] - 32);
                }
                int a = (buff[0] << 2 & 0xFC | buff[1] >>> 4 & 3) & 0xFF;
                int b = (buff[1] << 4 & 0xF0 | buff[2] >>> 2 & 0xF) & 0xFF;
                int c = (buff[2] << 6 & 0xC0 | buff[3] & 0x3F) & 0xFF;
                baos.write(a);
                if (b > 0) {
                    baos.write(b);
                }
                if (c <= 0) continue;
                baos.write(c);
            }
            baos.flush();
            String string = new String(baos.toByteArray(), ENCODING);
            return string;
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

