/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.trs.infra.util.oss.OSSClientFactory;
import com.trs.infra.util.store.FileStoreNameFilter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class OSSFile {
    public static final String FILE_Suffix = "/";
    private String bucketName = "";
    private String key = "";
    private OSSObject file = null;

    public OSSFile() {
    }

    public OSSFile(String path) {
    }

    public OSSFile(String bucketName, String key) {
        this.bucketName = bucketName;
        this.key = key;
    }

    public Bucket createBucket() {
        Bucket bucket = null;
        OSSClient client = OSSClientFactory.buildFileStore();
        bucket = client.createBucket(this.bucketName);
        client.shutdown();
        return bucket;
    }

    public Bucket createBucket(CannedAccessControlList cannedACL) {
        Bucket bucket = null;
        OSSClient client = OSSClientFactory.buildFileStore();
        CreateBucketRequest request = new CreateBucketRequest(this.bucketName);
        request.setCannedACL(cannedACL);
        bucket = client.createBucket(request);
        client.shutdown();
        return bucket;
    }

    public boolean deleteBucket() {
        OSSClient client = OSSClientFactory.buildFileStore();
        client.deleteBucket(this.bucketName);
        client.shutdown();
        return true;
    }

    public boolean doesBucketExist() {
        boolean isExist = false;
        OSSClient client = OSSClientFactory.buildFileStore();
        isExist = client.doesBucketExist(this.bucketName);
        client.shutdown();
        return isExist;
    }

    public boolean setBucketAcl(CannedAccessControlList cannedACL) {
        OSSClient client = OSSClientFactory.buildFileStore();
        client.setBucketAcl(this.bucketName, cannedACL);
        client.shutdown();
        return true;
    }

    public AccessControlList getBucketAcl() {
        AccessControlList list = null;
        OSSClient client = OSSClientFactory.buildFileStore();
        list = client.getBucketAcl(this.bucketName);
        client.shutdown();
        return list;
    }

    public List<Bucket> listBucket() {
        List buckets = null;
        OSSClient client = OSSClientFactory.buildFileStore();
        buckets = client.listBuckets();
        client.shutdown();
        return buckets;
    }

    public boolean mkdirs() {
        OSSClient client = OSSClientFactory.buildFileStore();
        if (!this.key.endsWith(FILE_Suffix)) {
            this.key = this.key + FILE_Suffix;
        }
        client.putObject(this.bucketName, this.key, (InputStream)new ByteArrayInputStream(new byte[0]), null);
        client.shutdown();
        return true;
    }

    public boolean exists() {
        boolean is_exist = false;
        OSSClient client = OSSClientFactory.buildFileStore();
        is_exist = client.doesObjectExist(this.bucketName, this.key);
        client.shutdown();
        return is_exist;
    }

    public boolean isDirectory() {
        boolean isDirectory = false;
        String directory = this.key;
        if (!directory.endsWith(FILE_Suffix)) {
            directory = directory + FILE_Suffix;
        }
        OSSClient client = OSSClientFactory.buildFileStore();
        isDirectory = client.doesObjectExist(this.bucketName, this.key);
        client.shutdown();
        return isDirectory;
    }

    public boolean isFile() {
        boolean isFile = false;
        OSSClient client = OSSClientFactory.buildFileStore();
        isFile = client.doesObjectExist(this.bucketName, this.key);
        if (isFile && this.key.endsWith(FILE_Suffix)) {
            isFile = true;
        }
        client.shutdown();
        return isFile;
    }

    public boolean delete() {
        OSSClient client = OSSClientFactory.buildFileStore();
        client.deleteObject(this.bucketName, this.key);
        return true;
    }

    public String[] list() {
        ArrayList<String> localArrayList = new ArrayList<String>();
        OSSClient client = OSSClientFactory.buildFileStore();
        String prefix = this.key;
        if (!prefix.endsWith(FILE_Suffix)) {
            prefix = prefix + FILE_Suffix;
        }
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.bucketName);
        listObjectsRequest.setMaxKeys(Integer.valueOf(100));
        listObjectsRequest.setDelimiter(FILE_Suffix);
        listObjectsRequest.setPrefix(prefix);
        ObjectListing listing = null;
        do {
            listing = client.listObjects(listObjectsRequest);
            for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
                String key = objectSummary.getKey();
                if (key.equals(prefix)) continue;
                localArrayList.add(objectSummary.getKey().substring(prefix.length()));
            }
            for (String commonPrefix : listing.getCommonPrefixes()) {
                localArrayList.add(commonPrefix.substring(prefix.length()));
            }
            listObjectsRequest.setMarker(listing.getNextMarker());
        } while (listing.isTruncated());
        return localArrayList.toArray(new String[localArrayList.size()]);
    }

    public String[] list(FileStoreNameFilter filter) {
        return this.list();
    }
}

