/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.html;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlDocument;
import com.trs.infra.util.html.HtmlElement;

public class HtmlAttribute
implements Cloneable {
    protected HtmlElement parent = null;
    protected String name;
    protected char chrQuote = '\u0000';
    protected String value;

    protected HtmlAttribute() {
    }

    public HtmlAttribute(String _name, String _value) {
        this.setName(_name);
        this.setValue(_value);
        this.chrQuote = (char)34;
    }

    public HtmlAttribute(String _name, String _value, char _quote) {
        this.setName(_name);
        this.setValue(_value);
        this.chrQuote = _quote;
    }

    public HtmlAttribute(String _strSrc) {
        this.fromString(_strSrc);
    }

    public HtmlElement getParent() {
        return this.parent;
    }

    public HtmlAttribute setParent(HtmlElement _parent) {
        this.parent = _parent;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public HtmlAttribute setName(String _name) {
        this.name = _name.trim();
        return this;
    }

    public boolean nameIs(String _name) {
        return this.name.compareToIgnoreCase(_name) == 0;
    }

    public String getValue() {
        return this.value;
    }

    public HtmlAttribute setValue(String _value) {
        this.value = _value;
        return this;
    }

    public int getIntValue() throws CMyException {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException ex) {
            throw new CMyException(2, I18NMessage.get(HtmlAttribute.class, "HtmlAttribute.label1", "\u6570\u636e\u8f6c\u6362\u9519\u8bef\uff1a\u65e0\u6548\u7684int\u503c\uff08HtmlAttribute.getIntValue\uff09"));
        }
    }

    public long getLongValue() throws CMyException {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException ex) {
            throw new CMyException(2, I18NMessage.get(HtmlAttribute.class, "HtmlAttribute.label2", "\u6570\u636e\u8f6c\u6362\u9519\u8bef\uff1a\u65e0\u6548\u7684long\u503c\uff08HtmlAttribute.getLongValue\uff09"));
        }
    }

    public float getFloatValue() throws CMyException {
        try {
            return Float.valueOf(this.value).floatValue();
        }
        catch (NumberFormatException ex) {
            throw new CMyException(2, I18NMessage.get(HtmlAttribute.class, "HtmlAttribute.label3", "\u6570\u636e\u8f6c\u6362\u9519\u8bef\uff1a\u65e0\u6548\u7684float\u503c\uff08HtmlAttribute.getFloatValue\uff09"));
        }
    }

    public double getDoubleValue() throws CMyException {
        try {
            return Double.valueOf(this.value);
        }
        catch (NumberFormatException ex) {
            throw new CMyException(2, I18NMessage.get(HtmlAttribute.class, "HtmlAttribute.label4", "\u6570\u636e\u8f6c\u6362\u9519\u8bef\uff1a\u65e0\u6548\u7684double\u503c\uff08HtmlAttribute.getDoubleValue\uff09"));
        }
    }

    public boolean getBooleanValue() throws CMyException {
        if (this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("on") || this.value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (this.value.equalsIgnoreCase("false") || this.value.equalsIgnoreCase("off") || this.value.equalsIgnoreCase("no")) {
            return false;
        }
        throw new CMyException(2, I18NMessage.get(HtmlAttribute.class, "HtmlAttribute.label5", "\u6570\u636e\u8f6c\u6362\u9519\u8bef\uff1a\u65e0\u6548\u7684boolean\u503c\uff08HtmlAttribute.getBooleanValue\uff09"));
    }

    public HtmlDocument getDocument() {
        if (this.parent != null) {
            return this.parent.getDocument();
        }
        return null;
    }

    public Object clone() {
        HtmlAttribute attribute = new HtmlAttribute(this.name, this.value);
        attribute.setParent(null);
        return attribute;
    }

    public final String toString() {
        StringBuffer buff = new StringBuffer();
        try {
            buff.append(this.name);
            if (this.value == null) {
                String string = buff.toString();
                return string;
            }
            buff.append('=');
            if (this.chrQuote != '\u0000') {
                buff.append(this.chrQuote);
            }
            buff.append(this.value);
            if (this.chrQuote != '\u0000') {
                buff.append(this.chrQuote);
            }
            String string = buff.toString();
            return string;
        }
        finally {
            buff.setLength(0);
        }
    }

    public boolean fromString(String _strSrc) {
        int nPos = (_strSrc = _strSrc.trim()).indexOf(61);
        if (nPos < 0) {
            this.name = _strSrc;
            this.value = null;
            return !CMyString.isEmpty(this.name);
        }
        this.name = _strSrc.substring(0, nPos).trim();
        int nEnd = _strSrc.length();
        boolean bDelHead = false;
        char chrLast = _strSrc.charAt(nEnd - 1);
        if (chrLast == '\"' || chrLast == '\'') {
            this.chrQuote = chrLast;
            --nEnd;
            bDelHead = true;
        } else {
            this.chrQuote = '\u0000';
        }
        this.value = _strSrc.substring(nPos + 1, nEnd).trim();
        if (bDelHead && this.value.length() > 0 && this.value.charAt(0) == chrLast) {
            this.value = this.value.substring(1);
        }
        return true;
    }

    public static void main(String[] args) {
        String strSrc = "  c='123' ";
        HtmlAttribute attribute = new HtmlAttribute(strSrc);
        System.out.println(attribute.toString());
    }
}

