/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra;

import com.trs.infra.I18NMessage;
import com.trs.infra.IServer;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyErrors;
import com.trs.infra.util.CMyException;
import org.apache.log4j.Logger;

public abstract class BaseServer
implements IServer {
    public static final String APP_VERSION = "5.1";
    public String APP_BUILD = "1070";
    public String DB_BUILD = "1070";
    public String APP_BUILD_TIME = "2005-02-23";
    private static final Logger logger = Logger.getLogger((String)BaseServer.class.getName());
    protected boolean m_bIsStarted = false;
    protected boolean m_bIsStarting = false;
    protected CMyErrors errors = new CMyErrors();
    protected String m_sAppName = null;

    protected void addError(String _sError) {
        this.errors.add(_sError);
    }

    protected void addError(CMyErrors _errors) {
        this.errors.add(_errors);
    }

    protected void addError(String _sInfo, Exception _errors) {
        this.errors.add(_sInfo, _errors);
    }

    protected void addError(Exception _ex) {
        this.errors.add(_ex);
    }

    @Override
    public CMyErrors getErrors() {
        return this.errors;
    }

    public boolean isStarted() {
        return this.m_bIsStarted;
    }

    public boolean isStarting() {
        return this.m_bIsStarting;
    }

    protected void setStarting(boolean isStarting) {
        this.m_bIsStarting = isStarting;
    }

    @Override
    public synchronized boolean startup() {
        if (this.isStarted()) {
            logger.info((Object)("[" + this.getServerName() + I18NMessage.get(BaseServer.class, "BaseServer.label1", "]\u5df2\u7ecf\u542f\u52a8\u4e86!")));
            return true;
        }
        if (this.isStarting()) {
            logger.info((Object)("[" + this.getServerName() + I18NMessage.get(BaseServer.class, "BaseServer.label2", "]\u6b63\u5728\u542f\u52a8...")));
            return false;
        }
        if (this.isStarted()) {
            return true;
        }
        this.setStarting(true);
        try {
            if (!this.doStart()) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable ex) {
            this.addError(CMyException.getStackTraceText(ex));
            logger.error((Object)("[" + this.getServerName() + I18NMessage.get(BaseServer.class, "BaseServer.label3", "]\u542f\u52a8\u5931\u8d25!")), ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.setStarting(false);
        }
        this.setStarted(true);
        return true;
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isStarted()) {
            return;
        }
        this.doShutdown();
        this.setStarted(false);
        logger.info((Object)("[" + this.getServerName() + I18NMessage.get(BaseServer.class, "BaseServer.label4", "]\u5173\u95ed!")));
    }

    protected void setStarted(boolean isStarted) {
        this.m_bIsStarted = isStarted;
    }

    @Override
    public synchronized boolean restart() {
        if (!this.isStarted()) {
            return false;
        }
        this.shutdown();
        return this.startup();
    }

    @Override
    public String getServerName() {
        if (this.m_sAppName == null) {
            return this.getClass().getName();
        }
        return this.m_sAppName;
    }

    @Override
    public void setServerName(String _sAppName) {
        this.m_sAppName = _sAppName;
    }

    @Override
    public String getServerBuild() {
        return this.APP_BUILD;
    }

    @Override
    public String getBuildTime() {
        return this.APP_BUILD_TIME;
    }

    @Override
    public String getDbBuild() {
        return this.DB_BUILD;
    }

    @Override
    public String getVersion() {
        return APP_VERSION;
    }

    protected abstract void doShutdown();

    protected abstract boolean doStart() throws WCMException;
}

