/*
 * Decompiled with CFR 0.152.
 */
package com.trs.haier.destroytask;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.FlowContentFactory;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.engine.FlowContext;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.haier.destroytask.DestroyTask;
import com.trs.haier.destroytask.DestroyTaskHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;

public class DestroyTaskServiceProvider
implements ISelfDefinedServiceProvider {
    public void applyDestoryTask(MethodContext _oMethodContext) throws Exception {
        User currUser = ContextHelper.getLoginUser();
        String sObjectIds = _oMethodContext.getValue("ObjectIds");
        if (CMyString.isEmpty(sObjectIds)) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u8981\u64a4\u9500\u7684\u5185\u5bb9\uff01");
        }
        String sObjectTitles = _oMethodContext.getValue("ObjectTitles");
        if (CMyString.isEmpty(sObjectTitles)) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u8981\u64a4\u9500\u5185\u5bb9\u7684\u6807\u9898\uff01");
        }
        int nObjectType = _oMethodContext.getValue("ObjectType", 0);
        if (nObjectType != 614 && nObjectType != 605) {
            throw new WCMException("\u76ee\u524d\u53ea\u652f\u6301\u64a4\u9500\u6587\u6863\u65f6\u8fdb\u5165\u5ba1\u6838\u6d41\u7a0b\uff01");
        }
        String sDesc = _oMethodContext.getValue("Desc");
        if (CMyString.isEmpty(sDesc)) {
            throw new WCMException("\u6ca1\u6709\u586b\u5199\u64a4\u9500\u7684\u7406\u7531\uff01");
        }
        int[] pObjectIds = CMyString.splitToInt(sObjectIds, ",");
        String[] pObjectTitles = sObjectTitles.split("~");
        for (int i = 0; i < pObjectIds.length; ++i) {
            int nObjectId = pObjectIds[i];
            int nFlowIdOfSrcContent = 0;
            Flow oFlowOfSrcContent = this.getFlowOfSrcContent(nObjectType, nObjectId);
            if (oFlowOfSrcContent == null) continue;
            if (oFlowOfSrcContent != null) {
                nFlowIdOfSrcContent = oFlowOfSrcContent.getId();
            }
            DestroyTask task = DestroyTask.createNewInstance();
            task.setContent(nObjectType, nObjectId);
            task.setTitle(pObjectTitles[i]);
            task.setDesc(sDesc);
            task.setFlowId(nFlowIdOfSrcContent);
            task.save(currUser);
            if (nFlowIdOfSrcContent == 0) {
                DestroyTaskHelper.destoryDirect(nObjectType, nObjectId);
                continue;
            }
            IFlowContent content = FlowContentFactory.makeFlowContent(1911367336, task.getId());
            IFlowServer flowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
            FlowContext flowContext = new FlowContext(currUser, content);
            flowContext.setPostDesc(sDesc);
            flowServer.submitTo(flowContext);
        }
    }

    private Flow getFlowOfSrcContent(int _nObjectType, int _nObjectId) throws WCMException {
        Document document = null;
        int nDocId = 0;
        switch (_nObjectType) {
            case 614: {
                ChnlDoc chnlDoc = ChnlDoc.findById(_nObjectId);
                if (chnlDoc == null) {
                    return null;
                }
                nDocId = chnlDoc.getDocId();
                if (chnlDoc.getStatusId() != 10) {
                    return null;
                }
                document = Document.findById(nDocId);
                break;
            }
            case 605: {
                nDocId = _nObjectId;
                document = Document.findById(nDocId);
                if (document != null && document.getStatusId() == 10) break;
                return null;
            }
        }
        IFlowContent oScrFlowContent = FlowContentFactory.makeFlowContent(document);
        Flow flow = oScrFlowContent.getOwnerFlow();
        if (flow == null) {
            return new Flow();
        }
        return flow;
    }
}

