/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.metadata.publish.PublishContentViewDataImpl;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WCMTagParserMakeMirrorFromURL
implements ITagParser {
    public void clear() {
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        return null;
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        int nDocId = 0;
        String sURL = _context.getAttribute("URL");
        if (!CMyString.isEmpty(sURL)) {
            nDocId = WCMTagParserMakeMirrorFromURL.makeDocId(sURL);
            if (nDocId == 0) {
                return new String[]{sURL};
            }
        } else {
            IPublishElement element = _context.getUpperHost();
            if (element instanceof PublishContentDocumentImpl || element instanceof PublishContentViewDataImpl) {
                nDocId = element.getId();
            } else {
                throw new WCMException("\u5f53\u524d\u7f6e\u6807\u4f7f\u7528\u7684\u573a\u666f\u4e0d\u5bf9\uff0c\u9700\u8981\u5728\u6587\u6863\u6216\u5143\u6570\u636e\u4e0a\u4e0b\u6587\u4e0b\u4f7f\u7528");
            }
        }
        DBManager dbMgr = DBManager.getDBManager();
        String sMirrorURL = dbMgr.sqlExecuteStringQuery("select DocPubURL from WCMChnlDoc a where DocId=? and exists(select 1 from WCMChannel b where b.SiteId=? and b.ChannelId=a.ChnlId) and Modal in(?, ?) and DocStatus=?", new int[]{nDocId, _context.getRoot().getId(), 1, 3, 10});
        return new String[]{sMirrorURL};
    }

    private static int makeDocId(String _sURL) {
        String sReg = "(?im).*_([\\d]+)\\..+$";
        Pattern pattern = Pattern.compile(sReg);
        Matcher matcher = pattern.matcher(_sURL);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }

    public static void main(String[] args) {
        String sTestData = "/news/xzxw/whhb/201307/t20130730_1913798.htm?rand=9.1";
        String sReg = "(?im).*_([\\d]+)\\..+$";
        Pattern pattern = Pattern.compile(sReg);
        Matcher matcher = pattern.matcher(sTestData);
        if (matcher.find()) {
            System.out.println("[" + matcher.group(1) + "]");
        }
    }
}

