/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.process.service.flowexporter;

import com.trs.cms.ContextHelper;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmploy;
import com.trs.cms.process.definition.FlowEmploys;
import com.trs.cms.process.definition.Flows;
import com.trs.cms.process.xml.FlowImporter;
import com.trs.cms.process.xml.FlowXmlConverter;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.service.portervisitors.IPorterVisitor;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import java.util.HashMap;
import org.dom4j.Element;

public class SiteExporterForFlow
implements IPorterVisitor {
    private HashMap m_hHashMapFlowId = new HashMap();

    @Override
    public void doExport(BaseObj _baseObj, Object _args) throws Exception {
        if (!(_baseObj instanceof WebSite) && !(_baseObj instanceof Channel)) {
            return;
        }
        if (_baseObj instanceof WebSite) {
            WebSite oWebSite = (WebSite)_baseObj;
            this.exportFlowsOfSite(oWebSite, _args);
        } else {
            Channel oChannel = (Channel)_baseObj;
            this.exportFlowEmployOfChannel(oChannel, _args);
        }
    }

    @Override
    public void doImport(BaseObj _baseObj, XmlObject _obj, Object args) throws Exception {
        if (!(_baseObj instanceof WebSite) && !(_baseObj instanceof Channel)) {
            return;
        }
        if (_baseObj instanceof WebSite) {
            WebSite oWebSite = (WebSite)_baseObj;
            this.importFlowsOfSite(oWebSite, _obj);
        }
        if (_baseObj instanceof Channel) {
            Channel oChannel = (Channel)_baseObj;
            this.importFlowsEmploysOfChannel(oChannel, _obj);
        }
    }

    @Override
    public String[] registerTargetClassName() {
        return new String[]{WebSite.class.getName(), Channel.class.getName()};
    }

    public void exportFlowsOfSite(WebSite oWebSite, Object _args) throws WCMException {
        Flows flows = new Flows(null);
        WCMFilter filter = new WCMFilter();
        StringBuffer sbWhere = new StringBuffer(500);
        sbWhere.append("(OwnerId=? and OwnerType=?)");
        filter.addSearchValues(0, oWebSite.getId());
        filter.addSearchValues(1, oWebSite.getWCMType());
        filter.setWhere(sbWhere.toString());
        flows = Flows.openWCMObjs(null, filter);
        if (flows == null || flows.size() <= 0) {
            return;
        }
        Element[] elements = new Element[]{new FlowXmlConverter().toXmlElement(flows, null)};
        Object[] objs = (Object[])_args;
        BaseObjToXmlConverter converter = (BaseObjToXmlConverter)objs[0];
        converter.addChildElements((Element)objs[1], elements);
    }

    private void exportFlowEmployOfChannel(Channel oChannel, Object _args) throws WCMException {
        FlowEmploys oFlowEmploys = new FlowEmploys(null);
        WCMFilter filter = new WCMFilter();
        StringBuffer sbWhere = new StringBuffer(500);
        sbWhere.append("(EmployerType=? and EmployerId=?)");
        filter.addSearchValues(0, oChannel.getWCMType());
        filter.addSearchValues(1, oChannel.getId());
        filter.setWhere(sbWhere.toString());
        oFlowEmploys = FlowEmploys.openWCMObjs(null, filter);
        Element[] elements = new Element[]{new ObjToXmlConverter().toXmlElement(oFlowEmploys, null)};
        Object[] objs = (Object[])_args;
        BaseObjToXmlConverter converter = (BaseObjToXmlConverter)objs[0];
        converter.addChildElements((Element)objs[1], elements);
    }

    private void importFlowsOfSite(WebSite oWebSite, XmlObject _xmlObj) throws WCMException {
        XmlObject[] oFlows = _xmlObj.getChild("WCMFLOWS");
        if (oFlows == null || oFlows.length <= 0) {
            return;
        }
        FlowImporter importer = new FlowImporter(ContextHelper.getLoginUser(), 1);
        importer.setImportWithInfoviewId(false);
        importer.setOwner(oWebSite);
        int nOldFlowId = 0;
        Flow oCurrFlow = null;
        for (int i = 0; i < oFlows.length; ++i) {
            oCurrFlow = (Flow)oFlows[i].getCurrentObj();
            nOldFlowId = oCurrFlow.getPropertyAsInt("FlowId", 0);
            importer.importFromXMLObj(oFlows[i]);
            this.m_hHashMapFlowId.put(String.valueOf(nOldFlowId), String.valueOf(importer.m_nCurrFlowId));
        }
    }

    private void importFlowsEmploysOfChannel(Channel oChannel, XmlObject _xmlObj) throws WCMException {
        XmlObject[] oFlowEmploys = _xmlObj.getChild("WCMFLOWEMPLOYS");
        if (oFlowEmploys == null || oFlowEmploys.length <= 0) {
            return;
        }
        FlowEmploy oFlowEmploy = (FlowEmploy)oFlowEmploys[0].getCurrentObj();
        int nFlowId = oFlowEmploy.getPropertyAsInt("FLOWID", 0);
        oFlowEmploy.setProperty("EMPLOYERID", oChannel.getId());
        if (this.m_hHashMapFlowId.get(String.valueOf(nFlowId)) == null) {
            return;
        }
        oFlowEmploy.setProperty("FLOWID", Integer.parseInt(this.m_hHashMapFlowId.get(String.valueOf(nFlowId)).toString()));
        oFlowEmploy.setProperty("EMPLOYERTYPE", oChannel.getWCMType());
        oFlowEmploy.save();
    }
}

