/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.individuation;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.individuation.Individuation;
import com.trs.components.wcm.individuation.Individuations;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import java.util.Enumeration;
import java.util.Hashtable;

public class IndividuationMgr {
    public Individuations getLoginUserIndividuationConfigs(String[] paramNames, boolean isInclude) throws WCMException {
        User loginUser = this.getLoginUser();
        WCMFilter filter = new WCMFilter("", "", "", "individuationId,paramName,paramValue,objectIdsValue");
        filter.addSearchValues(loginUser.getId());
        StringBuffer where = new StringBuffer("userId=?");
        if (paramNames.length > 0) {
            if (isInclude) {
                where.append(" and paramName in (");
            } else {
                where.append(" and paramName not in (");
            }
            for (int i = 0; i < paramNames.length; ++i) {
                where.append("?,");
                filter.addSearchValues(paramNames[i]);
            }
            where.setCharAt(where.length() - 1, ')');
        }
        filter.setWhere(where.toString());
        return Individuations.openWCMObjs(loginUser, filter);
    }

    public String getObjectIdsAsString(int objType) throws Exception {
        Hashtable ht = this.getObjectIdsHashtable(objType);
        StringBuffer objectIds = new StringBuffer(ht.size());
        Enumeration e = ht.keys();
        if (e.hasMoreElements()) {
            while (true) {
                objectIds.append(e.nextElement());
                if (!e.hasMoreElements()) break;
                objectIds.append(",");
            }
        }
        return objectIds.toString();
    }

    public Hashtable getObjectIdsHashtable(int objType) throws Exception {
        Individuations individuations = this.getObjects(objType);
        return this.filterObject(this.clearRepeat(individuations), objType);
    }

    public Individuations getIndividuations4System() throws Exception {
        String where = " USERID=?";
        WCMFilter filter = new WCMFilter("", where, "");
        filter.addSearchValues(-1);
        return Individuations.openWCMObjs(null, filter);
    }

    private Individuations getObjects(int objType) throws Exception {
        if (objType == 101) {
            return this.getIndividualChannels();
        }
        User loginUser = this.getLoginUser();
        String where = " INDIVIDUATIONID in(select A.INDIVIDUATIONID from XWCMCUSTOMSITECHECKEDINFO A where A.CHECKEDUSERID=?)";
        WCMFilter filter = new WCMFilter("", where, "");
        filter.addSearchValues(loginUser.getId());
        return Individuations.openWCMObjs(loginUser, filter);
    }

    private Individuations getIndividualChannels() throws WCMException {
        User loginUser = this.getLoginUser();
        String userName = loginUser.getName();
        String where = "PARAMNAME='customChannel' AND ISCHECKED=1 AND CRUSER=?";
        WCMFilter filter = new WCMFilter("", where, "");
        filter.addSearchValues(userName);
        return Individuations.openWCMObjs(loginUser, filter);
    }

    private Hashtable clearRepeat(BaseObjs baseObjs) {
        String[] objectIds = null;
        Hashtable<String, Boolean> ht = new Hashtable<String, Boolean>();
        int nSize = baseObjs.size();
        for (int i = 0; i < nSize; ++i) {
            Individuation element = (Individuation)baseObjs.getAt(i);
            if (element == null) continue;
            objectIds = element.getObjectIdsValue().split(",");
            for (int j = 0; j < objectIds.length; ++j) {
                ht.put(objectIds[j], new Boolean(true));
            }
        }
        return ht;
    }

    private Hashtable filterObject(Hashtable ht, int objType) throws Exception {
        int rightIndex;
        CMSBaseObjs baseObjs;
        User loginUser = this.getLoginUser();
        StringBuffer objectIds = new StringBuffer(ht.size());
        Enumeration e = ht.keys();
        if (e.hasMoreElements()) {
            while (true) {
                objectIds.append(e.nextElement());
                if (!e.hasMoreElements()) break;
                objectIds.append(",");
            }
        }
        String objIds = objectIds.toString();
        switch (objType) {
            case 103: {
                baseObjs = WebSites.findByIds(loginUser, objIds);
                rightIndex = 64;
                break;
            }
            case 101: {
                baseObjs = Channels.findByIds(loginUser, objIds);
                rightIndex = 14;
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(IndividuationMgr.class, "IndividuationMgr.label1", "\u4e0d\u652f\u6301\u7684\u5bf9\u8c61\u7c7b\u578b"));
            }
        }
        int nSize = baseObjs.size();
        for (int i = 0; i < nSize; ++i) {
            BaseChannel element = (BaseChannel)baseObjs.getAt(i);
            if (element == null || !element.isDeleted() && AuthServer.hasRight(loginUser, (CMSObj)element, rightIndex)) continue;
            ht.remove(String.valueOf(element.getId()));
        }
        return ht;
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }
}

