/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.key.CKeyUtil;
import com.trs.infra.util.key.MacAddressHelper;
import com.trs.license.License;
import com.trs.license.LicenseException;
import com.trs.license.LicenseUtil;

public class SiteLicenseMgr {
    private static final String LICENSE = "license/LICENSE.trswcm";
    private static License s_oLicense = null;
    private static SiteLicenseMgr s_oMgr = new SiteLicenseMgr();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SiteLicenseMgr getInstance() {
        if (s_oLicense == null) {
            SiteLicenseMgr siteLicenseMgr = s_oMgr;
            synchronized (siteLicenseMgr) {
                License license;
                if (s_oLicense != null) {
                    return s_oMgr;
                }
                String sKeyInfo = SiteLicenseMgr.getProductKey();
                SiteLicenseMgr.validateHostMachine(sKeyInfo);
                SiteLicenseMgr.validateExpiration(sKeyInfo);
                String temp = sKeyInfo.substring(12, 14);
                final int nMaxSiteNum = CKeyUtil.getKeyNum(temp);
                temp = sKeyInfo.substring(14, 16);
                final int nMaxUserNum = CKeyUtil.getKeyNum(temp);
                s_oLicense = license = new License(){

                    @Override
                    public int getMaxSiteNum() {
                        return nMaxSiteNum - 1;
                    }

                    @Override
                    public int getMaxUserNum() {
                        return nMaxUserNum - 1;
                    }

                    @Override
                    public int getPluginCode() {
                        return 0;
                    }

                    @Override
                    public String validate() {
                        return null;
                    }
                };
            }
        }
        return s_oMgr;
    }

    public void validateSiteLicense() {
        String sql = "SELECT COUNT(*) FROM WCMWEBSITE";
        int nSiteNum = 0;
        try {
            nSiteNum = DBManager.getDBManager().sqlExecuteIntQuery(sql);
        }
        catch (Exception e) {
            throw new LicenseException(I18NMessage.get(SiteLicenseMgr.class, "SiteLicenseMgr.label1", "\u6821\u9a8c\u4f7f\u7528\u8bb8\u53ef\u5931\u8d25!"), e);
        }
        if (nSiteNum > s_oLicense.getMaxSiteNum() && s_oLicense.getMaxSiteNum() != -1) {
            throw new LicenseException(I18NMessage.get(SiteLicenseMgr.class, "SiteLicenseMgr.label2", "\u5bf9\u4e0d\u8d77,\u60a8\u7684\u7cfb\u7edf\u7ad9\u70b9\u6570\u5df2\u7ecf\u8fbe\u5230\u5141\u8bb8\u7684\u4e0a\u9650!\u60a8\u7684\u6700\u591a\u7ad9\u70b9\u6570\u4e3a[") + (s_oLicense.getMaxSiteNum() + 1) + "]");
        }
    }

    private static String getProductKey() {
        String sKey = SiteLicenseMgr.loadLicenseFile();
        sKey = LicenseUtil.decodeRadix64(sKey);
        return CKeyUtil.DecodeKey(sKey);
    }

    private static void validateExpiration(String _sKeyInfo) {
        String temp = _sKeyInfo.substring(16, _sKeyInfo.length());
        temp = temp.substring(0, 4) + '-' + temp.substring(4, 6) + '-' + temp.substring(6, temp.length());
        CMyDateTime expiration = new CMyDateTime();
        try {
            expiration.setDateWithString(temp, 0);
            if (expiration.dateDiff(3, CMyDateTime.now()) < 0L) {
                String tip = I18NMessage.get(SiteLicenseMgr.class, "SiteLicenseMgr.label3", "\u4ea7\u54c1\u5df2\u8fc7\u671f,\u60a8\u9700\u8981\u8d2d\u4e70\u53e6\u4e00\u4e2a\u4f7f\u7528\u8bb8\u53ef\u624d\u80fd\u7ee7\u7eed\u4f7f\u7528!\n") + I18NMessage.get(SiteLicenseMgr.class, "SiteLicenseMgr.label4", "\u611f\u8c22\u60a8\u4f7f\u7528TRSWCM!\n") + I18NMessage.get(SiteLicenseMgr.class, "SiteLicenseMgr.label5", "TRS\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1.");
                throw new LicenseException(tip);
            }
        }
        catch (CMyException e) {
            throw new LicenseException(I18NMessage.get(SiteLicenseMgr.class, "SiteLicenseMgr.label6", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38!"), e);
        }
    }

    private static void validateHostMachine(String sKeyInfo) {
        String temp = sKeyInfo.substring(0, 12);
        while (temp.charAt(0) == '0' && temp.length() > 0) {
            temp = temp.substring(1);
        }
        long lMacAddress = Long.parseLong(temp);
        if (!MacAddressHelper.isValidMac(lMacAddress)) {
            throw new LicenseException(I18NMessage.get(SiteLicenseMgr.class, "SiteLicenseMgr.label7", "\u65e0\u6548\u7684\u4f7f\u7528\u8bb8\u53ef(Host)!"));
        }
    }

    private static String loadLicenseFile() {
        String sLicenseContent = "";
        Class<SiteLicenseMgr> clazz = SiteLicenseMgr.class;
        String filename = clazz.getClassLoader().getResource(LICENSE).getFile();
        try {
            sLicenseContent = CMyFile.readFile(filename).trim();
        }
        catch (CMyException e) {
            int nErrNumber = e.getErrNo();
            if (55 == nErrNumber) {
                throw new LicenseException(I18NMessage.get(SiteLicenseMgr.class, "SiteLicenseMgr.label8", "\u975e\u6cd5\u4f7f\u7528!\u6ca1\u6709\u627e\u5230\u5408\u6cd5\u7684License."));
            }
            throw new LicenseException(I18NMessage.get(SiteLicenseMgr.class, "SiteLicenseMgr.label9", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38!\u6821\u9a8c\u4f7f\u7528\u8bb8\u53ef\u5931\u8d25"));
        }
        String decodeContent = LicenseUtil.decodeRadix64(sLicenseContent);
        return decodeContent;
    }
}

