/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.components.wcm.content.domain.IDocumentsTimeRangeMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.store.FileService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DocumentsTimeRangeMgrImpl
implements IDocumentsTimeRangeMgr {
    private static Logger logger = Logger.getLogger(DocumentsTimeRangeMgrImpl.class);
    public static final String DOCUMENTS_TIMERANGE_INI = "Documents.Time.Range.ini";
    private HashMap m_hmChannelsSetTimeRange = new HashMap(20);
    private HashMap m_hmObjectSetTimeRange = new HashMap(30);
    private int m_nDefaultTimeRange = 7;
    private Integer m_iDefaultTimeRange = new Integer(this.m_nDefaultTimeRange);

    public DocumentsTimeRangeMgrImpl() {
        this.init();
    }

    @Override
    public void reloadTimeRangeConfig() {
        this.m_hmChannelsSetTimeRange.clear();
        this.m_nDefaultTimeRange = 7;
        this.m_iDefaultTimeRange = new Integer(this.m_nDefaultTimeRange);
        this.m_hmObjectSetTimeRange.clear();
        this.init();
    }

    @Override
    public boolean isSetTimeRange(int _nChannelId) {
        return this.m_hmChannelsSetTimeRange.containsKey(new Integer(_nChannelId));
    }

    @Override
    public int getTimeRange(int _nChannelId) {
        Integer iTimeRange = (Integer)this.m_hmChannelsSetTimeRange.get(new Integer(_nChannelId));
        if (iTimeRange == null) {
            return -1;
        }
        return iTimeRange;
    }

    @Override
    public CMyDateTime getStartDateTime(int _nChannelId) {
        if (!this.isSetTimeRange(_nChannelId)) {
            return null;
        }
        CMyDateTime dtStart = CMyDateTime.now();
        try {
            return dtStart.dateAdd(3, -this.getTimeRange(_nChannelId));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        try {
            String sLine;
            fis = new FileService(ConfigConstants.DIR_APPROOT + DOCUMENTS_TIMERANGE_INI).getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, "GBK"));
            int nObjectType = 101;
            while ((sLine = buffReader.readLine()) != null) {
                if ((sLine = sLine.trim()).length() == 0 || sLine.charAt(0) == '#') continue;
                if (sLine.charAt(0) == 'S' || sLine.charAt(0) == 's') {
                    nObjectType = 103;
                    sLine = sLine.substring(1);
                } else {
                    nObjectType = 101;
                }
                this.dowithChannelTimeRange(nObjectType, sLine);
            }
        }
        catch (Exception ex) {
            logger.error((Object)I18NMessage.get(DocumentsTimeRangeMgrImpl.class, "DocumentsTimeRangeMgrImpl.label1", "\u521d\u59cb\u5316\u9891\u9053\u65f6\u95f4\u9650\u5b9a\u53d1\u751f\u5f02\u5e38!"), (Throwable)ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void dowithChannelTimeRange(int _nObjectType, String _sLineContent) {
        int nObjectType = _nObjectType;
        int nPos = _sLineContent.indexOf(58);
        int nTimeRange = -1;
        if (nPos > 0 && nPos < _sLineContent.length() - 1) {
            String sTimeRange = _sLineContent.substring(nPos + 1).trim();
            try {
                nTimeRange = Integer.parseInt(sTimeRange);
            }
            catch (NumberFormatException e) {
                return;
            }
        } else if (nPos < 0) {
            nPos = _sLineContent.length();
        }
        int nObjectId = -1;
        String sObjectId = _sLineContent.substring(0, nPos).trim();
        try {
            nObjectId = Integer.parseInt(sObjectId);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (nObjectId == 0) {
            if (nTimeRange > 0) {
                this.m_nDefaultTimeRange = nTimeRange;
                this.m_iDefaultTimeRange = new Integer(this.m_nDefaultTimeRange);
            }
            return;
        }
        Integer iTimeRange = nTimeRange > 0 ? new Integer(nTimeRange) : this.m_iDefaultTimeRange;
        if (nObjectType == 101) {
            this.m_hmChannelsSetTimeRange.put(new Integer(nObjectId), iTimeRange);
        }
        this.m_hmObjectSetTimeRange.put(this.makeTimeRangeObjectKey(nObjectType, nObjectId), iTimeRange);
    }

    @Override
    public boolean isSetTimeRange(int _nObjectId, int _nObjectType) {
        return this.m_hmObjectSetTimeRange.containsKey(this.makeTimeRangeObjectKey(_nObjectType, _nObjectId));
    }

    @Override
    public int getTimeRange(int _nObjectId, int _nObjectType) {
        Integer iTimeRange = (Integer)this.m_hmObjectSetTimeRange.get(this.makeTimeRangeObjectKey(_nObjectType, _nObjectId));
        if (iTimeRange == null) {
            return -1;
        }
        return iTimeRange;
    }

    private String makeTimeRangeObjectKey(int _nObjectType, int _nObjectId) {
        return _nObjectType + "." + _nObjectId;
    }

    @Override
    public CMyDateTime getStartDateTime(int _nObjectId, int _nObjectType) {
        if (!this.isSetTimeRange(_nObjectId, _nObjectType)) {
            return null;
        }
        CMyDateTime dtStart = CMyDateTime.now();
        try {
            return dtStart.dateAdd(3, -this.getTimeRange(_nObjectId, _nObjectType));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

