/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.DocBakMgr;
import com.trs.components.wcm.content.persistent.AutoBakConfig;
import com.trs.components.wcm.content.persistent.AutoBakConfigs;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;

public class AutoDocBakMgr {
    private static Logger m_oLogger = Logger.getLogger(AutoDocBakMgr.class);

    private User getLoginUser() throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (user == null) {
            throw new WCMException(1001, I18NMessage.get(AutoDocBakMgr.class, "AutoDocBakMgr.label1", "\u7528\u6237\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6!"));
        }
        return user;
    }

    private void assertNotNull(BaseObj _baseObj) throws WCMException {
        if (_baseObj == null) {
            throw new WCMException(10, I18NMessage.get(AutoDocBakMgr.class, "AutoDocBakMgr.label2", "\u65e0\u6548\u7684\u5bf9\u8c61[null],\u65e0\u6cd5\u5b8c\u6210\u64cd\u4f5c!"));
        }
    }

    private boolean isValidForAutoBak(Document _currDoc, int _nOperType) throws WCMException {
        this.assertNotNull(_currDoc);
        Channel docChannel = _currDoc.getChannel();
        if (docChannel == null) {
            return false;
        }
        int nSiteId = docChannel.getSiteId();
        AutoBakConfig currConfig = this.getAutoSaveConfig(WebSite.findById(nSiteId));
        if (!this.isValidOperType(currConfig, _nOperType)) {
            return false;
        }
        Status currStatus = _currDoc.getStatus();
        return currConfig.getCanSavedDocStatus(this.getLoginUser()).indexOf(currStatus) >= 0;
    }

    private boolean isValidOperType(AutoBakConfig _currConfig, int _nOperType) {
        if (_currConfig == null) {
            return false;
        }
        String sOperTypes = _currConfig.getOperTypes();
        if (sOperTypes == null) {
            sOperTypes = "";
        }
        return sOperTypes.indexOf(String.valueOf(_nOperType)) >= 0;
    }

    private boolean isValid(Document currDoc) throws WCMException {
        this.assertNotNull(currDoc);
        if (currDoc.isChangeProperty("DOCVERSION")) {
            return false;
        }
        int nOperType = 10;
        return this.isValidForAutoBak(currDoc, nOperType);
    }

    private DocBakMgr getDocBakMgr() throws WCMException {
        DocBakMgr currDocBakMgr = (DocBakMgr)DreamFactory.createObjectById("DocBakMgr");
        if (currDocBakMgr == null) {
            throw new WCMException(10, I18NMessage.get(AutoDocBakMgr.class, "AutoDocBakMgr.label3", "DocBakMgr\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u7684\u4e0d\u6b63\u786e\uff01"));
        }
        return currDocBakMgr;
    }

    public void autoBakDocument(Document _document, int _nOperType) throws WCMException {
        if (this.isValid(_document, _nOperType)) {
            this.getDocBakMgr().bakupDocument(_document);
        }
    }

    private boolean isValid(Document _document, int _nOperType) throws WCMException {
        this.assertNotNull(_document);
        if (_document.isChangeProperty("DOCVERSION")) {
            return false;
        }
        return this.isValidForAutoBak(_document, _nOperType);
    }

    public void autoBakDocument(Document _document) throws WCMException {
        if (!this.isValid(_document)) {
            return;
        }
        DocBakMgr currDocBakMgr = this.getDocBakMgr();
        currDocBakMgr.bakupDocument(_document);
    }

    public AutoBakConfig save(AutoBakConfig _currConfig) throws WCMException {
        this.assertNotNull(_currConfig);
        _currConfig.save(this.getLoginUser());
        return _currConfig;
    }

    public AutoBakConfig getAutoSaveConfig(WebSite _currSite) throws WCMException {
        this.assertNotNull(_currSite);
        WCMFilter aFilter = new WCMFilter("", "SiteId=" + _currSite.getId(), "AUTOBAKCONFIGID desc");
        AutoBakConfigs currConfigs = null;
        try {
            currConfigs = AutoBakConfigs.openWCMObjs(this.getLoginUser(), aFilter);
        }
        catch (WCMException ex) {
            m_oLogger.debug((Object)ex.getStackTraceText());
            throw new WCMException(1100, I18NMessage.get(AutoDocBakMgr.class, "AutoDocBakMgr.label4", "\u83b7\u53d6\u7ad9\u70b9\u7684\u6587\u6863\u81ea\u52a8\u4fdd\u5b58\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!"), ex);
        }
        return currConfigs == null || currConfigs.isEmpty() ? null : (AutoBakConfig)currConfigs.getAt(0);
    }

    public void removeConfig(WebSite _currSite) throws WCMException {
        this.assertNotNull(_currSite);
        AutoBakConfig currConfig = this.getAutoSaveConfig(_currSite);
        if (currConfig == null) {
            return;
        }
        currConfig.delete(this.getLoginUser());
    }
}

