/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content;

import com.trs.DreamFactory;
import com.trs.cms.auth.config.RightConfigServer;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.HTMLContent;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class ViewDocument
extends CMSObj {
    private static Logger logger = Logger.getLogger(ViewDocument.class);
    public static final String DB_TABLE_NAME = "WCMDOCUMENT";
    public static final String ID_FIELD_NAME = "DOCID";
    public static final Integer KEY_CURR_HOST = new Integer(1);
    public static final Integer KEY_CHANNEL_RIGHTVALUES = new Integer(2);
    private Hashtable m_hChnlDocProperties = null;
    private HTMLContent m_oHTMLContent = null;
    private HashMap m_hPublicCache = null;
    private RightValue m_oRightValue = null;
    private Channel m_oDocChannel = null;
    private Channel m_oChannel = null;
    private int m_nDocId = 0;
    private Document m_oDocument = null;
    private ChnlDoc m_oChnlDoc = null;

    public ViewDocument(HashMap _hPublicCache) {
        this.m_hPublicCache = _hPublicCache;
        this.m_bCheckPropertyValid = false;
    }

    @Override
    public void setId(int _nId) {
        this.id = _nId;
    }

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return ID_FIELD_NAME;
    }

    @Override
    public int getWCMType() {
        return 0;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    public void setChnlDocProperty(String _sFieldName, Object _value) {
        if (this.m_hChnlDocProperties == null) {
            this.m_hChnlDocProperties = new Hashtable();
        }
        this.m_hChnlDocProperties.put(_sFieldName.toUpperCase(), _value);
    }

    public int getChnlDocProperty(String _sFieldName, int _nDefault) {
        Number value = (Number)this.m_hChnlDocProperties.get(_sFieldName.toUpperCase());
        if (value == null) {
            return _nDefault;
        }
        return value.intValue();
    }

    public String getChnlDocProperty(String _sFieldName) {
        Object value = this.m_hChnlDocProperties.get(_sFieldName.toUpperCase());
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public void cloneDocumentProperties(ViewDocument _viewDocument) {
        this.m_hProperties = _viewDocument.getProperties(false);
    }

    public Hashtable getChnlDocProperties() {
        return this.m_hChnlDocProperties;
    }

    public int getDocId() {
        return this.m_nDocId;
    }

    public void setDocId(int docId) {
        this.m_nDocId = docId;
    }

    public int getChannelId() {
        return Math.abs(this.getChnlDocProperty("CHNLID", 0));
    }

    public Channel getChannel() throws WCMException {
        if (this.m_oChannel != null) {
            return this.m_oChannel;
        }
        int nChannelId = this.getChannelId();
        BaseChannel oChannelOrSite = this.getCurrChannelOrSite();
        if (oChannelOrSite != null && !oChannelOrSite.isSite() && oChannelOrSite.getId() == nChannelId) {
            this.m_oChannel = (Channel)oChannelOrSite;
            return this.m_oChannel;
        }
        int nModal = this.getChnlDocProperty("Modal", 1);
        if (nModal == 1 && this.getDocChannelId() == nChannelId) {
            this.m_oChannel = this.getDocChannel();
            return this.m_oChannel;
        }
        this.m_oChannel = Channel.findById(nChannelId);
        return this.m_oChannel;
    }

    public int getDocChannelId() {
        int nDocChannelId = Math.abs(this.getChnlDocProperty("DocChannel", 0));
        if (nDocChannelId <= 0) {
            nDocChannelId = Math.abs(this.getPropertyAsInt("DocChannel", 0));
        }
        return nDocChannelId;
    }

    public Channel getDocChannel() throws WCMException {
        if (this.m_oDocChannel == null) {
            this.m_oDocChannel = Channel.findById(this.getDocChannelId());
        }
        return this.m_oDocChannel;
    }

    public int getStatusId() {
        return this.getChnlDocProperty("DOCSTATUS", 0);
    }

    public Status getStatus() throws WCMException {
        return Status.findById(Math.abs(this.getStatusId()));
    }

    public boolean isTopped() {
        BaseChannel host = this.getCurrChannelOrSite();
        if (host == null) {
            return false;
        }
        if (host.isSite()) {
            return false;
        }
        Channel channel = (Channel)host;
        return this.getChnlDocProperty("DOCORDERPRI", 0) > 0;
    }

    public int getSourceId() {
        return this.getPropertyAsInt("DOCSOURCE", 0);
    }

    public Source getSource() throws WCMException {
        return Source.findById(this.getSourceId());
    }

    public String getHtmlContentWithImgFilter(String _sImgSrcPre, boolean _bRemoveExtraAttribute) throws WCMException {
        return this.getHtmlContentWithImgFilter(_sImgSrcPre, _bRemoveExtraAttribute, false);
    }

    public String getHtmlContentWithImgFilter(String _sImgSrcPre, boolean _bRemoveExtraAttribute, boolean _bFromPubHTMLContent) throws WCMException {
        if (this.getType() != 20) {
            return "";
        }
        if (this.m_oHTMLContent == null) {
            this.m_oHTMLContent = new HTMLContent(_bFromPubHTMLContent ? this.getPubHtmlContent() : this.getHtmlContent());
        }
        return this.m_oHTMLContent.parseHTMLContent(_sImgSrcPre);
    }

    public String getPubHtmlContent() {
        if (!this.getProperties(true).containsKey("DOCPUBHTMLCON")) {
            try {
                this.loadTextsFromDB("DOCPUBHTMLCON");
            }
            catch (Exception e) {
                logger.error((Object)(I18NMessage.get(ViewDocument.class, "ViewDocument.label1", "\u8f7d\u5165[") + this + I18NMessage.get(ViewDocument.class, "ViewDocument.label2", "] DOCPUBHTMLCON \u5c5e\u6027\u5931\u8d25\uff01")));
                throw new RuntimeException(I18NMessage.get(ViewDocument.class, "ViewDocument.label1", "\u8f7d\u5165[") + this + I18NMessage.get(ViewDocument.class, "ViewDocument.label3", "] DOCPUBHTMLCON \u5c5e\u6027\u5931\u8d25\uff01\n") + CMyException.getStackTraceText(e));
            }
        }
        return this.getPropertyAsString("DOCPUBHTMLCON");
    }

    public String getHtmlContent() {
        if (!this.getProperties(true).containsKey("DOCHTMLCON")) {
            try {
                this.loadTextsFromDB("DOCHTMLCON");
            }
            catch (Exception e) {
                logger.error((Object)(I18NMessage.get(ViewDocument.class, "ViewDocument.label1", "\u8f7d\u5165[") + this + I18NMessage.get(ViewDocument.class, "ViewDocument.label4", "] DOCHTMLCON \u5c5e\u6027\u5931\u8d25\uff01")));
                throw new RuntimeException(I18NMessage.get(ViewDocument.class, "ViewDocument.label1", "\u8f7d\u5165[") + this + I18NMessage.get(ViewDocument.class, "ViewDocument.label5", "] DOCHTMLCON \u5c5e\u6027\u5931\u8d25\uff01\n") + CMyException.getStackTraceText(e));
            }
        }
        return this.getPropertyAsString("DOCHTMLCON");
    }

    public int getType() {
        return this.getPropertyAsInt("DOCTYPE", 0);
    }

    public String getContent() {
        if (!this.getProperties(true).containsKey("DOCCONTENT")) {
            try {
                this.loadTextsFromDB("DOCCONTENT");
            }
            catch (Exception e) {
                logger.error((Object)(I18NMessage.get(ViewDocument.class, "ViewDocument.label1", "\u8f7d\u5165[") + this + I18NMessage.get(ViewDocument.class, "ViewDocument.label6", "] DOCONTENT \u5c5e\u6027\u5931\u8d25\uff01")));
                throw new RuntimeException(I18NMessage.get(ViewDocument.class, "ViewDocument.label1", "\u8f7d\u5165[") + this + I18NMessage.get(ViewDocument.class, "ViewDocument.label7", "] DOCONTENT \u5c5e\u6027\u5931\u8d25\uff01\n") + CMyException.getStackTraceText(e));
            }
        }
        return this.getPropertyAsString("DOCCONTENT");
    }

    public String getTypeString() {
        return Document.getTypeString(this.getType());
    }

    public HashMap getPublicCache() {
        if (this.m_hPublicCache == null) {
            this.m_hPublicCache = new HashMap(1);
        }
        return this.m_hPublicCache;
    }

    public void setPublicCache(HashMap publicCache) {
        this.m_hPublicCache = publicCache;
    }

    public BaseChannel getCurrChannelOrSite() {
        return (BaseChannel)this.getPublicCache().get(KEY_CURR_HOST);
    }

    public RightValue getRightValue(User _currUser) throws WCMException {
        if (this.m_oRightValue != null) {
            return this.m_oRightValue;
        }
        this.m_oRightValue = this.makeRightValue(_currUser);
        return this.m_oRightValue;
    }

    private RightValue makeRightValue(User _currUser) throws WCMException {
        boolean bEditDocumentUseStatusIndex;
        String sFlowDesc = this.getPropertyAsString("FLOWOPERATIONMARK");
        boolean bFlowRightPriority = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("FLOW_RIGHT_PRI", "false"));
        boolean bInFlow = bFlowRightPriority && !CMyString.isEmpty(sFlowDesc) && !sFlowDesc.equalsIgnoreCase("RESERVED_FORCED_END") && !sFlowDesc.equals(I18NMessage.get(ViewDocument.class, "ViewDocument.label8", "\u7ed3\u675f\u6d41\u8f6c"));
        int[] pRemoveRightIndexs = WCMRightTypes.getRemoveRightIndexs();
        if (this.isRightDefined()) {
            try {
                RightValue rightValue = new RightValue();
                rightValue.load(_currUser, 605, this.getDocId(), true);
                if (_currUser.getName().equalsIgnoreCase(this.getCrUserName())) {
                    int[] pRightIndexesOnOwner = DocumentAuthServer.INDEXES_OWNER_HAS;
                    for (int i = 0; i < pRightIndexesOnOwner.length; ++i) {
                        int nRightIndex = pRightIndexesOnOwner[i];
                        rightValue.setBit(nRightIndex, true);
                    }
                }
                if (bInFlow) {
                    for (int i = 0; i < pRemoveRightIndexs.length; ++i) {
                        rightValue.setBit(pRemoveRightIndexs[i], false);
                    }
                }
                return rightValue;
            }
            catch (WCMException ex) {
                throw new WCMException(1100, I18NMessage.get(ViewDocument.class, "ViewDocument.label9", "\u83b7\u53d6\u6307\u5b9a\u5bf9\u8c61\u7684\u6743\u9650\u503c\u65f6\u5931\u8d25(") + this.getClass().getName() + ".getRightValue)", ex);
            }
        }
        if (_currUser.isAdministrator()) {
            RightValue rightValue = new RightValue(RightValue.getAdministratorRightValue().getValue());
            if (bInFlow) {
                for (int i = 0; i < pRemoveRightIndexs.length; ++i) {
                    rightValue.setBit(pRemoveRightIndexs[i], false);
                }
            }
            return rightValue;
        }
        BaseChannel host = this.getCurrChannelOrSite();
        Channel currChannel = null;
        currChannel = host != null && !host.isSite() && host.getId() == this.getChannelId() ? (Channel)host : this.getChannel();
        RightValue newRightValue = new RightValue();
        Document document = this.getDocument();
        boolean bHasRightByDocLevel = DocumentAuthServer.hasRightByDocLevel(_currUser, this.getDocChannel(), document);
        if (bHasRightByDocLevel) {
            RightValue currChannelRightValue = this.getChannelRightValueFromCache(_currUser, currChannel);
            if (this.getDocChannelId() > 0 && currChannel.getId() != this.getDocChannelId()) {
                RightValue docChannelRightValue = this.getChannelRightValueFromCache(_currUser, this.getDocChannel());
                newRightValue.copy(docChannelRightValue);
                int[] pRightIndexesOnChannel = RightConfigServer.getInstance().getRightIndexDefineOnCurrChannel(currChannel.getSiteId());
                for (int i = 0; i < pRightIndexesOnChannel.length; ++i) {
                    int nRightIndex = pRightIndexesOnChannel[i];
                    newRightValue.setBit(nRightIndex, currChannelRightValue.getBit(nRightIndex));
                }
            } else {
                newRightValue.copy(currChannelRightValue);
            }
        }
        if (_currUser.getName().equalsIgnoreCase(this.getCrUserName())) {
            int[] pRightIndexesOnOwner = DocumentAuthServer.INDEXES_OWNER_HAS;
            for (int i = 0; i < pRightIndexesOnOwner.length; ++i) {
                int nRightIndex = pRightIndexesOnOwner[i];
                newRightValue.setBit(nRightIndex, true);
            }
        }
        if (bInFlow) {
            for (int i = 0; i < pRemoveRightIndexs.length; ++i) {
                newRightValue.setBit(pRemoveRightIndexs[i], false);
            }
        }
        if (bEditDocumentUseStatusIndex = "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("EDIT_DOCUMENT_USE_ST_INDEX", "false"))) {
            switch (this.getStatusId()) {
                case 10: 
                case 16: 
                case 18: {
                    Status status = Status.findById(16);
                    int nNewRightIndex = status.getRightIndex();
                    newRightValue.setBit(32, newRightValue.getBit(nNewRightIndex));
                    break;
                }
            }
        }
        return newRightValue;
    }

    private RightValue getChannelRightValueFromCache(User _currUser, Channel _channel) throws WCMException {
        RightValue rightValue;
        Integer iKey = _channel.getKey();
        HashMap<Integer, RightValue> hChannelRightValue = (HashMap<Integer, RightValue>)this.getPublicCache().get(KEY_CHANNEL_RIGHTVALUES);
        if (hChannelRightValue == null) {
            hChannelRightValue = new HashMap<Integer, RightValue>(1);
            this.getPublicCache().put(KEY_CHANNEL_RIGHTVALUES, hChannelRightValue);
        }
        if ((rightValue = (RightValue)hChannelRightValue.get(iKey)) == null) {
            if (_currUser.isAdministrator() || _currUser.getName().equalsIgnoreCase(_channel.getCrUserName())) {
                rightValue = RightValue.getAdministratorRightValue();
            } else {
                rightValue = new RightValue();
                IObjectMemberMgr oObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
                if (oObjectMemberMgr.canOperate(_currUser, _channel.getWCMType(), _channel.getId())) {
                    rightValue.load(_currUser, 101, _channel.getId(), true);
                }
                hChannelRightValue.put(iKey, rightValue);
            }
        }
        return rightValue;
    }

    public boolean isRightDefined() throws WCMException {
        RightCacheMgr oRightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
        return oRightCacheMgr.isExistsRight(605, this.getDocId());
    }

    public boolean hasRight(User _loginUser, int _nRightIndex) throws WCMException {
        RightValue rightValue = this.getRightValue(_loginUser);
        if (this.isRightDefined()) {
            if (_nRightIndex == 64) {
                return rightValue.getValue() > 0L;
            }
            return rightValue.isHasRight(_nRightIndex);
        }
        return rightValue.isHasRight(_nRightIndex);
    }

    public void setDocChannel(Channel docChannel) {
        this.m_oDocChannel = docChannel;
    }

    public static ViewDocument findById(BaseChannel _host, int _nChnlDocRecId, String _sSelectFieldsOfChnlDoc, String _sSelectFieldsOfDocument) throws WCMException {
        String sSelectFieldsOfChnlDoc = null;
        if (_sSelectFieldsOfChnlDoc == null) {
            sSelectFieldsOfChnlDoc = "DOCID,RECID,CHNLID,DOCCHANNEL";
        } else {
            sSelectFieldsOfChnlDoc = _sSelectFieldsOfChnlDoc.toUpperCase();
            if (sSelectFieldsOfChnlDoc.indexOf(" FROM ") >= 0) {
                return null;
            }
        }
        HashMap<Integer, BaseChannel> hPublicCache = new HashMap<Integer, BaseChannel>(1);
        if (_host != null) {
            hPublicCache.put(KEY_CURR_HOST, _host);
        }
        ViewDocument viewDocument = new ViewDocument(hPublicCache);
        viewDocument.setId(_nChnlDocRecId);
        if (!viewDocument.loadDatasOfChnlDoc(sSelectFieldsOfChnlDoc)) {
            return null;
        }
        if (_sSelectFieldsOfDocument == null || _sSelectFieldsOfDocument.trim().length() == 0) {
            return viewDocument;
        }
        String sSelectFieldsOfDocument = _sSelectFieldsOfDocument.toUpperCase();
        if (sSelectFieldsOfDocument.indexOf(" FROM ") >= 0) {
            return null;
        }
        viewDocument.loadDatasOfDocument(sSelectFieldsOfDocument);
        return viewDocument;
    }

    protected boolean loadDatasOfChnlDoc(String _sSelectFields) throws WCMException {
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet rsData = null;
        String strSQL = "select " + _sSelectFields + " from WCMChnlDoc where RecId=?";
        try {
            oConn = this.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement(strSQL);
            oPreStmt.setMaxRows(1);
            oPreStmt.setFetchSize(1);
            oPreStmt.setInt(1, this.getId());
            rsData = oPreStmt.executeQuery();
            if (!rsData.next()) {
                boolean bl = false;
                return bl;
            }
            ResultSetMetaData rsmdData = rsData.getMetaData();
            int nColCount = rsmdData.getColumnCount();
            Object objValue = null;
            for (int i = 1; i <= nColCount; ++i) {
                String sFieldName = rsmdData.getColumnLabel(i).toUpperCase();
                if (sFieldName.equals(ID_FIELD_NAME)) {
                    this.setDocId(rsData.getInt(i));
                    continue;
                }
                objValue = null;
                switch (rsmdData.getColumnType(i)) {
                    case 2: 
                    case 3: {
                        if (rsmdData.getScale(i) <= 0) {
                            long lValue = rsData.getLong(i);
                            if (rsData.wasNull()) break;
                            objValue = new Long(lValue);
                            break;
                        }
                        Double dValue = new Double(rsData.getDouble(i));
                        if (rsData.wasNull()) break;
                        objValue = dValue;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        long lValue = rsData.getLong(i);
                        if (rsData.wasNull()) break;
                        objValue = new Long(lValue);
                        break;
                    }
                    case 12: {
                        objValue = rsData.getString(i);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        objValue = new CMyDateTime();
                        ((CMyDateTime)objValue).setDateTimeWithRs(rsData, i);
                        break;
                    }
                    case 8: {
                        double dValue = rsData.getDouble(i);
                        if (rsData.wasNull()) break;
                        objValue = new Double(dValue);
                        break;
                    }
                    default: {
                        objValue = rsData.getObject(i);
                    }
                }
                if (objValue == null) continue;
                this.setChnlDocProperty(sFieldName, objValue);
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(ViewDocument.class, "ViewDocument.label10", "\u8f7d\u5165ChnlDoc\u6570\u636e[RecId=") + this.getId() + I18NMessage.get(ViewDocument.class, "ViewDocument.label11", "]\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff1a\n") + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(ViewDocument.class, "ViewDocument.label10", "\u8f7d\u5165ChnlDoc\u6570\u636e[RecId=") + this.getId() + I18NMessage.get(ViewDocument.class, "ViewDocument.label12", "]\u5931\u8d25"), ex);
        }
        finally {
            try {
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (oPreStmt != null) {
                    oPreStmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    protected boolean loadDatasOfDocument(String _sSelectFields) throws WCMException {
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet rsData = null;
        String strSQL = "select " + _sSelectFields + " from WCMDocument where DocId=?";
        try {
            oConn = this.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement(strSQL);
            oPreStmt.setMaxRows(1);
            oPreStmt.setFetchSize(1);
            oPreStmt.setInt(1, this.getDocId());
            rsData = oPreStmt.executeQuery();
            if (!rsData.next()) {
                boolean bl = false;
                return bl;
            }
            this.setLoadText(true);
            ResultSetMetaData rsmdData = rsData.getMetaData();
            this.readFromRs(rsData, rsmdData);
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(ViewDocument.class, "ViewDocument.label13", "\u8f7d\u5165Document\u6570\u636e[RecId=") + this.getDocId() + I18NMessage.get(ViewDocument.class, "ViewDocument.label11", "]\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff1a\n") + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(ViewDocument.class, "ViewDocument.label14", "\u8f7d\u5165Document\u6570\u636e\u5931\u8d25"), ex);
        }
        finally {
            try {
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (oPreStmt != null) {
                    oPreStmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    public final void readChnlDocPropertyFromRs(ResultSet _rsData, ResultSetMetaData _rsmdData) throws WCMException {
        try {
            if (_rsData == null) {
                return;
            }
            Object objValue = null;
            ResultSetMetaData rsmdData = _rsmdData != null ? _rsmdData : _rsData.getMetaData();
            int nColCount = rsmdData.getColumnCount();
            for (int i = 1; i <= nColCount; ++i) {
                String sFieldName = rsmdData.getColumnLabel(i).toUpperCase();
                if (sFieldName.equalsIgnoreCase(ID_FIELD_NAME)) {
                    this.setDocId(_rsData.getInt(i));
                    continue;
                }
                objValue = null;
                switch (rsmdData.getColumnType(i)) {
                    case 2: 
                    case 3: {
                        if (rsmdData.getScale(i) <= 0) {
                            long lValue = _rsData.getLong(i);
                            if (_rsData.wasNull()) break;
                            objValue = new Long(lValue);
                            break;
                        }
                        Double dValue = new Double(_rsData.getDouble(i));
                        if (_rsData.wasNull()) break;
                        objValue = dValue;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        long lValue = _rsData.getLong(i);
                        if (_rsData.wasNull()) break;
                        objValue = new Long(lValue);
                        break;
                    }
                    case 12: {
                        objValue = _rsData.getString(i);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        objValue = new CMyDateTime();
                        ((CMyDateTime)objValue).setDateTimeWithRs(_rsData, i);
                        break;
                    }
                    case -1: 
                    case 2005: {
                        objValue = new CDBText(this.getDBManager().getDBType());
                        ((CDBText)objValue).readFromRs(_rsData, i);
                        break;
                    }
                    case 8: {
                        double dValue = _rsData.getDouble(i);
                        if (_rsData.wasNull()) break;
                        objValue = new Double(dValue);
                        break;
                    }
                    default: {
                        objValue = _rsData.getObject(i);
                    }
                }
                if (objValue == null) continue;
                this.setChnlDocProperty(sFieldName, objValue);
            }
            this.id = this.getChnlDocProperty("RECID", 0);
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(ViewDocument.class, "ViewDocument.label15", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".readChnlDocPropertyFromRs).", ex);
        }
        catch (CMyException ex) {
            throw new WCMException(1, I18NMessage.get(ViewDocument.class, "ViewDocument.label15", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".readChnlDocPropertyFromRs).", ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(ViewDocument.class, "ViewDocument.label15", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".readChnlDocPropertyFromRs).", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument() throws WCMException {
        if (this.m_oDocument == null) {
            ViewDocument viewDocument = this;
            synchronized (viewDocument) {
                if (this.m_oDocument != null) {
                    return this.m_oDocument;
                }
                this.m_oDocument = Document.createNewInstance();
                this.m_oDocument.setMyDocId(this.m_nDocId);
                this.m_oDocument.setProperties(this.m_hProperties);
            }
        }
        return this.m_oDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChnlDoc getChnlDoc() throws WCMException {
        if (this.m_oChnlDoc == null) {
            ViewDocument viewDocument = this;
            synchronized (viewDocument) {
                if (this.m_oChnlDoc != null) {
                    return this.m_oChnlDoc;
                }
                this.m_oChnlDoc = ChnlDoc.createNewInstance();
                this.m_oChnlDoc.setId(this.getId());
                this.m_oChnlDoc.setProperties(this.m_hChnlDocProperties);
            }
        }
        return this.m_oChnlDoc;
    }

    @Override
    public Map<String, Object> getExtProperties() {
        return this.m_hChnlDocProperties;
    }

    @Override
    public void setExtProperty(String _sName, Object _oValue) {
        if (CMyString.isEmpty(_sName)) {
            return;
        }
        this.m_hChnlDocProperties.put(_sName.toUpperCase(), _oValue);
    }

    @Override
    public Object getExtProperty(String _sName) {
        if (CMyString.isEmpty(_sName)) {
            return null;
        }
        return this.m_hChnlDocProperties.get(_sName.toUpperCase());
    }
}

