/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.stat.IKeyMaker;
import com.trs.components.stat.IStatResult;
import com.trs.components.stat.IStatResultFilter;
import com.trs.infra.common.WCMException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StatResult
implements IStatResult {
    private List majorObjects;
    private List results;
    private IKeyMaker keyMaker;

    public StatResult(List _majorObjects, List _results, IKeyMaker _keyMaker) {
        this.majorObjects = _majorObjects;
        this.results = _results;
        this.keyMaker = _keyMaker;
    }

    @Override
    public int getResult(String[] keys) {
        return this.getResult(1, keys);
    }

    @Override
    public int getResult(int index, String[] keys) {
        String sKey = this.keyMaker.makeKey(keys);
        return this.getResult(index, sKey);
    }

    @Override
    public int getResult(int index, String key) {
        Map result = (Map)this.results.get(index - 1);
        Integer dataCount = (Integer)result.get(key);
        return dataCount != null ? dataCount : 0;
    }

    @Override
    public int getResult(String key) {
        return this.getResult(1, key);
    }

    @Override
    public IStatResult filter(IStatResultFilter resultFilter) {
        List list = this.list();
        ArrayList<String> newMajorObjects = new ArrayList<String>(list.size());
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            String sKey = (String)list.get(i);
            if (!resultFilter.accept(sKey, this)) continue;
            newMajorObjects.add(sKey);
        }
        StatResult statResult = new StatResult(newMajorObjects, this.results, this.keyMaker);
        return statResult;
    }

    @Override
    public List sort(boolean sortDesc) throws WCMException {
        return this.sortWithSQLIndex(1, sortDesc);
    }

    @Override
    public List sort(int index, int keyIndex, String keyValue, boolean sortDesc) throws WCMException {
        return this.majorObjects;
    }

    @Override
    public List sort(int index, String keyValue, boolean sortDesc) throws WCMException {
        return this.majorObjects;
    }

    @Override
    public List sortByMajorObject(boolean sortDesc) {
        return this.majorObjects;
    }

    @Override
    public List sortWithSQLIndex(int index, final boolean sortDesc) throws WCMException {
        String sKey;
        final Map result = (Map)this.results.get(index - 1);
        Iterator itr = result.keySet().iterator();
        if (itr.hasNext() && this.keyMaker.makeFields(sKey = (String)itr.next()).length >= 2) {
            throw new WCMException("\u8be5\u63a5\u53e3\u4ec5\u5bf9select\u5b57\u6bb5\u4e3a\u4e24\u4e2a\u5b57\u6bb5\u65f6\u6709\u6548");
        }
        Collections.sort(this.majorObjects, new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer value1 = (Integer)result.get(o1);
                Integer value2 = (Integer)result.get(o2);
                if (value1 == null || value2 == null) {
                    return sortDesc ? 1 : -1;
                }
                if (sortDesc) {
                    return value2 - value1;
                }
                return value1 - value2;
            }
        });
        return this.majorObjects;
    }

    @Override
    public List list() {
        return this.majorObjects;
    }
}

