/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MetaDataCenterServiceProviderForZJH
implements ISelfDefinedServiceProvider {
    private static Logger logger = Logger.getLogger(MetaDataCenterServiceProviderForZJH.class);

    public MetaViewData saveMetaViewDataOfGov(MethodContext _methodContext) throws Throwable {
        return this.saveMetaViewData(_methodContext);
    }

    public MetaViewData saveMetaViewData(MethodContext _methodContext) throws Throwable {
        String sChannelName;
        User loginUser = this.getLoginUser();
        int nSiteId = _methodContext.getValue("SiteId", 3);
        Channel channel = Channel.findByName(nSiteId, sChannelName = _methodContext.getValue("ChannelName"));
        if (channel == null) {
            logger.warn((Object)("\u6307\u5b9a\u7684\u680f\u76ee[Name=" + sChannelName + "]\u5728\u7ad9\u70b9[ID=" + nSiteId + "]\u4e2d\u4e0d\u5b58\u5728\uff01"));
            channel = this.findChannelById(_methodContext.getValue("ChannelId", 2386));
        }
        if (!AuthServer.hasRight(loginUser, (CMSObj)channel, 31)) {
            throw new WCMException(1002, "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[" + channel.getName() + "][ID=" + channel.getId() + "]\u4e0b\u65b0\u5efa\u8bb0\u5f55\uff01");
        }
        MetaView view = this.findViewById(_methodContext.getValue("ViewId", 0));
        MetaViewData oMetaViewData = new MetaViewData(view);
        MetaDataCenterServiceProviderForZJH.setViewDataProperties(_methodContext, oMetaViewData);
        oMetaViewData.setProperty("ChannelId", channel.getId());
        IMetaDataDefCacheMgr oCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
        HashMap hViewFields = oCacheMgr.getMetaViewFields(view.getId());
        Set fieldNames = hViewFields.keySet();
        for (String fieldName : fieldNames) {
            String sClassNames;
            MetaViewField viewField = (MetaViewField)hViewFields.get(fieldName);
            if (viewField.getType() != 10 || (sClassNames = oMetaViewData.getPropertyAsString(fieldName)) == null || (sClassNames = sClassNames.trim()).length() == 0) continue;
            String sClassIds = this.convertToClassIds(viewField.getClassId(), sClassNames);
            oMetaViewData.setProperty(fieldName, sClassIds);
        }
        oMetaViewData.save(loginUser);
        String sDocIntoFlow = ConfigServer.getServer().getSysConfigValue("DOCADD_INTO_FLOW", "true");
        boolean bDocIntoFlow = "true".equalsIgnoreCase(sDocIntoFlow);
        if (bDocIntoFlow) {
            Document document = Document.findById(oMetaViewData.getId());
            try {
                WCMProcessServiceHelper.startDocumentInFlow(loginUser, document, _methodContext);
            }
            catch (Throwable ex) {
                ServiceInvocationException exp = new ServiceInvocationException("\u867d\u7136\u5df2\u6210\u529f\u65b0\u589e\u6587\u6863[" + document.getTitle() + "-" + document.getId() + "]\uff0c\u4f46\u5c06\u5176\u6295\u5165\u6d41\u8f6c\u5931\u8d25\uff01", ex);
                exp.setErrorCode("17080");
                throw exp;
            }
        }
        return oMetaViewData;
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    private Channel findChannelById(int _nObjectId) throws WCMException {
        Channel channel = Channel.findById(_nObjectId);
        if (channel == null) {
            throw new WCMException(200006, "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=" + _nObjectId + "]\uff01");
        }
        return channel;
    }

    private MetaView findViewById(int _nViewId) throws WCMException {
        MetaView view = MetaView.findById(_nViewId);
        if (view == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[Id=" + _nViewId + "]");
        }
        return view;
    }

    public static MetaViewData setViewDataProperties(MethodContext _methodContext, MetaViewData _oViewData) throws WCMException {
        Map mapParams = _methodContext.getParams();
        for (String sParamName : mapParams.keySet()) {
            Object value = mapParams.get(sParamName);
            if (value instanceof String) {
                _oViewData.setProperty(sParamName, value.toString().trim());
                continue;
            }
            if (value instanceof String[]) {
                String[] pValues = (String[])value;
                _oViewData.setProperty(sParamName, pValues == null || pValues.length == 0 ? null : pValues[0].trim());
                continue;
            }
            _oViewData.setProperty(sParamName, value);
        }
        return _oViewData;
    }

    private String convertToClassIds(int _nRootId, String _sClassNames) throws WCMException {
        if (CMyString.isEmpty(_sClassNames)) {
            return "";
        }
        WCMFilter filter = new WCMFilter("", "", "", String.valueOf("CLASSINFOID"));
        String[] pValues = _sClassNames.split(";");
        StringBuffer sbWhere = new StringBuffer(pValues.length * 2 + 20);
        sbWhere.append("RootId=? and CName in(");
        filter.addSearchValues(_nRootId);
        boolean bHasClassName = false;
        for (int i = 0; i < pValues.length; ++i) {
            pValues[i] = pValues[i].trim();
            if (pValues[i].length() == 0) continue;
            int nPos = pValues[i].lastIndexOf(92);
            if (nPos >= 0) {
                String[] pClassNamePath = pValues[i].split("\\\\");
                int nParentId = _nRootId;
                for (int j = 0; j < pClassNamePath.length && (CMyString.isEmpty(pClassNamePath[j]) || (nParentId = this.queryClassId(nParentId, pClassNamePath[j])) != 0); ++j) {
                }
                if (nParentId <= 0) continue;
                return String.valueOf(nParentId);
            }
            bHasClassName = true;
            sbWhere.append("?,");
            filter.addSearchValues(pValues[i]);
        }
        if (!bHasClassName) {
            return "";
        }
        sbWhere.setLength(sbWhere.length() - 1);
        sbWhere.append(")");
        filter.setWhere(sbWhere.toString());
        filter.setMaxRowNumber(pValues.length);
        StringBuffer sbClassIds = new StringBuffer(pValues.length * 2);
        ClassInfos infos = ClassInfos.openWCMObjs(null, filter);
        if (infos == null || infos.isEmpty()) {
            return "";
        }
        sbClassIds.append(infos.getIdAt(0));
        return sbClassIds.toString();
    }

    private int queryClassId(int _nParentId, String _sClassName) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ParentId=? and CName=?", "", String.valueOf("CLASSINFOID"));
        filter.setMaxRowNumber(1);
        filter.addSearchValues(_nParentId);
        filter.addSearchValues(_sClassName);
        ClassInfos infos = ClassInfos.openWCMObjs(null, filter);
        if (infos == null || infos.isEmpty()) {
            return 0;
        }
        return infos.getIdAt(0);
    }
}

