/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.HTMLContent;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.element.IRelateResource;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class MetaViewDataRelateSource
implements IRelateResource {
    private static final List EMPTY_LIST = new AbstractList(){

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        public int size() {
            return 0;
        }
    };

    @Override
    public List getResourceNames(IPublishContent content) throws WCMException {
        Document doc = (Document)content.getSubstance();
        int nViewId = doc.getKindId();
        if (nViewId <= 0) {
            return EMPTY_LIST;
        }
        MetaView view = MetaView.findById(nViewId);
        MetaViewData data = MetaViewData.findById(view.getTrueTableName(), doc.getId());
        if (data == null) {
            return EMPTY_LIST;
        }
        WCMFilter filter = new WCMFilter("", "VIEWID=? and (FIELDTYPE=? or FIELDTYPE=?)", "");
        filter.addSearchValues(nViewId);
        filter.addSearchValues(8);
        filter.addSearchValues(12);
        MetaViewFields fields = MetaViewFields.openWCMObjs(User.getSystem(), filter);
        if (fields.isEmpty()) {
            return EMPTY_LIST;
        }
        MetaViewField field = null;
        ArrayList<String> result = new ArrayList<String>(fields.size() * 2);
        String value = null;
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            field = (MetaViewField)fields.getAt(i);
            if (field == null) continue;
            value = data.getPropertyAsString(field.getName());
            if (field.getType() == 8) {
                value = value.split(",")[0];
                result.add(value);
                continue;
            }
            HTMLContent html = new HTMLContent(value);
            result.addAll(html.getWCMFiles());
        }
        return result;
    }
}

