/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.components.metadata.definition.IDefaultFieldsCreator;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultFieldsFactory {
    private static Logger logger = Logger.getLogger(DefaultFieldsFactory.class);
    private static Map<String, List<IDefaultFieldsCreator>> s_mCreators = null;

    public static List<IDefaultFieldsCreator> createDefaultFieldsCreator(String _sTableName) {
        if (s_mCreators == null) {
            DefaultFieldsFactory.init();
        }
        ArrayList<IDefaultFieldsCreator> arCurrentPreTableNames = new ArrayList<IDefaultFieldsCreator>(s_mCreators.size());
        for (String sPreTableName : s_mCreators.keySet()) {
            if (!_sTableName.toUpperCase().startsWith(sPreTableName.toUpperCase())) continue;
            arCurrentPreTableNames.addAll((Collection<IDefaultFieldsCreator>)s_mCreators.get(sPreTableName.toUpperCase()));
        }
        return arCurrentPreTableNames;
    }

    private static synchronized void init() {
        if (s_mCreators != null) {
            return;
        }
        try {
            Iterator itCreator = WCMDiscoveryFactory.getDiscovery().getImplementors(IDefaultFieldsCreator.class.getName());
            HashMap<String, List<IDefaultFieldsCreator>> hTempForParser = new HashMap<String, List<IDefaultFieldsCreator>>();
            while (itCreator.hasNext()) {
                String sCreatorClassName = (String)itCreator.next();
                Class<?> oCreatorClass = Class.forName(sCreatorClassName);
                IDefaultFieldsCreator creator = (IDefaultFieldsCreator)oCreatorClass.newInstance();
                String[] pRegisterPreTableNames = creator.registerPreTableNames();
                for (int i = 0; i < pRegisterPreTableNames.length; ++i) {
                    String sRegisterPreTableName = pRegisterPreTableNames[i].toUpperCase();
                    ArrayList<IDefaultFieldsCreator> arTemp = (ArrayList<IDefaultFieldsCreator>)hTempForParser.get(sRegisterPreTableName);
                    if (arTemp == null) {
                        arTemp = new ArrayList<IDefaultFieldsCreator>(1);
                        arTemp.add(creator);
                        hTempForParser.put(sRegisterPreTableName, arTemp);
                        continue;
                    }
                    arTemp.add(creator);
                }
            }
            s_mCreators = hTempForParser;
            return;
        }
        catch (Exception e) {
            logger.error((Object)"\u521d\u59cb\u5316\u9ed8\u8ba4\u5b57\u6bb5\u4ea7\u751f\u5668\u5931\u8d25\uff01", (Throwable)e);
            return;
        }
    }
}

