/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.infoview.db.LetterConvertor;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;

public class Widget
extends CMSObj {
    public static final int OBJ_TYPE = 665370270;
    public static final String DB_TABLE_NAME = "XWCMWIDGET";
    public static final String DB_ID_NAME = "WIDGETID";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 665370270;
    }

    public String getWname() {
        return this.getPropertyAsString("WNAME");
    }

    public boolean setWname(String _sWname) throws WCMException {
        return this.setProperty("WNAME", _sWname);
    }

    public String getWdesc() {
        return this.getPropertyAsString("WDESC");
    }

    public boolean setWdesc(String _sWdesc) throws WCMException {
        return this.setProperty("WDESC", _sWdesc);
    }

    public String getWCategory() {
        return this.getPropertyAsString("WIDGETCATEGORY");
    }

    public boolean setWCategory(int _sWCategory) throws WCMException {
        return this.setProperty("WIDGETCATEGORY", _sWCategory);
    }

    public String getWidgetcontent() {
        CDBText txtValue = (CDBText)this.getProperty("WIDGETCONTENT");
        if (txtValue == null) {
            return null;
        }
        return txtValue.getText();
    }

    public boolean setWidgetcontent(String _sWidgetcontent) throws WCMException {
        return this.setProperty("WIDGETCONTENT", new CDBText(this.getDBManager().getDBTypeAsInt(), _sWidgetcontent));
    }

    public String getWidgetpic() {
        return this.getPropertyAsString("WIDGETPIC");
    }

    public boolean setWidgetpic(String _sWidgetpic) throws WCMException {
        return this.setProperty("WIDGETPIC", _sWidgetpic);
    }

    public String getWDefaultStyle() {
        return this.getPropertyAsString("WDEFAULTSTYLE");
    }

    public boolean setWDefaultStyle(String _sWDefaultStyle) throws WCMException {
        return this.setProperty("WDEFAULTSTYLE", _sWDefaultStyle);
    }

    public String getCDefaultStyle() {
        return this.getPropertyAsString("CDEFAULTSTYLE");
    }

    public boolean setCDefaultStyle(int _nCDefaultStyle) throws WCMException {
        return this.setProperty("CDEFAULTSTYLE", _nCDefaultStyle);
    }

    public String getWidgetAttrURL() {
        return this.getPropertyAsString("WIDGETATTRURL");
    }

    public boolean setWidgetAttrURL(String _sWidgetAttrURL) throws WCMException {
        return this.setProperty("WIDGETATTRURL", _sWidgetAttrURL);
    }

    public String getContentStyle() {
        return this.getPropertyAsString("CONTENTSTYLE");
    }

    public boolean setContentStyle(String _sContentStyle) throws WCMException {
        return this.setProperty("CONTENTSTYLE", _sContentStyle);
    }

    public int getWidgetType() {
        return this.getPropertyAsInt("WIDGETTYPE", 0);
    }

    public boolean setWidgetType(int _nWidgetType) throws WCMException {
        return this.setProperty("WIDGETTYPE", _nWidgetType);
    }

    public String getIdentityFlag(String _sWidgetName) throws WCMException {
        if (CMyString.isEmpty(_sWidgetName)) {
            return "";
        }
        return LetterConvertor.convertToFirstLetter(_sWidgetName);
    }

    public int getOrder() {
        return this.getPropertyAsInt("WIDGETORDER", 0);
    }

    public boolean setOrder(int _order) throws WCMException {
        return this.setProperty("WIDGETORDER", _order);
    }

    private void changeOrder() throws WCMException {
        int nMaxOrder;
        int nNewOrder;
        int nMoveBeginAt = 0;
        int nMoveEndAt = 0;
        int nMoveDirection = 0;
        if (this.isAddMode()) {
            nNewOrder = this.getOrder();
            nMaxOrder = this.getMaxOrder();
            if (nNewOrder == -1) {
                nNewOrder = nMaxOrder + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = nMaxOrder;
                nMoveBeginAt = nNewOrder;
            }
        } else {
            if (!this.isChangeProperty("WIDGETORDER")) {
                return;
            }
            nNewOrder = this.getNewPropertyAsInt("WIDGETORDER", -1);
            if (nNewOrder == -1) {
                nMaxOrder = this.getMaxOrder();
                if (nMaxOrder == this.getOrder()) {
                    nNewOrder = this.getOrder();
                } else {
                    nMoveDirection = -1;
                    nMoveEndAt = nMaxOrder;
                    nMoveBeginAt = this.getOrder() + 1;
                    nNewOrder = nMaxOrder;
                }
            } else if (nNewOrder > this.getOrder()) {
                nMoveDirection = -1;
                nMoveEndAt = --nNewOrder;
                nMoveBeginAt = this.getOrder() + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = this.getOrder() - 1;
                nMoveBeginAt = nNewOrder;
            }
        }
        String sRegionWhere = "WIDGETORDER>=" + nMoveBeginAt + " AND WIDGETORDER <= " + nMoveEndAt;
        String sMoveSql = "UPDATE XWCMWIDGET SET WIDGETORDER = WIDGETORDER+(" + nMoveDirection + ") WHERE " + sRegionWhere;
        DBManager.getDBManager().sqlExecuteUpdate(sMoveSql);
        this.setOrder(nNewOrder);
    }

    private synchronized int getMaxOrder() throws WCMException {
        StringBuffer buff = new StringBuffer("SELECT max(WIDGETORDER) FROM ");
        buff.append(DB_TABLE_NAME);
        return DBManager.getDBManager().sqlExecuteIntQuery(buff.toString());
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("WNAME") == null) {
                throw new WCMException(1106, "\u5c5e\u6027Wname\u6ca1\u6709\u8bbe\u7f6e(Widget.isValid)");
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Widget.isValid)");
        }
        this.changeOrder();
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    public static final Widget findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Widget)BaseObj.findById(Widget.class, _nId);
    }

    public static final Widget createNewInstance() throws WCMException {
        return (Widget)BaseObj.createNewInstance(Widget.class);
    }

    public static final Widget findByKey(Object _oKey) throws WCMException {
        return (Widget)BaseObj.findByKey(Widget.class, _oKey);
    }
}

