/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.element;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.domain.template.TemplateQuoteMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;

public class PublishFolderLCListener
implements IObjectLCListenerOnDel {
    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        BaseObjs templates = null;
        try {
            int nType = _oObjDeleted.getWCMType();
            if (!PublishElementFactory.isFolderType(nType)) {
                return;
            }
            TemplateMgr mgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom((CMSObj)_oObjDeleted);
            FolderPublishConfig config = FolderPublishConfig.findOf(folder);
            templates = mgr.getManagedTemplates(folder, -1, null, false);
            if (templates != null) {
                for (int i = 0; i < templates.size(); ++i) {
                    Template aTemplate = (Template)templates.getAt(i);
                    if (aTemplate == null) continue;
                    mgr.delete(aTemplate);
                }
                templates.clear();
            }
            TemplateEmployMgr employMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            employMgr.clearEmploysOfEmployer(nType, _oObjDeleted.getId());
            TemplateQuoteMgr quoteMgr = (TemplateQuoteMgr)DreamFactory.createObjectById("TemplateQuoteMgr");
            quoteMgr.clearQuotesOfFolder(folder);
            if (config != null) {
                config.delete(ContextHelper.getLoginUser());
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to delete templates in the folder to deleted!", ex);
        }
        finally {
            if (templates != null) {
                templates.clear();
            }
        }
    }
}

