/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.distribute.IFileDistristributor;
import com.trs.components.common.publish.domain.distribute.UftpConnectionCacheManager;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.uftp.FtpConnection;
import com.trs.infra.util.uftp.FtpConnectionCache;
import com.trs.mlf.log.LogUserUtil;
import com.trs.mlf.simplelog.LogConstant;
import com.trs.mlf.simplelog.SimpleLogServer;
import org.apache.log4j.Logger;

public class FileDistributorImpFtpByTRS
implements IFileDistristributor {
    private static final Logger s_logger = Logger.getLogger(FileDistributorImpFtpByTRS.class);
    private int m_iDistributionID = 0;
    private String m_sRootDirectory = null;
    private FtpConnection m_oFtpConnection = null;

    private void assertReady() throws WCMException {
        if (this.m_oFtpConnection != null) {
            return;
        }
        s_logger.error((Object)I18NMessage.get(FileDistributorImpFtpByTRS.class, "FileDistributorImpFtpByTRS.label1", "\u5f53\u524d\u5206\u53d1\u76ee\u6807\u7684FTP\u7ba1\u7406\u5668\u6709\u8bef\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u4ee5\u53caFTP\u670d\u52a1\u5668\u4e0a\u7684\u6743\u9650\u8bbe\u7f6e\uff01"));
        throw new WCMException(I18NMessage.get(FileDistributorImpFtpByTRS.class, "FileDistributorImpFtpByTRS.label1", "\u5f53\u524d\u5206\u53d1\u76ee\u6807\u7684FTP\u7ba1\u7406\u5668\u6709\u8bef\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u4ee5\u53caFTP\u670d\u52a1\u5668\u4e0a\u7684\u6743\u9650\u8bbe\u7f6e\uff01"));
    }

    @Override
    public int getConfigID() {
        return this.m_iDistributionID;
    }

    @Override
    public void setTargetRoot(PublishDistribution _distribution) throws Exception {
        this.m_iDistributionID = _distribution.getId();
        this.m_sRootDirectory = _distribution.getDataPath();
        UftpConnectionCacheManager uccm = (UftpConnectionCacheManager)DreamFactory.createObjectById("UftpConnectionCacheManager");
        FtpConnectionCache cache = uccm.getConnectionCache(_distribution);
        this.m_oFtpConnection = cache.getConnectionWrapper();
        this.reviseRootPath();
    }

    private void reviseRootPath() throws Exception {
        String sTemp;
        if (this.m_sRootDirectory.charAt(0) != '/') {
            sTemp = this.m_oFtpConnection.toAbsolutePath(this.m_sRootDirectory);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("[" + this.m_sRootDirectory + "] revised to[" + sTemp + "]"));
            }
            this.m_sRootDirectory = sTemp;
        }
        if (this.m_sRootDirectory.charAt(this.m_sRootDirectory.length() - 1) != '/') {
            sTemp = this.m_sRootDirectory + '/';
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("[" + this.m_sRootDirectory + "] revised to[" + sTemp + "]"));
            }
            this.m_sRootDirectory = sTemp;
        }
    }

    private String returnFullPath(String _sSubPath) {
        _sSubPath = _sSubPath.replace('\\', '/');
        return this.m_sRootDirectory + CMyString.setStrEndWith(_sSubPath, '/');
    }

    @Override
    public void distributeFile(String sLocal, String sPath, boolean _bCheckDstFileExits) throws Exception {
        StringBuffer sb;
        this.assertReady();
        String sRemote = this.returnFullPath(sPath) + CMyFile.extractFileName(sLocal);
        if (s_logger.isDebugEnabled()) {
            sb = new StringBuffer(512);
            sb.append("to upload file [");
            sb.append(sLocal);
            sb.append("] to [");
            sb.append(sRemote);
            sb.append("] in ");
            sb.append(this.m_oFtpConnection.getFtpConfig());
            s_logger.debug((Object)sb.toString());
        }
        if (_bCheckDstFileExits && this.m_oFtpConnection.hasTheFile(sRemote)) {
            if (s_logger.isDebugEnabled()) {
                sb = new StringBuffer(512);
                sb.append("The file [");
                sb.append(sRemote);
                sb.append("] has exists!");
                s_logger.debug((Object)sb.toString());
            }
            return;
        }
        boolean bSuccess = false;
        int nCount = 0;
        int nMaxCount = 4;
        while (!bSuccess) {
            ++nCount;
            try {
                bSuccess = this.m_oFtpConnection.uploadFile(sLocal, sRemote);
                if (bSuccess) {
                    SimpleLogServer.distribute(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "", String.format("\u6dfb\u52a0\u6216\u4fee\u6539\u6587\u4ef6[%s]\uff0c\u8def\u5f84[%s]", CMyFile.extractFileName(sLocal), sRemote));
                }
                if (s_logger.isDebugEnabled()) {
                    StringBuffer sb2 = new StringBuffer(512);
                    sb2.append("Upload file [");
                    sb2.append(sRemote);
                    sb2.append("] end!");
                    s_logger.debug((Object)sb2.toString());
                }
            }
            catch (Exception e) {
                bSuccess = false;
                if (nCount >= nMaxCount) {
                    throw e;
                }
                StringBuffer sb3 = new StringBuffer(512);
                sb3.append("Try to upload file [");
                sb3.append(sLocal);
                sb3.append("] to [");
                sb3.append(sRemote);
                sb3.append("] in ");
                sb3.append(this.m_oFtpConnection.getFtpConfig());
                sb3.append("again");
                s_logger.error((Object)sb3);
                s_logger.error((Object)"Error Info", (Throwable)e);
            }
            if (nCount < nMaxCount) continue;
            break;
        }
    }

    @Override
    public boolean renameFile(String _sSourceFile, String _sTargetFile, String _sFullDataPath) throws Exception {
        this.assertReady();
        String sRemotePath = this.returnFullPath(_sFullDataPath);
        String sSourcePathName = sRemotePath + _sSourceFile;
        String sTragetPathName = sRemotePath + _sTargetFile;
        if (s_logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer(512);
            sb.append("to rename file [");
            sb.append(sSourcePathName);
            sb.append("] to [");
            sb.append(sTragetPathName);
            sb.append("] on ");
            sb.append(this.m_oFtpConnection.getFtpConfig());
            s_logger.debug((Object)sb.toString());
        }
        return this.m_oFtpConnection.renameFile(sSourcePathName, _sTargetFile);
    }

    @Override
    public boolean withdrawFile(String sFile, String sPath) throws Exception {
        this.assertReady();
        String sRemoteFile = this.returnFullPath(sPath) + sFile;
        if (s_logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer(512);
            sb.append("to remove file [");
            sb.append(sRemoteFile);
            sb.append("] from ");
            sb.append(this.m_oFtpConnection.getFtpConfig());
            s_logger.debug((Object)sb.toString());
        }
        boolean isSuccess = false;
        isSuccess = this.m_oFtpConnection.deleteFile(sRemoteFile);
        if (isSuccess) {
            SimpleLogServer.distribute(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "", String.format("\u5220\u9664\u6587\u4ef6[%s]\uff0c\u8def\u5f84[%s]", sFile, sRemoteFile));
        }
        return isSuccess;
    }

    @Override
    public boolean withdrawPath(String sPath) throws Exception {
        this.assertReady();
        String sRemotePath = this.returnFullPath(sPath);
        if (s_logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer(512);
            sb.append("to remove path [");
            sb.append(sRemotePath);
            sb.append("] from ");
            sb.append(this.m_oFtpConnection.getFtpConfig());
            s_logger.debug((Object)sb.toString());
        }
        boolean isSuccess = false;
        isSuccess = this.m_oFtpConnection.deleteDirectory(sRemotePath);
        if (isSuccess) {
            SimpleLogServer.distribute(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "", String.format("\u5220\u9664\u6587\u4ef6\u8def\u5f84[%s]", sRemotePath));
        }
        return isSuccess;
    }
}

