/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.job;

import com.trs.components.common.job.Schedule;
import com.trs.infra.util.job.BaseJob;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;

public abstract class BaseScheduleWorker
extends BaseJob {
    private static Logger logger = Logger.getLogger(BaseScheduleWorker.class);

    @Override
    public void execute(JobExecutionContext _currContext) {
        super.execute(_currContext);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Job:" + _currContext.getJobDetail() + " next fire at:" + _currContext.getTrigger().getNextFireTime()));
        }
        this.clearScheduleIfNecessary(_currContext);
    }

    private void clearScheduleIfNecessary(JobExecutionContext _context) {
        String sName = "";
        if (_context.getTrigger().getNextFireTime() == null) {
            try {
                sName = _context.getJobDetail().getName();
                String sId = sName.substring(sName.indexOf("[") + 1, sName.indexOf("]"));
                Schedule schedule = Schedule.findById(Integer.parseInt(sId));
                if (schedule != null) {
                    if (schedule.getParam() > 0) {
                        // empty if block
                    }
                    schedule.delete();
                }
            }
            catch (Exception e) {
                logger.error((Object)("failed to delete the one time schedule[" + sName + " after it had excuted!"), (Throwable)e);
            }
        }
    }
}

