/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowdocLog;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.process.element.FlowContentDocumentImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class FlowingDocLogger {
    public static final int ACTION_FLAG_NORMAL = 0;
    public static final int ACTION_FLAG_PREPROCESS = 1;
    private static Logger logger = Logger.getLogger(FlowingDocLogger.class);

    private FlowingDocLogger() {
    }

    public static void info(FlowContext _context, String _sActionDesc) {
        try {
            IFlowContent content = _context.getFlowContent();
            FlowDoc flowdoc = _context.getCurrFlowDoc();
            if (flowdoc == null || content == null) {
                return;
            }
            if (content instanceof FlowContentDocumentImpl) {
                FlowingDocLogger.logDocument(_context, _sActionDesc, content, flowdoc);
            } else if (content.getClass().getName().equals("com.trs.components.wcm.process.element.FlowContentApplyFormImpl")) {
                FlowingDocLogger.logApplyForm(_context, _sActionDesc, content, flowdoc);
            }
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
    }

    private static void logDocument(FlowContext _context, String _sActionDesc, IFlowContent content, FlowDoc flowdoc) {
        try {
            Document doc = ((FlowContentDocumentImpl)content).getDocument();
            if (doc == null) {
                return;
            }
            String sFieldValue = _sActionDesc;
            FlowNodeBranch branch = _context.getBranch();
            if (sFieldValue == null && branch != null && branch.isOperationMarkEnable()) {
                sFieldValue = branch.getOperationMark();
            }
            FlowdocLog log = new FlowdocLog();
            if (!CMyString.isEmpty(sFieldValue)) {
                log.setActionDesc(sFieldValue);
            }
            if (branch != null) {
                log.setBranchId(branch.getId());
            }
            log.setActionFlag(FlowingDocLogger.getActionFlag(_sActionDesc));
            log.setFlowdocId(flowdoc.getId());
            log.setStarting(_context.isStarting());
            User postUser = _context.getPostUser();
            if (postUser != null) {
                log.setPostUser(postUser.getName());
            }
            log.setObjId(doc.getId());
            log.setObjType(605);
            log.setChannelId(doc.getChannelId());
            Groups userGroups = null;
            Group userGroup = null;
            if (postUser != null && !(userGroups = postUser.getGroups()).isEmpty() && (userGroup = (Group)userGroups.getAt(0)) != null) {
                log.setUserGroupId(userGroup.getId());
            }
            log.save(ContextHelper.getLoginUser());
        }
        catch (Throwable ex) {
            logger.warn((Object)(I18NMessage.get(FlowingDocLogger.class, "FlowingDocLogger.label1", "\u8bb0\u5f55\u5de5\u4f5c\u6d41\u8f6c\u7684\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\uff01") + ex.getMessage()));
        }
    }

    private static void logApplyForm(FlowContext _context, String _sActionDesc, IFlowContent content, FlowDoc flowdoc) {
        try {
            String sFieldValue = _sActionDesc;
            FlowNodeBranch branch = _context.getBranch();
            if (sFieldValue == null && branch != null && branch.isOperationMarkEnable()) {
                sFieldValue = branch.getOperationMark();
            }
            FlowdocLog log = new FlowdocLog();
            if (!CMyString.isEmpty(sFieldValue)) {
                log.setActionDesc(sFieldValue);
            }
            if (branch != null) {
                log.setBranchId(branch.getId());
            }
            log.setActionFlag(FlowingDocLogger.getActionFlag(_sActionDesc));
            log.setFlowdocId(flowdoc.getId());
            log.setStarting(_context.isStarting());
            User postUser = _context.getPostUser();
            if (postUser != null) {
                log.setPostUser(postUser.getName());
            }
            log.setObjId(content.getId());
            log.setObjType(content.getType());
            log.setChannelId(0);
            Groups userGroups = null;
            Group userGroup = null;
            if (postUser != null && !(userGroups = postUser.getGroups()).isEmpty() && (userGroup = (Group)userGroups.getAt(0)) != null) {
                log.setUserGroupId(userGroup.getId());
            }
            log.save(ContextHelper.getLoginUser());
        }
        catch (Throwable ex) {
            logger.warn((Object)(I18NMessage.get(FlowingDocLogger.class, "FlowingDocLogger.label1", "\u8bb0\u5f55\u5de5\u4f5c\u6d41\u8f6c\u7684\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\uff01") + ex.getMessage()));
        }
    }

    private static int getActionFlag(String actionDesc) {
        if (CMyString.isEmpty(actionDesc)) {
            return 0;
        }
        return 1;
    }
}

