/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.RightHostFactory;
import com.trs.cms.auth.domain.RightSet;
import com.trs.cms.auth.persistent.ObjectMember;
import com.trs.cms.auth.persistent.ObjectMembers;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.support.config.ConfigServer;
import org.apache.log4j.Logger;

public class RightHostLCListenerForInherit
implements IObjectLCListenerOnAdd {
    private static Logger logger = Logger.getLogger(RightHostLCListenerForInherit.class);

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        String sConfigValue = ConfigServer.getServer().getSysConfigValue("INHERIT_PARENT_RIGHT", "true");
        if (!sConfigValue.equalsIgnoreCase("true")) {
            return;
        }
        if (!(_oObjAdded instanceof CMSObj)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(RightHostLCListenerForInherit.class, "RightHostLCListenerForInherit.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjAdded.getClass() + I18NMessage.get(RightHostLCListenerForInherit.class, "RightHostLCListenerForInherit.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        IRightHost rightHost = RightHostFactory.makeRightHostFrom((CMSObj)_oObjAdded);
        if (rightHost == null) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(RightHostLCListenerForInherit.class, "RightHostLCListenerForInherit.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjAdded.getClass() + I18NMessage.get(RightHostLCListenerForInherit.class, "RightHostLCListenerForInherit.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        User loginUser = null;
        try {
            loginUser = ContextHelper.getLoginUser();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RightSet rightSet = new RightSet();
        rightSet.inheritRights(loginUser, rightHost, false);
        if (_oObjAdded instanceof Channel) {
            this.inheritObjectMembers((Channel)_oObjAdded);
        }
    }

    public void inheritObjectMembers(Channel _oChannel) throws WCMException {
        int nObjId = _oChannel.getId();
        int nObjType = 101;
        User loginUser = null;
        try {
            loginUser = ContextHelper.getLoginUser();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BaseChannel host = _oChannel.getHost();
        WCMFilter filter = new WCMFilter("", "ObjType=? and ObjId=?", "");
        filter.addSearchValues(host.getWCMType());
        filter.addSearchValues(host.getId());
        ObjectMembers objectMembers = ObjectMembers.openWCMObjs(loginUser, filter);
        if (objectMembers.isEmpty()) {
            return;
        }
        IObjectMemberMgr oObjMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
        for (int i = 0; i < objectMembers.size(); ++i) {
            ObjectMember oObjectMember = (ObjectMember)objectMembers.getAt(i);
            if (oObjectMember == null) continue;
            int nMemberType = oObjectMember.getMemberType();
            int nMemberId = oObjectMember.getMemberId();
            if (!oObjectMember.isDoOperation()) continue;
            ObjectMember newObjectMember = oObjMemberMgr.getObjectMember(nMemberType, nMemberId, nObjType, nObjId);
            if (newObjectMember != null) {
                newObjectMember.setVisible(oObjectMember.isVisible());
                newObjectMember.setDoOperation(oObjectMember.isDoOperation());
                newObjectMember.save(loginUser);
                continue;
            }
            newObjectMember = (ObjectMember)oObjectMember.cloneToNewObj();
            newObjectMember.setObjType(nObjType);
            newObjectMember.setObjId(nObjId);
            newObjectMember.insert(loginUser);
        }
    }
}

