/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;

public class DepartmentMgrImpl
implements IDepartmentMgr {
    private Group m_oRootGroup = null;

    @Override
    public Groups getDeptGroups(User _user) throws WCMException {
        Groups groups = _user.getGroups();
        Groups deptGroups = new Groups(null, groups.size(), 1);
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null || !this.isDeptGroup(group)) continue;
            deptGroups.addElement(group);
        }
        return deptGroups;
    }

    @Override
    public String getDepartmentInfo(User _user) throws WCMException {
        return this.getDepartmentInfo(_user, null);
    }

    @Override
    public String getDepartmentInfo(User _user, String _sDelimit) throws WCMException {
        if (_user == null) {
            throw new WCMException(I18NMessage.get(DepartmentMgrImpl.class, "DepartmentMgrImpl.label1", "\u6ca1\u6709\u6307\u5b9a\u7528\u6237"));
        }
        String sDelimit = CMyString.showNull(_sDelimit, "~");
        Groups deptGroups = this.getDeptGroups(_user);
        if (deptGroups.isEmpty()) {
            return "";
        }
        StringBuffer sbResult = new StringBuffer((20 + sDelimit.length()) * 10);
        for (Group parentGroup = (Group)deptGroups.getAt(0); parentGroup != null && !parentGroup.equals(this.m_oRootGroup.getId()); parentGroup = parentGroup.getParent()) {
            sbResult.insert(0, sDelimit);
            sbResult.insert(0, parentGroup.getName());
        }
        return sbResult.toString();
    }

    @Override
    public Group getRootDepartmentGroup() throws WCMException {
        if (this.m_oRootGroup == null) {
            this.initRootDepartmentGroup();
        }
        return this.m_oRootGroup;
    }

    private synchronized void initRootDepartmentGroup() throws WCMException {
        if (this.m_oRootGroup != null) {
            return;
        }
        String sRootGroupName = ConfigServer.getServer().getSysConfigValue("GROUP_NAME_DEPARTMENT", I18NMessage.get(DepartmentMgrImpl.class, "DepartmentMgrImpl.label2", "\u7ec4\u7ec7\u673a\u6784"));
        WCMFilter filter = new WCMFilter("", "ParentId=0 and GName=?", "");
        filter.addSearchValues(sRootGroupName);
        Groups groups = Groups.openWCMObjs(null, filter);
        if (groups.isEmpty()) {
            Group newGroup = Group.createNewInstance();
            newGroup.setParent(0);
            newGroup.setName(sRootGroupName);
            newGroup.setDesc(sRootGroupName);
            newGroup.setCrUser(User.getSystem());
            newGroup.save(User.getSystem());
            this.m_oRootGroup = newGroup;
        } else {
            this.m_oRootGroup = (Group)groups.getAt(0);
        }
        if (this.m_oRootGroup == null) {
            throw new WCMException(I18NMessage.get(DepartmentMgrImpl.class, "DepartmentMgrImpl.label3", "\u7cfb\u7edfCache\u6709\u95ee\u9898\uff0c\u6307\u5b9a\u7684\u7ec4\u7ec7[Name=") + sRootGroupName + I18NMessage.get(DepartmentMgrImpl.class, "DepartmentMgrImpl.label4", "]\u4e0d\u5b58\u5728\uff01"));
        }
    }

    @Override
    public void reload() throws WCMException {
        this.m_oRootGroup = null;
        this.initRootDepartmentGroup();
    }

    private boolean isDeptGroup(Group _group) throws WCMException {
        if (_group == null) {
            return false;
        }
        int nParentId = _group.getParentId();
        if (nParentId == 0) {
            return false;
        }
        int nRootGroupId = this.getRootDepartmentGroup().getId();
        if (nParentId == nRootGroupId) {
            return true;
        }
        return this.isDeptGroup(Group.findById(nParentId));
    }

    @Override
    public boolean isDepartmentAdmin(User _user) throws WCMException {
        if (_user == null) {
            throw new WCMException(I18NMessage.get(DepartmentMgrImpl.class, "DepartmentMgrImpl.label1", "\u6ca1\u6709\u6307\u5b9a\u7528\u6237"));
        }
        Groups deptGroups = this.getDeptGroups(_user);
        if (deptGroups.isEmpty()) {
            return false;
        }
        Group parentGroup = (Group)deptGroups.getAt(0);
        return parentGroup.isAdministrator(_user);
    }

    @Override
    public Groups getDeptGroupTree(User _user) throws WCMException {
        Groups deptGroups = this.getDeptGroups(_user);
        if (deptGroups.isEmpty()) {
            return new Groups(null);
        }
        Group rootDeptGroup = this.getRootDepartmentGroup();
        Groups deptGroupTree = new Groups(null);
        Group deptGroup = (Group)deptGroups.getAt(0);
        deptGroupTree.addElement(deptGroup);
        Group parent = Group.findById(deptGroup.getParentId());
        while (parent != null && !parent.equals(rootDeptGroup)) {
            deptGroupTree.addElement(parent);
            parent = Group.findById(parent.getParentId());
        }
        return deptGroupTree;
    }
}

