/*
 * Decompiled with CFR 0.152.
 */
package com.trs.bigfile;

import com.trs.bigfile.Result;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FileUploader {
    private static final String KEY_MAXPARTSIZE = "FILEUPLOAER_MAX_PARTSIZE";
    private static final Logger LOG = Logger.getLogger(FileUploader.class);
    private static final int BUFFER_SIZE = 10240;
    private static final Set ALLOW_UPLOAD_FILES = new HashSet(32);
    private static final int ONE_MEGBYTE = 0x100000;
    private static FileStore BF_DIR;
    private int m_nTotalPartCount;
    private int m_nCurrentPart;
    private int m_nCurrentPartSize;
    private String m_sFileInfo;

    FileUploader() {
        this.initIfNeed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNeed() {
        if (!ALLOW_UPLOAD_FILES.isEmpty()) {
            return;
        }
        Set set = ALLOW_UPLOAD_FILES;
        synchronized (set) {
            ConfigServer server = ConfigServer.getServer();
            String suffix = server.getInitProperty("FILE_UPLOAD_ALLOW_SUFFIX");
            if (suffix == null) {
                LOG.warn((Object)"No config: FILE_UPLOAD_ALLOW_SUFFIX");
                suffix = "";
            }
            suffix = suffix.toLowerCase();
            ALLOW_UPLOAD_FILES.addAll(Arrays.asList(suffix.split(",")));
            String dir = server.getInitProperty("BF");
            if (dir == null) {
                dir = "";
                LOG.fatal((Object)"Error, the bigfiles dir did not config properly.");
            }
            BF_DIR = new FileService(dir);
        }
    }

    public Result readFileData(InputStream ins) throws IOException {
        boolean zOK = this.readHead(ins);
        if (!zOK) {
            return Result.HEADER_ERROR;
        }
        zOK = this.allowUploadFile();
        if (!zOK) {
            return Result.FORBIDDEN_ERROR;
        }
        zOK = this.readData(ins);
        if (!zOK) {
            return Result.DATA_ERROR;
        }
        return new Result(1, "s-" + FileUploader.makeFileName(this.m_sFileInfo));
    }

    public static String makeFileName(String fileInfo) {
        return "bf" + fileInfo.hashCode() + "." + CMyFile.extractFileExt(fileInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readData(InputStream ins) {
        RandomAccessFile raf = null;
        try {
            long nMaxPartSize = FileUploader.getMaxPartSize();
            FileService file2Save = new FileService(BF_DIR, FileUploader.makeFileName(this.m_sFileInfo));
            raf = new RandomAccessFile(new FileWrapper(file2Save), "rw");
            raf.seek((long)(this.m_nCurrentPart - 1) * nMaxPartSize);
            long startPointer = raf.getFilePointer();
            byte[] buffer = new byte[10240];
            int iCount = ins.read(buffer);
            while (iCount != -1) {
                raf.write(buffer, 0, iCount);
                iCount = ins.read(buffer);
            }
            long endPointer = raf.getFilePointer();
            boolean bl = (long)this.m_nCurrentPartSize == endPointer - startPointer;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)("Read upload file data failed.[FileInfo: " + this.m_sFileInfo + ", " + this.m_nCurrentPart + "]"), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception exception) {}
            }
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static int getMaxPartSize() {
        ConfigServer server = ConfigServer.getServer();
        int nMaxPartSize = 0x100000;
        try {
            String maxPartSize = server.getSysConfigValue(KEY_MAXPARTSIZE, "0");
            nMaxPartSize = Integer.parseInt(maxPartSize);
            if (nMaxPartSize <= 0) {
                nMaxPartSize = 0x100000;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nMaxPartSize;
    }

    private boolean readHead(InputStream ins) {
        byte[] headInfo = new byte[268];
        try {
            ins.read(headInfo);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Read upload headinfo faield.", (Throwable)ioe);
            return false;
        }
        this.m_nCurrentPart = FileUploader.byte2Int(headInfo, 0, 4);
        this.m_nTotalPartCount = FileUploader.byte2Int(headInfo, 4, 8);
        this.m_nCurrentPartSize = FileUploader.byte2Int(headInfo, 8, 12);
        try {
            this.m_sFileInfo = new String(headInfo, 12, 256, "GBK");
            this.m_sFileInfo = this.m_sFileInfo.trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("file upload: " + this.m_sFileInfo + ", part: " + this.m_nCurrentPart + ", total: " + this.m_nTotalPartCount));
        }
        return true;
    }

    private boolean allowUploadFile() {
        String fileext = CMyFile.extractFileExt(this.m_sFileInfo);
        fileext = fileext.toLowerCase();
        return ALLOW_UPLOAD_FILES.contains(fileext);
    }

    private static int byte2Int(byte[] data, int begin, int end) {
        if (begin < 0 || begin > end || end > data.length) {
            StringBuffer buff = new StringBuffer(128);
            buff.append("Index [");
            buff.append(begin);
            buff.append(", ");
            buff.append(end);
            buff.append("] out of bounds [0, ");
            buff.append(data.length);
            buff.append(']');
            throw new IndexOutOfBoundsException(buff.toString());
        }
        int result = 0;
        for (int i = begin; i < end; ++i) {
            int tmpVal = data[i] << 8 * (3 - i);
            switch (i % 4) {
                case 0: {
                    tmpVal &= 0xFF000000;
                    break;
                }
                case 1: {
                    tmpVal &= 0xFF0000;
                    break;
                }
                case 2: {
                    tmpVal &= 0xFF00;
                    break;
                }
                case 3: {
                    tmpVal &= 0xFF;
                    break;
                }
            }
            result |= tmpVal;
        }
        return result;
    }

    public static void main(String[] args) {
    }
}

