/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.logger;

import com.trs.infra.persistent.BaseObj;
import com.trs.webframework.AbstractLogger;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.context.MethodContext;
import org.apache.log4j.Logger;

public class TemplateImportLogger
extends AbstractLogger {
    private static Logger logger = Logger.getLogger(TemplateImportLogger.class);

    @Override
    public int startLog(MethodConfig conf, MethodContext context) {
        int nHostId = context.getValue("HOSTID", 0);
        int nHostType = context.getValue("HOSTTYPE", 0);
        int nImportMode = context.getValue("ImportMode", 1);
        int nPicMode = context.getValue("PicMode", 1);
        try {
            BaseObj logobj = BaseObj.findById(nHostType, nHostId);
            if (logobj == null) {
                return 0;
            }
            StringBuffer buff = new StringBuffer(256);
            buff.append("\u5bfc\u5165\u6a21\u677f, \u540c\u540d\u6a21\u677f");
            switch (nImportMode) {
                case 3: {
                    buff.append("\u6539\u540d\u5904\u7406, ");
                    break;
                }
                case 1: {
                    buff.append("\u8986\u76d6\u5904\u7406, ");
                    break;
                }
                case 2: {
                    buff.append("\u5ffd\u7565\u5904\u7406, ");
                    break;
                }
            }
            buff.append("\u540c\u540d\u9644\u4ef6");
            switch (nPicMode) {
                case 1: {
                    buff.append("\u8986\u76d6\u5904\u7406");
                    break;
                }
                case 3: {
                    buff.append("\u6539\u540d\u5904\u7406");
                    break;
                }
                case 2: {
                    buff.append("\u5ffd\u7565\u5904\u7406");
                    break;
                }
            }
            return this.log(conf, buff.toString(), logobj);
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to recode a template import log", (Throwable)ex);
            return 0;
        }
    }

    @Override
    public String getClassDesc() {
        return "\u6a21\u677f\u5bfc\u5165";
    }
}

