/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.PageOperatorsForServiceHelper;
import com.trs.ajaxservice.ServiceConstants;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.tagparser.TemplateParameter;
import com.trs.components.common.publish.domain.tagparser.TemplateParameterList;
import com.trs.components.common.publish.domain.template.TemplateArgumentMgr;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateExporter;
import com.trs.components.common.publish.domain.template.TemplateImporter;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.domain.template.TemplateNestMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateArgument;
import com.trs.components.common.publish.persistent.template.TemplateArguments;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.components.common.publish.persistent.template.TemplateEmploys;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.service.ITemplateService;
import com.trs.wcag2.WCAG2Helper;
import com.trs.wcm.config.PageOperators;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class TemplateServiceProvider
implements IGlueServiceProvider {
    private static Logger s_logger = Logger.getLogger(TemplateServiceProvider.class);
    private TemplateMgr m_oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
    private TemplateEmployMgr m_oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
    private TemplateNestMgr m_oNestMgr = (TemplateNestMgr)DreamFactory.createObjectById("TemplateNestMgr");
    private TemplateArgumentMgr m_oArgumentMgr = (TemplateArgumentMgr)DreamFactory.createObjectById("TemplateArgumentMgr");
    private ITemplateService m_oTemplateService = (ITemplateService)DreamFactory.createObjectById("ITemplateService");

    public boolean existsSimilarName(MethodContext _methodContext) throws Throwable {
        WCMFilter existFilter = new WCMFilter("WCMTEMPLATE", "RootId=? and TempName=? and TempId<>?", "", "TempId");
        existFilter.addSearchValues(0, _methodContext.getValue("SiteId", 0));
        existFilter.addSearchValues(1, _methodContext.getValue("TempName"));
        existFilter.addSearchValues(2, _methodContext.getObjectId());
        return DBManager.getDBManager().sqlExecuteIntQuery(existFilter) > 0;
    }

    @Override
    public void delete(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Templates templates = Templates.findByIds(loginUser, _methContext.getObjectIds());
        this.validateRight(loginUser, templates, 22, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label1", "\u5220\u9664\u6a21\u677f"));
        int nSize = templates.size();
        for (int i = 0; i < nSize; ++i) {
            Templates currTemplates;
            Template template = (Template)templates.getAt(i);
            if (template == null || (currTemplates = this.m_oNestMgr.getTemplatesNested(template)).size() > 0) continue;
            this.m_oTemplateMgr.delete(template);
        }
    }

    @Override
    public Object query(MethodContext _methContext) throws Throwable {
        WCMFilter tempFilter;
        User loginUser = this.getLoginUser();
        IPublishFolder folder = this.findPublishFolder(_methContext);
        boolean bContainsChildren = _methContext.getValue("ContainsChildren", false);
        this.validateRight(loginUser, folder, 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label2", "\u67e5\u770b") + folder.getInfo() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label3", "\u6a21\u677f\u5217\u8868"));
        WCMFilter filter = new WCMFilter(_methContext.getQueryFilter());
        int nFilterType = _methContext.getValue("FilterType", 0);
        if (nFilterType != 0 && (tempFilter = this.makeFilterByType(loginUser, nFilterType)) != null && tempFilter.getWhere() != null && tempFilter.getWhere().length() > 0) {
            filter.mergeWith(tempFilter);
        }
        return this.m_oTemplateMgr.getManagedTemplates(folder, -1, filter, bContainsChildren);
    }

    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        IPublishFolder folder = null;
        int nTemplateId = _methodContext.getObjectId();
        Template currTemplate = null;
        if (nTemplateId > 0) {
            currTemplate = Template.findById(nTemplateId);
            if (currTemplate == null) {
                throw new WCMException(102100, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label4", "\u6307\u5b9a\u7684\u6a21\u677f\u4e0d\u5b58\u5728"));
            }
            folder = currTemplate.getFolder();
        } else {
            folder = this.findPublishFolder(_methodContext);
            currTemplate = new Template();
            currTemplate.setFolder(folder);
        }
        if (folder == null) {
            throw new WCMException(102101, currTemplate.isAddMode() ? I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label5", "\u6307\u5b9a\u7684Host[") + _methodContext.getValue("HostType") + "." + _methodContext.getValue("HostId") + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label6", "]\u4e0d\u5b58\u5728\uff01") : I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label7", "\u6a21\u677f[Id=") + nTemplateId + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label8", "]\u6240\u5c5e\u7684Host[") + currTemplate.getFolderType() + "." + currTemplate.getFolderId() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label6", "]\u4e0d\u5b58\u5728\uff01"));
        }
        if (nTemplateId > 0) {
            this.validateRight(loginUser, currTemplate, 23, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label9", "\u4fee\u6539\u6a21\u677f"));
        } else {
            this.validateRight(loginUser, folder, 21, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label10", "\u65b0\u589e\u6a21\u677f"));
        }
        String[] pLogicFields = new String[]{"ObjectId", "HostType", "HostId"};
        currTemplate = (Template)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, currTemplate, pLogicFields);
        if (!currTemplate.isAddMode()) {
            currTemplate.validCanEditAndLock(loginUser);
        }
        currTemplate = this.m_oTemplateMgr.save(currTemplate, null, true, 2);
        return currTemplate.getId();
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        IPublishFolder folder = null;
        int nTemplateId = _methodContext.getObjectId();
        Template currTemplate = null;
        if (nTemplateId > 0) {
            currTemplate = Template.findById(nTemplateId);
            if (currTemplate == null) {
                throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nTemplateId), WCMTypes.getLowerObjName(102)}));
            }
            folder = currTemplate.getFolder();
        } else {
            folder = this.findPublishFolder(_methodContext);
            currTemplate = new Template();
            currTemplate.setFolder(folder);
        }
        if (folder == null) {
            throw new WCMException(102101, currTemplate.isAddMode() ? I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label5", "\u6307\u5b9a\u7684Host[") + _methodContext.getValue("HostType") + "." + _methodContext.getValue("HostId") + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label6", "]\u4e0d\u5b58\u5728\uff01") : I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label7", "\u6a21\u677f[Id=") + nTemplateId + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label8", "]\u6240\u5c5e\u7684Host[") + currTemplate.getFolderType() + "." + currTemplate.getFolderId() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label6", "]\u4e0d\u5b58\u5728\uff01"));
        }
        if (!loginUser.getName().equalsIgnoreCase(currTemplate.getCrUserName())) {
            this.validateRight(loginUser, folder, 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label11", "\u83b7\u53d6\u5355\u4e2a\u6a21\u677f\u4fe1\u606f"));
        }
        if (CMyString.isEmpty(currTemplate.getPropertyAsString("OUTPUTFILENAME"))) {
            currTemplate.getProperties().put("OUTPUTFILENAME", "index");
        }
        if (CMyString.isEmpty(currTemplate.getPropertyAsString("TEMPEXT"))) {
            currTemplate.getProperties().put("TEMPEXT", "html");
        }
        return currTemplate;
    }

    @Override
    public Object findByIds(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Templates templates = Templates.findByIds(loginUser, _methContext.getObjectIds());
        this.validateRight(loginUser, templates, 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label11", "\u83b7\u53d6\u5355\u4e2a\u6a21\u677f\u4fe1\u606f"));
        return templates;
    }

    public Templates getOptionalTemplates(MethodContext _MethodContext2) throws Throwable {
        User loginUser = this.getLoginUser();
        if (_MethodContext2.getObjectId() == 0) {
            return new Templates(loginUser);
        }
        int nTemplateType = _MethodContext2.getValue("TemplateType", -1);
        IPublishFolder publishElement = this.findPublishFolder(_MethodContext2, "Object");
        IPublishFolder folder = null;
        folder = publishElement.isFolder() ? publishElement : publishElement.getFolder();
        int objType = _MethodContext2.getValue("objectType", 101);
        switch (objType) {
            case 101: {
                int[] rightIndexsChannel = new int[]{13, 11, 32, 31, 24};
                this.validateRight(loginUser, folder, rightIndexsChannel, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label12", "\u9009\u62e9\u6a21\u677f"));
                break;
            }
            case 103: {
                int[] rightIndexsWebsite = new int[]{1, 11, 24};
                this.validateRight(loginUser, folder, rightIndexsWebsite, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label12", "\u9009\u62e9\u6a21\u677f"));
                break;
            }
            case 605: {
                this.validateRight(loginUser, folder, 32, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label12", "\u9009\u62e9\u6a21\u677f"));
            }
        }
        WCMFilter filter = new WCMFilter(_MethodContext2.getQueryFilter());
        return this.m_oTemplateMgr.getOptionalTemplates(folder, nTemplateType, filter, true);
    }

    public PageOperators getOperators(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        IPublishFolder host = (IPublishFolder)this.findById(_methContext);
        int nObjectId = _methContext.getObjectId();
        if (nObjectId > 0) {
            Template template = this.findTemplateById(nObjectId);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "template", template);
        }
        String sObjectIds = _methContext.getObjectIds();
        if (sObjectIds != null && sObjectIds.length() > 0) {
            Templates templates = Templates.findByIds(loginUser, sObjectIds);
            if (templates.isEmpty()) {
                throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label13", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f[ObjectIds=") + sObjectIds + "]\uff01");
            }
            if (templates.size() == 1) {
                return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "template", (CMSObj)templates.getAt(0));
            }
            return PageOperatorsForServiceHelper.makeCMSBaseObjsOpertators(loginUser, "templates", templates);
        }
        return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "templateHost", host.getSubstance());
    }

    public void impartTemplateConfig(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        IPublishFolder publishElement = this.findPublishFolder(_methodContext, "Object");
        CMSObj currObject = publishElement.getSubstance();
        if (currObject instanceof WebSite && ((WebSite)currObject).getStatus() < 0) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(currObject.getId()), WCMTypes.getLowerObjName(103)}));
        }
        if (currObject instanceof Channel && ((Channel)currObject).getStatus() < 0) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(currObject.getId()), WCMTypes.getLowerObjName(101)}));
        }
        if (!publishElement.isFolder()) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label14", "\u6307\u5b9a\u7684\u5bf9\u8c61[Type=") + _methodContext.getValue("ObjectType") + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label15", "]\u4e0d\u662fFolder\uff01"));
        }
        if (!AuthServer.hasRight(loginUser, publishElement.getSubstance(), this.getSetTemplateRightIndex(publishElement.getType()))) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label16", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label17", "]\u6ca1\u6709\u6743\u9650\u5728[") + publishElement.getInfo() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label18", "]\u91cd\u65b0\u8bbe\u7f6e\u5b50\u5bf9\u8c61\u7684\u6a21\u677f\uff01"));
        }
        this.m_oEmployMgr.resetChildern(publishElement);
    }

    public void synTemplates(MethodContext _methodContext) throws Throwable {
        IPublishFolder publishElement = this.findPublishFolder(_methodContext, "Object");
        if (!publishElement.isFolder()) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label14", "\u6307\u5b9a\u7684\u5bf9\u8c61[Type=") + _methodContext.getValue("ObjectType") + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label15", "]\u4e0d\u662fFolder\uff01"));
        }
        IPublishFolder folder = publishElement;
        String outlineTempIds = "0";
        Templates outlineTempes = this.m_oEmployMgr.getOutlineTemplates(publishElement);
        if (!outlineTempes.isEmpty()) {
            outlineTempIds = outlineTempes.getIdListAsString();
        }
        if (this.m_oEmployMgr.getDefaultOutlineTemplate(folder) == null && !outlineTempIds.equals("0")) {
            outlineTempIds = "0," + outlineTempIds;
        }
        int nDetailTempId = 0;
        Template detailTemplate = this.m_oEmployMgr.getDetailTemplate(publishElement);
        if (detailTemplate != null) {
            nDetailTempId = detailTemplate.getId();
        }
        User loginUser = this.getLoginUser();
        String sObjectIds = _methodContext.getObjectIds();
        Channels channels = Channels.findByIds(loginUser, sObjectIds);
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            folder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
            this.m_oEmployMgr.setOutlineTemplates(folder, outlineTempIds, false);
            this.m_oEmployMgr.setDetailTemplate(folder, nDetailTempId, false);
        }
    }

    public TemplateEmploys queryEmployers(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Template template = this.findTemplateById(_methodContext.getObjectId());
        this.validateRight(loginUser, template.getFolder(), 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label19", "\u67e5\u770b\u6a21\u677f\u4f7f\u7528\u60c5\u51b5\uff01"));
        WCMFilter filter = new WCMFilter(_methodContext.getQueryFilter());
        TemplateEmploys employs = this.m_oEmployMgr.getTemplateEmployers(template, filter);
        for (int i = employs.size() - 1; i >= 0; --i) {
            TemplateEmploy employ = (TemplateEmploy)employs.getAt(i);
            if (employ == null) {
                employs.removeAt(i, false);
                continue;
            }
            IPublishElement employer = employ.getEmployer();
            if (employer == null) {
                employs.removeAt(i, false);
                continue;
            }
            if (!employer.isFolder() || !((IPublishFolder)employer).isDeleted()) continue;
            employs.removeAt(i, false);
        }
        return employs;
    }

    public void publishEmployer(MethodContext _methodContext) throws WCMException {
        User loginUser = this.getLoginUser();
        TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
        Templates templates = Templates.findByIds(this.getLoginUser(), _methodContext.getObjectIds());
        for (int i = 0; i < templates.size(); ++i) {
            Template template = (Template)templates.getAt(i);
            if (template == null) continue;
            try {
                this.validateRight(loginUser, template, WCMRightTypes.TEMPLATE_PUBLISH, "\u53d1\u5e03\u6a21\u677f");
            }
            catch (WCMException e) {
                s_logger.error((Object)("\u7528\u6237" + loginUser + "\u6ca1\u6709\u6743\u9650\u53d1\u5e03\u6a21\u677f" + template.getName()), (Throwable)e);
                continue;
            }
            List employers = templateEmployMgr.getEmployers(template, null);
            this.publishHost(employers, template.getType());
        }
    }

    private void publishHost(List _employer, int nTemplateType) throws WCMException {
        PublishServer oPublishServer = PublishServer.getInstance();
        for (int k = 0; k < _employer.size(); ++k) {
            int nRightIndex;
            IPublishElement content = (IPublishElement)_employer.get(k);
            if (content == null) continue;
            int type = content.getType();
            int n = nRightIndex = type == 103 ? 5 : 17;
            if (!AuthServer.hasRight(ContextHelper.getLoginUser(), content.getSubstance(), nRightIndex)) {
                s_logger.error((Object)("\u7528\u6237" + ContextHelper.getLoginUser() + "\u6ca1\u6709\u6743\u9650\u53d1\u5e03\uff1a" + content.getSubstance()));
                continue;
            }
            IPublishFolder folder = content.getFolder();
            if (!folder.canDoOutlinePageTask()) continue;
            if (nTemplateType == 1) {
                oPublishServer.publishFolder((IPublishFolder)content, 8);
                continue;
            }
            if (nTemplateType != 2) continue;
            oPublishServer.publishFolder((IPublishFolder)content, 13);
        }
    }

    public Templates queryTemplatesNested(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Template template = this.findTemplateById(_methodContext.getObjectId());
        this.validateRight(loginUser, template, 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label19", "\u67e5\u770b\u6a21\u677f\u4f7f\u7528\u60c5\u51b5\uff01"));
        return this.m_oNestMgr.getTemplatesNested(template);
    }

    public Templates queryNestedTemplates(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Template template = this.findTemplateById(_methodContext.getObjectId());
        this.validateRight(loginUser, template, 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label19", "\u67e5\u770b\u6a21\u677f\u4f7f\u7528\u60c5\u51b5\uff01"));
        return this.m_oNestMgr.getNestedTemplates(template);
    }

    public String export(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        IPublishFolder publishElement = this.findPublishFolder(_methodContext);
        boolean bExportAll = _methodContext.getValue("ExportAll", false);
        Templates templates = null;
        templates = bExportAll ? (Templates)this.query(_methodContext) : Templates.findByIds(loginUser, _methodContext.getObjectIds());
        this.validateRight(loginUser, publishElement, 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label20", "\u5bfc\u51fa\u6a21\u677f"));
        TemplateExporter exporter = new TemplateExporter();
        _methodContext.setContentTypeIsHTML();
        return exporter.export(templates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importTemplates(MethodContext _methodContext) throws Throwable {
        String sFileEncode;
        User loginUser = this.getLoginUser();
        IPublishFolder publishFolder = this.findPublishFolder(_methodContext);
        String sImportFile = _methodContext.getValue("ImportFile");
        int nImportMode = _methodContext.getValue("ImportMode", 1);
        int nPicMode = _methodContext.getValue("PicMode", 1);
        if (!AuthServer.hasRight(loginUser, publishFolder.getSubstance(), 21)) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label16", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + CMyString.format(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label42", "]\u6ca1\u6709\u6743\u9650\u6267\u884c {0} !"), new String[]{I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label21", "\u5bfc\u5165\u6a21\u677f")}));
        }
        Templates oTemplatesWithNoRight = null;
        if (nImportMode == 1) {
            oTemplatesWithNoRight = this.getTemplatesWithNoRight(publishFolder, sImportFile);
        }
        if (!CMyString.isEmpty(sFileEncode = _methodContext.getValue("FileEncode"))) {
            ContextParameters.set(9, sFileEncode);
        }
        try {
            TemplateImporter importer = new TemplateImporter();
            String sFileExt = CMyFile.extractFileExt(sImportFile);
            if (sFileExt.equalsIgnoreCase("zip")) {
                String string = importer.importFromZip(publishFolder, sImportFile, nImportMode, nPicMode, null, oTemplatesWithNoRight).toJSONXML();
                return string;
            }
            String sSrcHtmlFileName = _methodContext.getValue("SrcFileName");
            String string = importer.importFromHTML(publishFolder, sImportFile, nImportMode, sSrcHtmlFileName).toJSONXML();
            return string;
        }
        finally {
            if (!CMyString.isEmpty(sFileEncode)) {
                ContextParameters.get(9);
            }
        }
    }

    private Templates getTemplatesWithNoRight(IPublishFolder publishFolder, String sImportFile) throws Throwable {
        User loginUser = this.getLoginUser();
        int nFolderId = publishFolder.getId();
        int nFolderType = publishFolder.getType();
        TemplateImporter importer = new TemplateImporter();
        String[] pTempNames = null;
        pTempNames = !CMyFile.extractFileExt(sImportFile).equalsIgnoreCase("zip") ? new String[]{CMyFile.extractMainFileName(sImportFile)} : importer.extractTemplateNamesFromZip(sImportFile);
        IPublishFolder siteFolder = publishFolder.getRoot();
        Templates oManagerdTemplates = this.m_oTemplateMgr.getManagedTemplates(siteFolder, -1, null, true);
        Templates oTemplatesWithNoRight = new Templates(loginUser);
        for (int i = 0; i < pTempNames.length; ++i) {
            String sTempName = pTempNames[i];
            Template oCurrTemplate = oManagerdTemplates.findByName(sTempName);
            if (oCurrTemplate == null) continue;
            int nCurrFolderId = oCurrTemplate.getFolderId();
            int nCurrFolderType = oCurrTemplate.getFolderType();
            if (nCurrFolderId < 0 || nCurrFolderId == nFolderId && nCurrFolderType == nFolderType || AuthServer.hasRight(loginUser, (CMSObj)((BaseChannel)BaseChannel.findById(nCurrFolderType, nCurrFolderId)), 21)) continue;
            oTemplatesWithNoRight.addElement(oCurrTemplate);
        }
        return oTemplatesWithNoRight;
    }

    public String check(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        IPublishFolder folder = this.findPublishFolder(_methodContext);
        Templates templates = null;
        templates = !_methodContext.getValue("CheckAll", false) ? Templates.findByIds(loginUser, _methodContext.getObjectIds()) : this.m_oTemplateMgr.getManagedTemplates(folder, -1, null, _methodContext.getValue("ContainsChildren", false));
        this.validateRight(loginUser, templates, 25, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label22", "\u6821\u9a8c\u6a21\u677f"));
        TemplateParseMgr oTemplateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
        Reports aReports = new Reports(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label23", "\u6a21\u677f\u6821\u9a8c"));
        int nTemplateCount = 0;
        int nSize = templates.size();
        for (int i = 0; i < nSize; ++i) {
            Template template = (Template)templates.getAt(i);
            if (template == null) continue;
            boolean bCanEdit = false;
            if (AuthServer.hasRight(loginUser, template.getFolder().getSubstance(), 23)) {
                bCanEdit = true;
            }
            ++nTemplateCount;
            aReports.addReport(oTemplateParseMgr.checkTemplate(template, bCanEdit));
        }
        if (nTemplateCount == 0) {
            aReports.addWarnedReport(I18NMessage.makeObjectNotFound(new String[]{_methodContext.getObjectIds().replaceAll(",", ", "), WCMTypes.getLowerObjName(102)}), null);
        } else {
            String sTitle = I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label25", "\u5171\u68c0\u67e5\u4e86[") + nTemplateCount + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label26", "]\u4e2a\u6a21\u677f\uff01\u6b63\u786e\uff1a[") + aReports.getSucessedReporter().size() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label27", "]\u4e2a\uff01\u9519\u8bef\uff1a[") + aReports.getFailedReporter().size() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label28", "]\u4e2a\uff01");
            aReports.setTitle(sTitle);
        }
        return aReports.toJSONXML();
    }

    public String checkTemplateText(MethodContext _methodContext) throws Throwable {
        String sTemplateText = _methodContext.getValue("TemplateText");
        String sTempName = _methodContext.getValue("TempName");
        String sId = _methodContext.getValue("TempId");
        if (CMyString.isEmpty(sTempName)) {
            throw new WCMException("The template name can not be null.");
        }
        Template template = (Template)this.findById(_methodContext);
        template.setText(sTemplateText);
        template.setName(sTempName);
        template.setAttribute("tempId", " [template-" + sId + "]");
        TemplateParseMgr oTemplateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
        return oTemplateParseMgr.checkTemplate(template).toJSONXML();
    }

    public String checkWCAG2TemplateText(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sTemplateText = _methodContext.getValue("TemplateText");
        if (sTemplateText == null) {
            int nTemplateId = _methodContext.getValue("TemplateId", 0);
            Template template = Template.findById(nTemplateId);
            this.validateRight(loginUser, template, 25, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label41", "\u65e0\u969c\u788d\u6821\u9a8c"));
            sTemplateText = template != null ? template.getText() : "";
        }
        List alertions = (List)WCAG2Helper.doValid(sTemplateText);
        return WCAG2Helper.toHTML(alertions);
    }

    public String redistributeAppendixes(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        IPublishFolder folder = this.findPublishFolder(_methodContext);
        Templates templates = null;
        templates = !_methodContext.getValue("RedistributeAll", false) ? Templates.findByIds(loginUser, _methodContext.getObjectIds()) : this.m_oTemplateMgr.getManagedTemplates(folder, -1, null, _methodContext.getValue("ContainsChildren", false));
        this.validateRight(loginUser, templates, 28, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label29", "\u540c\u6b65\u6a21\u677f\u9644\u4ef6"));
        return this.m_oTemplateMgr.redistributeAppendixes(templates).toJSONXML();
    }

    public String queryArgs(MethodContext _methodContext) throws Throwable {
        Template detail;
        User loginUser = this.getLoginUser();
        IPublishFolder folder = this.findPublishFolder(_methodContext);
        int nRightIndex = 53;
        this.validateRight(loginUser, folder, nRightIndex, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label30", "\u7ba1\u7406\u6a21\u677f\u53d8\u91cf"));
        TemplateArguments args = this.m_oArgumentMgr.getArguments(folder);
        Templates templates = new Templates(this.getLoginUser());
        Templates outlines = this.m_oEmployMgr.getOutlineTemplates(folder);
        if (outlines != null && !outlines.isEmpty()) {
            templates.addElements(outlines);
        }
        if ((detail = this.m_oEmployMgr.getDetailTemplate(folder)) != null) {
            templates.addElement(detail);
        }
        Element elRoot = DocumentHelper.createElement((String)"Templates");
        int nSize = templates.size();
        for (int i = 0; i < nSize; ++i) {
            Template template = (Template)templates.getAt(i);
            if (template == null) continue;
            this.makeTemplateArgments(template, elRoot, args, null, null);
            Iterator itIdentity = template.iterateNestedIdentity();
            while (itIdentity != null && itIdentity.hasNext()) {
                String sIdentity = (String)itIdentity.next();
                this.makeTemplateArgments(template.getNestedTemplate(folder, sIdentity), elRoot, args, template, sIdentity);
            }
        }
        return elRoot.asXML();
    }

    private void makeTemplateArgments(Template template, Element elRoot, TemplateArguments args, Template _parent, String sIdentity) {
        if (template == null) {
            return;
        }
        TemplateParameterList templateParameterList = template.getTemplateParameters();
        if (templateParameterList == null || templateParameterList.size() == 0) {
            return;
        }
        Element elTemplate = elRoot.addElement("Template");
        elTemplate.addAttribute("ID", String.valueOf(template.getId()));
        elTemplate.addAttribute("Name", template.getName());
        if (_parent != null) {
            elTemplate.addAttribute("Identity", sIdentity);
            elTemplate.addAttribute("NesterName", _parent.getName());
            elTemplate.addAttribute("NesterId", String.valueOf(_parent.getId()));
        }
        Element elArgs = elTemplate.addElement("Args");
        Iterator itParameters = templateParameterList.parameters();
        while (itParameters.hasNext()) {
            TemplateParameter parameter = (TemplateParameter)itParameters.next();
            Element elArg = elArgs.addElement("Arg");
            elArg.addElement("Name").addCDATA(parameter.getParameterName());
            elArg.addElement("Type").addCDATA(parameter.getParameterType().getName());
            elArg.addElement("DefaultValue").addCDATA(parameter.getParameterDefault());
            elArg.addElement("CanCustom").addText(String.valueOf(parameter.getCanCustom()));
            elArg.addElement("EnumSplit").addText(String.valueOf(parameter.getEnumSplit()));
            parameter.getEnumValue();
            Element elEnumValues = elArg.addElement("EnumValues");
            TemplateParameter.Token[] token = parameter.getEnumValue();
            int nEnValueCount = token == null ? 0 : token.length;
            for (int j = 0; j < nEnValueCount; ++j) {
                Element elEnumValue = elEnumValues.addElement("EnumValue");
                elEnumValue.addAttribute("Value", token[j].getValue());
                elEnumValue.addAttribute("Display", token[j].getDisplay());
            }
            elArg.addElement("PrexName").addCDATA(CMyString.showNull(sIdentity));
            String sValue = CMyString.showNull(args.getArgumentValue(parameter.getParameterName(), sIdentity));
            elArg.addElement("Value").addCDATA(sValue);
        }
    }

    public int saveArgument(MethodContext _methodContext) throws Throwable {
        IPublishFolder publishElement;
        CMSObj tempObj;
        User loginUser = this.getLoginUser();
        IPublishFolder folder = this.findPublishFolder(_methodContext);
        Template template = this.findTemplateById(_methodContext.getValue("TemplateId", 0));
        String sParamName = _methodContext.getValue("ParameterName");
        String sPrexName = _methodContext.getValue("PrexName");
        int nRightIndex = 53;
        this.validateRight(loginUser, folder, nRightIndex, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label31", "\u8bbe\u7f6e\u6a21\u677f\u53d8\u91cf"));
        TemplateArgument argument = this.findChannelTempArg(sParamName, sPrexName, folder);
        if (argument == null) {
            argument = new TemplateArgument();
            argument.setArgumentName(sParamName);
            argument.setEmployer(folder);
            argument.setTemplate(template);
            if (sPrexName != null && sPrexName.length() > 0) {
                argument.setPrefixOfName(sPrexName);
            }
        } else {
            argument.validCanEditAndLock(loginUser);
        }
        String sArgValue = _methodContext.getValue("ArgValue");
        argument.setArgumentValue(sArgValue);
        argument.save(loginUser);
        boolean bSyncSameName = _methodContext.getValue("SyncSameName", false);
        if (bSyncSameName && (tempObj = (publishElement = folder).getSubstance()) instanceof BaseChannel) {
            BaseChannel tempBaseChannel = (BaseChannel)tempObj;
            this.renderChildren(loginUser, tempBaseChannel, sParamName, sArgValue, false);
        }
        return argument.getId();
    }

    private TemplateArgument findChannelTempArg(String _sArgName, String _sPrexName, IPublishFolder _employer) throws WCMException {
        String sWhere = null;
        sWhere = CMyString.isEmpty(_sPrexName) ? "ARGUMENTNAME=? and PREFIXOFNAME is null" : "ARGUMENTNAME=? and PREFIXOFNAME=?";
        if (_employer != null) {
            sWhere = sWhere + " AND EMPLOYERID=? AND EMPLOYERTYPE=?";
        }
        WCMFilter filter = new WCMFilter("", sWhere, "");
        int nSearchValueIndex = 0;
        filter.addSearchValues(0, _sArgName);
        if (!CMyString.isEmpty(_sPrexName)) {
            filter.addSearchValues(1, _sPrexName);
            ++nSearchValueIndex;
        }
        if (_employer != null) {
            filter.addSearchValues(++nSearchValueIndex, _employer.getId());
            filter.addSearchValues(++nSearchValueIndex, _employer.getType());
        }
        filter.setMaxRowNumber(1);
        TemplateArguments templateArguments = TemplateArguments.openWCMObjs(null, filter);
        if (templateArguments.isEmpty()) {
            return null;
        }
        return (TemplateArgument)templateArguments.getAt(0);
    }

    public void cancelArgVal(MethodContext _context) throws Throwable {
        _context.setValue("ArgValue", "");
        String sParamNames = _context.getValue("ParameterNames");
        String[] arParamNames = sParamNames.split(",");
        for (int i = 0; i < arParamNames.length; ++i) {
            String sParamName = arParamNames[i];
            if (CMyString.isEmpty(sParamName)) continue;
            _context.setValue("ParameterName", sParamName);
            this.saveArgument(_context);
        }
    }

    public void setDefaultTemplate(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        IPublishElement publishElement = this.findPublishElement(_methodContext);
        if (!publishElement.isCanDoSave(loginUser) && !AuthServer.hasRight(loginUser, publishElement.getSubstance(), 9)) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label32", "\u60a8\u6ca1\u6709\u6743\u9650\u8bbe\u7f6e\uff1a") + publishElement.getInfo() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label33", "\u7684\u6a21\u677f\uff01"));
        }
        int nTemplateId = _methodContext.getValue("TemplateId", 0);
        int nTemplateType = _methodContext.getValue("TemplateType", 2);
        if (publishElement.isFolder()) {
            switch (nTemplateType) {
                case 2: {
                    this.m_oEmployMgr.setDetailTemplate(publishElement, nTemplateId, false);
                    break;
                }
                case 1: {
                    this.m_oEmployMgr.setDefaultOutline((IPublishFolder)publishElement, nTemplateId);
                    break;
                }
                case 3: {
                    WCMFolderPublishConfig config = new WCMFolderPublishConfig((IPublishFolder)publishElement);
                    config.setInfoviewPrintTemplateId(nTemplateId);
                    config.canEdit(loginUser);
                    config.save(loginUser);
                }
            }
        } else {
            this.m_oEmployMgr.setDetailTemplate(publishElement, nTemplateId, false);
        }
    }

    public void setOtherOutlineTemplates(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        IPublishFolder publishFolder = this.findPublishFolder(_methodContext, "Object");
        if (!publishFolder.isCanDoSave(loginUser)) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label32", "\u60a8\u6ca1\u6709\u6743\u9650\u8bbe\u7f6e\uff1a") + publishFolder.getInfo() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label33", "\u7684\u6a21\u677f\uff01"));
        }
        String sTemplateIds = _methodContext.getValue("TemplateIds");
        this.m_oEmployMgr.setOtherOutlines(loginUser, publishFolder, sTemplateIds);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private Template findTemplateById(int _nObjectId) throws WCMException {
        Template template = Template.findById(_nObjectId);
        if (template == null) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label34", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f[ID=") + _nObjectId + "]\uff01");
        }
        return template;
    }

    private int getSetTemplateRightIndex(int _nElementType) {
        switch (_nElementType) {
            case 605: {
                return 32;
            }
            case 101: {
                return 13;
            }
            case 103: {
                return 1;
            }
        }
        return 64;
    }

    private boolean hasRight(User _loginUser, IPublishFolder _folder, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (AuthServer.hasRight(_loginUser, _folder.getSubstance(), _nRightIndex)) {
            return true;
        }
        IPublishFolder parent = _folder.getParent();
        if (parent == null || parent == _folder) {
            return false;
        }
        return this.hasRight(_loginUser, parent, _nRightIndex, _sOperDesc);
    }

    private boolean hasRight(User _loginUser, IPublishFolder _folder, int[] _nRightIndexs, String _sOperDesc) throws WCMException {
        for (int i = 0; i < _nRightIndexs.length; ++i) {
            if (!this.hasRight(_loginUser, _folder, _nRightIndexs[i], _sOperDesc)) continue;
            return true;
        }
        return false;
    }

    private void validateRight(User _loginUser, IPublishFolder _folder, int[] _nRightIndexs, String _sOperDesc) throws WCMException {
        if (this.hasRight(_loginUser, _folder, _nRightIndexs, _sOperDesc)) {
            return;
        }
        throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label16", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + _loginUser.getName() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label35", "]\u6ca1\u6709\u6743\u9650\u6267\u884c") + _sOperDesc + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label40", "\uff01"));
    }

    private void validateRight(User _loginUser, IPublishFolder _folder, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (AuthServer.hasRight(_loginUser, _folder.getSubstance(), _nRightIndex)) {
            return;
        }
        IPublishFolder parent = _folder.getParent();
        if (parent == null || parent == _folder) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label16", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + _loginUser.getName() + CMyString.format(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label42", "]\u6ca1\u6709\u6743\u9650\u6267\u884c {0} !"), new String[]{_sOperDesc}));
        }
        this.validateRight(_loginUser, parent, _nRightIndex, _sOperDesc);
    }

    private void validateRight(User _loginUser, Template _template, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (_loginUser.getName().equalsIgnoreCase(_template.getCrUserName())) {
            return;
        }
        this.validateRight(_loginUser, _template.getFolder(), _nRightIndex, _sOperDesc);
    }

    private void validateRight(User _loginUser, Templates _templates, int _nRightIndex, String _sOperDesc) throws WCMException {
        int nSize = _templates.size();
        for (int i = 0; i < nSize; ++i) {
            Template template = (Template)_templates.getAt(i);
            if (template == null) continue;
            this.validateRight(_loginUser, template, _nRightIndex, _sOperDesc);
        }
    }

    private WCMFilter makeFilterByType(User _loginUser, int _nFilterType) throws Exception {
        WCMFilter filter = new WCMFilter();
        String sWhere = null;
        switch (_nFilterType) {
            case 10: 
            case 11: 
            case 12: {
                sWhere = "TempType=?";
                filter.addSearchValues(0, _nFilterType % 10);
                break;
            }
            case 18: {
                sWhere = "(exists( select WCMTemplateEmploy.TemplateId from wcmtemplateemploy where WCMTemplate.TempId=WCMTemplateEmploy.TemplateId and WCMTemplate.TempType<>0) or exists(select WCMTEMPLATENEST.nestedtemplateid from WCMTEMPLATENEST where WCMTemplate.TempId=WCMTEMPLATENEST.nestedtemplateid and WCMTemplate.TempType=0)) ";
                break;
            }
            case 19: {
                sWhere = "(not exists( select WCMTemplateEmploy.TemplateId from wcmtemplateemploy where WCMTemplate.TempId=WCMTemplateEmploy.TemplateId and WCMTemplate.TempType<>0) and not exists(select WCMTEMPLATENEST.nestedtemplateid from WCMTEMPLATENEST where WCMTemplate.TempId=WCMTEMPLATENEST.nestedtemplateid and WCMTemplate.TempType=0))";
                break;
            }
            case 4: {
                sWhere = "CrUser=?";
                filter.addSearchValues(0, _loginUser.getName());
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                sWhere = "CrTime>=?";
                filter.addSearchValues(0, ServiceConstants.makeDateTime(_nFilterType));
                break;
            }
        }
        filter.setWhere(sWhere);
        return filter;
    }

    private IPublishFolder findPublishFolder(MethodContext _methodContext) throws WCMException {
        return this.findPublishFolder(_methodContext, null);
    }

    private IPublishFolder findPublishFolder(MethodContext _methodContext, String _sClassPre) throws WCMException {
        String sClassPre = _sClassPre == null ? "Host" : _sClassPre;
        int nObjectType = _methodContext.getValue(sClassPre + "Type", 0);
        if (nObjectType == 0) {
            throw new WCMException(1101, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label36", "\u6ca1\u6709\u6307\u5b9a[") + sClassPre + "Type]!");
        }
        int nObjectId = _methodContext.getValue(sClassPre + "Id", 0);
        if (nObjectId == 0) {
            throw new WCMException(1101, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label36", "\u6ca1\u6709\u6307\u5b9a[") + sClassPre + "Id]!");
        }
        IPublishElement publishElement = PublishElementFactory.lookupElement(nObjectType, nObjectId);
        if (publishElement == null) {
            throw new WCMException(200006, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label37", "\u6307\u5b9a\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01(Type=") + nObjectType + ", Id=" + nObjectId + ")");
        }
        if (!(publishElement instanceof IPublishFolder)) {
            throw new WCMException(10, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label38", "\u6307\u5b9a\u7684\u5bf9\u8c61(") + publishElement.getInfo() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label39", ")\u4e0d\u662fFolder!"));
        }
        _methodContext.putContextCacheData("Host", publishElement);
        return (IPublishFolder)publishElement;
    }

    private IPublishElement findPublishElement(MethodContext _methodContext) throws WCMException {
        int nObjectId;
        int nObjectType = _methodContext.getValue("ObjectType", 0);
        IPublishElement publishElement = PublishElementFactory.lookupElement(nObjectType, nObjectId = _methodContext.getObjectId());
        if (publishElement == null) {
            throw new WCMException(I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label14", "\u6307\u5b9a\u7684\u5bf9\u8c61[Type=") + nObjectType + ", Id=" + nObjectId + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label6", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return publishElement;
    }

    private void renderChildren(User loginUser, BaseChannel _oBaseChannel, String sArgumentName, String sArgumentValue, boolean _renderMe) throws WCMException {
        if (_renderMe) {
            this.changeChannelArgValue(loginUser, _oBaseChannel, sArgumentName, sArgumentValue);
        }
        List<Channel> lstChildren = _oBaseChannel.getChildren(loginUser);
        int n = lstChildren.size();
        for (int i = 0; i < n; ++i) {
            BaseChannel currObj = lstChildren.get(i);
            if (currObj == null) continue;
            this.renderChildren(loginUser, currObj, sArgumentName, sArgumentValue, true);
        }
    }

    private void changeChannelArgValue(User loginUser, BaseChannel _oBaseChannel, String sArgumentName, String sArgumentValue) throws WCMException {
        int nFolderId = _oBaseChannel.getId();
        int nFolderType = 101;
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.lookupElement(nFolderType, nFolderId);
        TemplateArguments allArguments = this.m_oTemplateService.getTemplateArguments(folder);
        TemplateParameterList allParameters = this.m_oTemplateService.getTemplateParameters(folder);
        Iterator iterator = allParameters.parameters();
        HashMap mapArgus = allArguments.toHashMapForCheck();
        while (iterator.hasNext()) {
            TemplateParameter aParameter = (TemplateParameter)iterator.next();
            if (aParameter == null || !sArgumentName.equalsIgnoreCase(aParameter.getParameterName())) continue;
            TemplateArgument aArgument = (TemplateArgument)mapArgus.get(TemplateArgument.makeCacheKey(null, aParameter.getParameterName()));
            if (aArgument != null) {
                aArgument.setArgumentValue(sArgumentValue);
            } else {
                aArgument = TemplateArgument.createNewInstance();
                aArgument.setProperty("EMPLOYERTYPE", nFolderType);
                aArgument.setProperty("EMPLOYERID", nFolderId);
                aArgument.setProperty("TEMPLATEID", aParameter.getTemplateId());
                aArgument.setProperty("ARGUMENTNAME", aParameter.getParameterName());
                aArgument.setProperty("ARGUMENTVALUE", sArgumentValue);
            }
            this.m_oTemplateService.saveTemplateArgument(aArgument);
        }
    }

    public Reports existNestedTemplate(MethodContext _methodContext) throws WCMException {
        String sObjectIds = _methodContext.getObjectIds();
        Reports oReports = new Reports("\u60a8\u8981\u5220\u9664\u7684\u6a21\u677f\u4e2d\u542b\u6709\u5df2\u88ab\u5d4c\u5957\u7684\u5d4c\u5957\u6a21\u677f");
        Templates oTemplates = Templates.findByIds(null, sObjectIds);
        int nSize = oTemplates.size();
        for (int i = 0; i < nSize; ++i) {
            Templates currTemplates;
            Template currTemplate = (Template)oTemplates.getAt(i);
            if (currTemplate == null || (currTemplates = this.m_oNestMgr.getTemplatesNested(currTemplate)).size() == 0) continue;
            StringBuffer buff = new StringBuffer(256);
            int nSize2 = currTemplates.size();
            for (int j = 0; j < nSize2; ++j) {
                Template oTemplate = (Template)currTemplates.getAt(j);
                if (oTemplate == null) continue;
                buff.append("\uff0c").append(oTemplate.getName());
            }
            if (buff.length() == 0) continue;
            oReports.addWarnedReport("\u6a21\u677f [" + currTemplate.getName() + "] \u5df2\u7ecf\u88ab\u6a21\u677f [" + buff.substring(1) + "] \u5d4c\u5957\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff1b", null);
            buff.setLength(0);
        }
        return oReports;
    }

    public Templates queryForSpecial(MethodContext _methodContext) throws Throwable {
        WCMFilter tempFilter;
        User loginUser = this.getLoginUser();
        IPublishFolder folder = this.findPublishFolder(_methodContext);
        boolean bContainsChildren = _methodContext.getValue("ContainsChildren", false);
        this.validateRight(loginUser, folder, 24, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label2", "\u67e5\u770b") + folder.getInfo() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label3", "\u6a21\u677f\u5217\u8868"));
        WCMFilter filter = new WCMFilter(_methodContext.getQueryFilter());
        int nFilterType = _methodContext.getValue("FilterType", 0);
        int nTemplateType = _methodContext.getValue("TemplateType", -1);
        if (nFilterType != 0 && (tempFilter = this.makeFilterByType(loginUser, nFilterType)) != null && tempFilter.getWhere() != null && tempFilter.getWhere().length() > 0) {
            filter.mergeWith(tempFilter);
        }
        Templates oManagedTemplates = this.m_oTemplateMgr.getManagedTemplates(folder, nTemplateType, filter, bContainsChildren);
        boolean bIncludingThoseInParent = _methodContext.getValue("IncludingThoseInParent", true);
        Templates oOptionalTemplates = this.m_oTemplateMgr.getOptionalTemplates(folder, nTemplateType, filter, bIncludingThoseInParent);
        oManagedTemplates.addElements(oOptionalTemplates);
        return oManagedTemplates;
    }
}

