/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.video;

import com.trs.DreamFactory;
import com.trs.ajaxservice.JSONHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.video.VSConfig;
import com.trs.components.video.domain.WCMContextHelper;
import com.trs.components.video.domain.XVideoMgr;
import com.trs.components.video.persistent.XVideo;
import com.trs.components.video.util.SimpleConsoleLogger;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.dev4.util.JSONUtil;
import com.trs.webframework.controler.JSPRequestProcessor;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jfree.util.Log;
import org.json.JSONObject;

public class ReceiveMASServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.components.video.ReceiveMASServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Element root;
        String event = request.getParameter("event");
        String string = request.getParameter("pushInfo");
        LOG.info((Object)("push event: " + event));
        LOG.info((Object)("push pushInfo: " + string));
        if (string != null && ((root = SimpleConsoleLogger.parserXml(string)).element("time") != null || "time".equals(root.element("time")))) {
            try {
                response.getWriter().append(root.element("time").getText());
                response.getWriter().close();
            }
            catch (IOException e) {
                LOG.error((Object)"parse pushInfo error", (Throwable)e);
            }
            return;
        }
        if (event.equals("CREATE")) {
            try {
                this.receive(request, response);
            }
            catch (Exception e) {
                LOG.error((Object)"parse CREATE event error", (Throwable)e);
            }
        }
        if (event.equals("DELETE")) {
            try {
                this.delete(request, response);
            }
            catch (Exception e) {
                LOG.error((Object)"parse DELETE event error", (Throwable)e);
            }
        }
    }

    private void delete(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContextHelper.initContext((User)User.findById((int)1));
        JSONObject json = new JSONObject();
        int videoId = Integer.parseInt(request.getParameter("videoId"));
        XVideoMgr xVideoMgr = new XVideoMgr();
        try {
            xVideoMgr.deleteXvideoByVideoId(videoId);
            json.put("state", (Object)"success");
            json.put("reponseInfo", (Object)"delete successful");
            response.getWriter().print(json.toString());
        }
        catch (Exception e) {
            LOG.error((Object)("failed to delete video,videoId is :" + videoId), (Throwable)e);
            json.put("state", (Object)"fail");
            json.put("reponseInfo", (Object)"delete failed");
            response.getWriter().print(json.toString());
        }
    }

    private void receive(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContextHelper.initContext((User)User.findById((int)1));
        response.setHeader("x-mas", VSConfig.getVersion().getReleaseInfo());
        String video = request.getParameter("video");
        LOG.info((Object)("push video jsonStr: " + video));
        String ip = request.getRemoteAddr();
        JSONObject json = new JSONObject();
        if (!ip.trim().equals(VSConfig.getMASIP().trim())) {
            try {
                json.put("state", (Object)"fail");
                json.put("reponseInfo", (Object)("Illegal push IP address[" + ip.trim() + "]"));
            }
            catch (Exception e) {
                LOG.error((Object)"receiveMAS fail", (Throwable)e);
                response.getWriter().print(JSONHelper.toJSON((Object)e, (String)ip, (int)0));
            }
            response.getWriter().print(json.toString());
            LOG.info((Object)("Illegal push IP address[" + ip.trim() + "]"));
            response.getWriter().close();
            return;
        }
        if (VSConfig.getChnId() == null) {
            try {
                json.put("state", (Object)"fail");
                json.put("reponseInfo", (Object)"No receive channel ID");
            }
            catch (Exception e) {
                LOG.error((Object)"receiveMAS fail", (Throwable)e);
                response.getWriter().print(JSONHelper.toJSON((Object)e, (String)ip, (int)0));
            }
            response.getWriter().print(json.toString());
            LOG.info((Object)("push chnId is null: " + json));
            response.getWriter().close();
            return;
        }
        if (video != null) {
            int videoId = Integer.parseInt(JSONUtil.getValue((String)video, (String)"videoId"));
            String docTitle = JSONUtil.getValue((String)video, (String)"videoTitle");
            XVideo xvideo = new XVideo();
            Document document = new Document();
            XVideoMgr xvideoMgr = WCMContextHelper.getXVideoMgr();
            DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById((String)"DocumentMgr");
            JSPRequestProcessor processor = new JSPRequestProcessor(request, response);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("objectid", "0");
            String value = String.valueOf(VSConfig.getChnId());
            parameters.put("channelid", value);
            parameters.put("docTitle", docTitle);
            parameters.put("docContent", "111");
            Integer nDocId = (Integer)processor.excute("wcm6_document", "save", parameters);
            document = Document.findById((int)nDocId);
            m_oDocumentMgr.save(document);
            xvideo.setDocId(document.getId());
            xvideo.setSrcFileName(request.getParameter("sorVideoName"));
            xvideo.setThumb(request.getParameter("thumbSubPath"));
            xvideo.setDuration(Integer.parseInt(request.getParameter("duration")));
            xvideo.setWidth(Integer.parseInt(request.getParameter("width")));
            xvideo.setHeight(Integer.parseInt(request.getParameter("height")));
            xvideo.setFPS(Integer.parseInt(request.getParameter("fps")));
            xvideo.setBitrate(Integer.parseInt(request.getParameter("bitrate")));
            xvideo.setPlayUrl(JSONUtil.getValue((String)video, (String)"playUrl"));
            xvideo.setThumbUrl(JSONUtil.getValue((String)video, (String)"thumbUrl"));
            xvideo.setVideoId(videoId);
            xvideo.setCreateType(50);
            xvideo.setFileName(request.getParameter("videoSubPath"));
            xvideo.setConvertStatus(1);
            xvideo.setQuality(0);
            xvideoMgr.insert(xvideo);
            ContextHelper.clear();
            try {
                json.put("state", (Object)"success");
                json.put("reponseInfo", (Object)"push success");
            }
            catch (Exception e) {
                LOG.error((Object)("pushReponse error: " + e));
            }
            Log.info((Object)("save video successful,videoId is" + xvideo.getVideoId()));
            Log.info((Object)("save video successful,json is" + json));
            response.getWriter().print(json.toString());
            response.getWriter().close();
            return;
        }
        try {
            json.put("state", (Object)"fail");
            json.put("reponseInfo", (Object)"save fail");
            response.getWriter().close();
        }
        catch (Exception e) {
            LOG.error((Object)"save failed", (Throwable)e);
        }
        LOG.warn((Object)"save failed");
        response.getWriter().print(json.toString());
        response.getWriter().close();
    }
}

