/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.sp.core;

import com.trs.idm.common.IConfig;
import com.trs.idm.saml.common.SPConfig;
import com.trs.idm.saml.protocol.IClientProtocolManager;
import com.trs.idm.saml.protocol.builder.request.IRequestBuilder;
import com.trs.idm.saml.sp.core.IServiceProvider;
import com.trs.idm.saml.sp.resource.IResourceManager;
import com.trs.idm.saml.sp.transporter.ITransporterManager;
import com.trs.idm.util.ResourceUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public abstract class ServiceProviderBase
implements IServiceProvider {
    protected static final Logger LOG = Logger.getLogger(ServiceProviderBase.class);
    public static final String LOG4J_CFG_FILE = "/log4j_idsagent.properties";
    protected IResourceManager resourceManager;
    protected ITransporterManager transporterManager;
    protected String forbidPage;
    protected IClientProtocolManager clientProtocolManager;
    protected IConfig config;
    protected IRequestBuilder requestBuilder;
    protected boolean isStarted;

    public void start() {
        LOG.info((Object)"ServiceProviderBase start successfully");
        this.appendAgentLog4JConfig(LOG4J_CFG_FILE);
    }

    public void stop() {
        LOG.info((Object)"ServiceProviderBase stop successfully");
    }

    public ITransporterManager getTransporterManager() {
        return this.transporterManager;
    }

    public abstract IClientProtocolManager getClientProtocolManager();

    public IConfig getConfig() {
        return this.config;
    }

    public void setConfig(IConfig config) {
        this.config = config;
    }

    public String getIDPUrl() {
        return this.config.getConfig(SPConfig.BASIC_SSO_IDS_URL, "You did not config IDP SSO Service URL");
    }

    public String getIDSUrl() {
        String IDSUrl = this.config.getConfig(SPConfig.BASIC_SSO_IDS_URL, "You did not config IDS URL");
        return IDSUrl.trim();
    }

    public String getAutoSubmitPage() {
        return this.config.getConfig(SPConfig.BASIC_PAGE_AUTOSUBMIT, "/idsSPPages/sp.jsp");
    }

    public String getCoAppName() {
        return this.config.getConfig("agent.name");
    }

    public String getIssuer() {
        return this.config.getConfig(SPConfig.SSO_SAML2_CONFIG_ISSUER, "Issuer is not configured!");
    }

    void appendAgentLog4JConfig(String cfgFileInClassPath) {
        String agentLog4JFile = ResourceUtil.getFullPath(ServiceProviderBase.class, cfgFileInClassPath);
        if (agentLog4JFile != null) {
            PropertyConfigurator.configureAndWatch((String)agentLog4JFile);
        }
    }

    public boolean isFirstTimeCheckSSOLogin(HttpServletRequest request, HttpServletResponse response) {
        return false;
    }
}

