/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.model;

public class ObjectCounter {
    private long objectsGot = 0L;
    private long objectsCached = 0L;
    private long objectsCachedWithSearched = 0L;
    private long objectsSearched = 0L;
    private long searchTimes = 0L;
    private long objectsSaved = 0L;
    private long objectsDeleted = 0L;
    private String objectClass;

    public ObjectCounter(String objectClass) {
        this.objectClass = objectClass;
    }

    public void countDelete(int count) {
        this.objectsDeleted += (long)count;
    }

    public void countDelete() {
        this.countDelete(1);
    }

    public void countGet() {
        ++this.objectsGot;
    }

    public void countCache() {
        ++this.objectsCached;
    }

    public void countSearch(int searchedCount, int cachedCount) {
        ++this.searchTimes;
        this.objectsSearched += (long)searchedCount;
        this.objectsCachedWithSearched += (long)cachedCount;
    }

    public void countSave() {
        ++this.objectsSaved;
    }

    public void countSave(int savedCount) {
        this.objectsSaved += (long)savedCount;
    }

    public void countCache(int cachedObject) {
        this.objectsCached += (long)cachedObject;
    }

    public long getObjectsGot() {
        return this.objectsGot;
    }

    public long getObjectsCached() {
        return this.objectsCached;
    }

    public long getObjectsCachedWithSearched() {
        return this.objectsCachedWithSearched;
    }

    public long getObjectsSearched() {
        return this.objectsSearched;
    }

    public long getSearchTimes() {
        return this.searchTimes;
    }

    public long getObjectsSaved() {
        return this.objectsSaved;
    }

    public long getObjectsDeleted() {
        return this.objectsDeleted;
    }

    public String getObjectClass() {
        return this.objectClass;
    }
}

