/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.controler.servlet;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.webframework.FrameworkConstants;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.config.TRSPageParameter;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.server.RequestParmasParseException;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BaseValidator {
    public static final String PARAM_NAME_SEARCH_KEY = "SearchKey";
    public static final String PARAM_NAME_SEARCH_TABLE = "SearchTable";
    public static final String PARAM_NAME_SEARCH_VALUE = "SearchValue";
    public static final String PARAM_NAME_ORDER_FIELD = "OrderField";
    public static final String PARAM_NAME_ORDER_TYPE = "OrderType";
    protected MethodContext m_oMethodContext = null;
    protected MethodConfig m_oMethoConfig = null;
    protected static Logger logger = Logger.getLogger(BaseValidator.class);

    public BaseValidator(MethodConfig methoConfig) {
        this.m_oMethoConfig = methoConfig;
    }

    protected abstract String getParameterValue(String var1);

    protected void doValidate() {
        this.m_oMethodContext = new MethodContext(this.m_oMethoConfig);
        if (!this.m_oMethoConfig.isParamsRequired()) {
            return;
        }
        TRSPageParameter[] pPageParameters = this.m_oMethoConfig.getPageParameter();
        TRSPageParameter currPageParameter = null;
        for (int i = 0; i < pPageParameters.length; ++i) {
            currPageParameter = pPageParameters[i];
            if (currPageParameter == null || this.m_oMethodContext.containsParameter(currPageParameter.getName())) continue;
            String sValue = this.getParameterValue(currPageParameter.getName());
            if (currPageParameter.isRequired() && sValue == null) {
                throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label1", "\u670d\u52a1[") + this.m_oMethoConfig.getServiceConfig().getServiceId() + "." + this.m_oMethoConfig.toString() + I18NMessage.get(BaseValidator.class, "BaseValidator.label2", "]\u6240\u9700\u53c2\u6570[") + currPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label3", "]\u6ca1\u6709\u4f20\u5165!"));
            }
            this.doValueValidate(currPageParameter, sValue);
        }
    }

    private void doValueValidate(TRSPageParameter _currPageParameter, String _sValue) {
        String sValue = _sValue;
        if (sValue == null) {
            sValue = _currPageParameter.getDefault();
            if (sValue == null) {
                return;
            }
        } else {
            sValue = _sValue.trim();
        }
        String sParameterName = _currPageParameter.getName();
        if (_currPageParameter.getMinValue() != null && _currPageParameter.getMinValue().length() > 0 && Long.parseLong(sValue) < Long.parseLong(_currPageParameter.getMinValue())) {
            throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label4", "\u9875\u9762\u53c2\u6570[") + _currPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label5", "]\u503c[") + sValue + I18NMessage.get(BaseValidator.class, "BaseValidator.label6", "]\u5c0f\u4e8e\u6700\u5c0f\u503c[") + _currPageParameter.getMinValue() + "]\uff01");
        }
        if (_currPageParameter.getMaxValue() != null && _currPageParameter.getMaxValue().length() > 0 && Long.parseLong(sValue) > Long.parseLong(_currPageParameter.getMaxValue())) {
            throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label4", "\u9875\u9762\u53c2\u6570[") + _currPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label5", "]\u503c[") + sValue + I18NMessage.get(BaseValidator.class, "BaseValidator.label7", "]\u5927\u4e8e\u6700\u5927\u503c[") + _currPageParameter.getMaxValue() + "]\uff01");
        }
        if (_currPageParameter.getMinLength() > 0 && sValue.length() < _currPageParameter.getMinLength()) {
            throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label4", "\u9875\u9762\u53c2\u6570[") + _currPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label8", "]\u957f\u5ea6[") + sValue.length() + I18NMessage.get(BaseValidator.class, "BaseValidator.label9", "]\u5c0f\u4e8e\u6700\u5c0f\u957f\u5ea6[") + _currPageParameter.getMinLength() + "]\uff01");
        }
        if (_currPageParameter.getMaxLength() > 0 && sValue.length() > _currPageParameter.getMaxLength()) {
            throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label4", "\u9875\u9762\u53c2\u6570[") + _currPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label8", "]\u957f\u5ea6[") + sValue.length() + I18NMessage.get(BaseValidator.class, "BaseValidator.label10", "]\u5927\u4e8e\u6700\u5927\u957f\u5ea6[") + _currPageParameter.getMaxLength() + "]\uff01");
        }
        String sType = _currPageParameter.getType().toLowerCase();
        switch (sType.hashCode()) {
            case -891985903: {
                this.m_oMethodContext.setValue(_currPageParameter.getName(), sValue);
                break;
            }
            case 104431: {
                sValue = sValue.trim();
                if (sValue.length() == 0) break;
                try {
                    this.m_oMethodContext.setValue(_currPageParameter.getName(), Integer.parseInt(sValue));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label11", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + _currPageParameter.getDesc() + "][" + _currPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label12", "]\u7c7b\u578b\u4e0d\u5bf9![") + sValue + I18NMessage.get(BaseValidator.class, "BaseValidator.label13", "]\u4e0d\u662f\u6574\u578b\u6570"), e);
                }
            }
            case 64711720: {
                sValue = sValue.trim();
                if (sValue.length() == 0) break;
                try {
                    if (sValue.length() == 1) {
                        int nValue = Integer.parseInt(sValue);
                        if (nValue != 1 && nValue != 0) {
                            throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label14", "\u4f20\u5165\u7684\u5e03\u5c14\u578b\u53c2\u6570\u4e0d\u662f0\uff0c1"));
                        }
                        this.m_oMethodContext.setValue(sParameterName, nValue);
                        break;
                    }
                    this.m_oMethodContext.setValue(sParameterName, sValue.equalsIgnoreCase("true") ? 1 : 0);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label11", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + _currPageParameter.getDesc() + "][" + _currPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label12", "]\u7c7b\u578b\u4e0d\u5bf9![") + sValue + I18NMessage.get(BaseValidator.class, "BaseValidator.label13", "]\u4e0d\u662f\u6574\u578b\u6570"), e);
                }
            }
            case 3327612: {
                sValue = sValue.trim();
                if (sValue.length() == 0) break;
                try {
                    this.m_oMethodContext.setValue(_currPageParameter.getName(), Long.parseLong(sValue));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label11", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + _currPageParameter.getDesc() + "][" + _currPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label12", "]\u7c7b\u578b\u4e0d\u5bf9![") + sValue + I18NMessage.get(BaseValidator.class, "BaseValidator.label13", "]\u4e0d\u662f\u6574\u578b\u6570"), e);
                }
            }
            case 97526364: {
                sValue = sValue.trim();
                if (sValue.length() == 0) break;
                try {
                    this.m_oMethodContext.setValue(_currPageParameter.getName(), Float.parseFloat(sValue));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label11", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + _currPageParameter.getDesc() + "][" + _currPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label12", "]\u7c7b\u578b\u4e0d\u5bf9![") + sValue + I18NMessage.get(BaseValidator.class, "BaseValidator.label15", "]\u4e0d\u662f\u6d6e\u70b9\u6570"), e);
                }
            }
            case 3076014: 
            case 1793702779: {
                sValue = sValue.trim();
                if (sValue.length() == 0) break;
                CMyDateTime dtValue = null;
                CMyDateTime maxDtValue = null;
                char cValueEnd = sValue.toUpperCase().charAt(sValue.length() - 1);
                int nDateRangeType = -1;
                int valueStatus = 0;
                switch (cValueEnd) {
                    case 'D': {
                        nDateRangeType = 3;
                        break;
                    }
                    case 'M': {
                        nDateRangeType = 2;
                        break;
                    }
                    case 'Y': {
                        nDateRangeType = 1;
                        break;
                    }
                    default: {
                        try {
                            dtValue = new CMyDateTime();
                            dtValue.setDateTimeWithString(sValue);
                            break;
                        }
                        catch (CMyException e) {
                            throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label11", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + _currPageParameter.getDesc() + "][" + _currPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label12", "]\u7c7b\u578b\u4e0d\u5bf9![") + sValue + I18NMessage.get(BaseValidator.class, "BaseValidator.label16", "]\u4e0d\u662f\u65e5\u671f\u578b"), e);
                        }
                    }
                }
                if (nDateRangeType != -1) {
                    try {
                        valueStatus = Integer.parseInt(sValue.substring(0, sValue.length() - 1));
                        dtValue = CMyDateTime.now();
                        maxDtValue = (CMyDateTime)dtValue.clone();
                        maxDtValue.dateAdd(nDateRangeType, valueStatus);
                        if (valueStatus < 0) {
                            this.m_oMethodContext.setValue(sParameterName + "START", maxDtValue);
                            this.m_oMethodContext.setValue(sParameterName + "END", dtValue);
                        } else {
                            this.m_oMethodContext.setValue(sParameterName + "START", dtValue);
                            this.m_oMethodContext.setValue(sParameterName + "END", maxDtValue);
                        }
                    }
                    catch (Exception e) {
                        throw new RequestParmasParseException(I18NMessage.get(BaseValidator.class, "BaseValidator.label11", "\u9875\u9762\u6240\u9700\u53c2\u6570[") + _currPageParameter.getDesc() + "][" + _currPageParameter.getName() + I18NMessage.get(BaseValidator.class, "BaseValidator.label12", "]\u7c7b\u578b\u4e0d\u5bf9![") + sValue + I18NMessage.get(BaseValidator.class, "BaseValidator.label16", "]\u6807\u793a\u524d\u5b57\u7b26\u4e0d\u662f\u6570\u5b57\uff01"), e);
                    }
                }
                if (valueStatus < 0) {
                    this.m_oMethodContext.setValue(sParameterName, maxDtValue);
                    break;
                }
                this.m_oMethodContext.setValue(sParameterName, dtValue);
                break;
            }
        }
    }

    public MethodContext getMethodContext() {
        if (this.m_oMethodContext == null) {
            this.doValidate();
        }
        Map map = FrameworkConstants.KeywordedParams;
        for (String sParamName : map.keySet()) {
            this.m_oMethodContext.setValue(sParamName, this.getParameterValue(sParamName));
        }
        return this.m_oMethodContext;
    }
}

