/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class TRSParameter {
    private Hashtable m_hProperty = new Hashtable();

    public Enumeration getKeys() {
        return this.m_hProperty.keys();
    }

    protected abstract void validXMLElement(Element var1) throws CMyException;

    public boolean fromXML(Element _element) throws CMyException {
        if (_element == null) {
            throw new CMyException(10, I18NMessage.get(TRSParameter.class, "TRSParameter.label1", "\u6ca1\u6709\u6307\u5b9a\u53c2\u6570\u5c5e\u6027\u8282\u70b9!"));
        }
        this.validXMLElement(_element);
        List listAttributes = _element.attributes();
        if (listAttributes == null || listAttributes.size() == 0) {
            return false;
        }
        Attribute attTemp = null;
        boolean bSuccessSet = false;
        try {
            for (int i = 0; i < listAttributes.size(); ++i) {
                attTemp = (Attribute)listAttributes.get(i);
                if (attTemp == null || !this.setPropertyWithString(attTemp.getName(), attTemp.getValue())) continue;
                bSuccessSet = true;
            }
        }
        catch (Exception ex) {
            throw new CMyException(1, I18NMessage.get(TRSParameter.class, "TRSParameter.label2", "\u5bfc\u5165XML DOM Element\u6570\u636e\u5931\u8d25(") + this.getClass().getName() + ".fromXML)", ex);
        }
        this.validValue();
        return bSuccessSet;
    }

    protected abstract void validValue() throws CMyException;

    public boolean setPropertyWithString(String _sName, String _sValue) {
        if (_sValue == null || (_sValue = _sValue.trim()).length() == 0) {
            return false;
        }
        return this.m_hProperty.put(_sName.toLowerCase(), _sValue) != null;
    }

    public Object getProperty(String _sName) {
        return this.m_hProperty.get(_sName.toLowerCase());
    }

    public String getPropertyAsString(String _sName) {
        Object objValue = this.getProperty(_sName);
        if (objValue == null) {
            return null;
        }
        return (String)objValue;
    }

    public CMyDateTime getPropertyAsDateTime(String _sName) throws CMyException {
        Object oValue = this.getProperty(_sName);
        if (oValue == null) {
            return null;
        }
        CMyDateTime dtValue = new CMyDateTime();
        try {
            dtValue.setDateTimeWithString((String)oValue);
        }
        catch (Exception ex) {
            throw new CMyException(2, I18NMessage.get(TRSParameter.class, "TRSParameter.label3", "\u5c5e\u6027\u683c\u5f0f\u4e0d\u662f\u65e5\u671f\u578b\uff01[") + oValue + "]");
        }
        return dtValue;
    }

    public long getPropertyAsLong(String _sName, long _lDefault) throws CMyException {
        Object oValue = this.getProperty(_sName);
        if (oValue == null) {
            return _lDefault;
        }
        try {
            return Long.parseLong(oValue.toString());
        }
        catch (Exception ex) {
            throw new CMyException(2, I18NMessage.get(TRSParameter.class, "TRSParameter.label4", "\u5c5e\u6027\u683c\u5f0f\u4e0d\u662f\u957f\u6574\u578b\uff01[") + oValue + "]");
        }
    }

    public int getPropertyAsInt(String _sName, int _nDefault) throws CMyException {
        Object oValue = this.getProperty(_sName);
        if (oValue == null) {
            return _nDefault;
        }
        try {
            return Integer.parseInt(oValue.toString());
        }
        catch (Exception ex) {
            throw new CMyException(2, I18NMessage.get(TRSParameter.class, "TRSParameter.label5", "\u5c5e\u6027\u683c\u5f0f\u4e0d\u662f\u6574\u578b\uff01[") + oValue + "]");
        }
    }

    public boolean getPropertyAsBoolean(String _sName, boolean _bDefault) throws CMyException {
        int nValue = this.getPropertyAsInt(_sName, _bDefault ? 1 : 0);
        return nValue != 0;
    }

    public static void main(String[] args) {
    }
}

