/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.BaseConfigServer;
import com.trs.infra.config.domain.ConfigHelper;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.webframework.config.LoadingErrorReport;
import com.trs.webframework.config.ServiceConfig;
import com.trs.webframework.config.ServiceFilterConfig;
import com.trs.webframework.config.ServiceFilterConfigs;
import com.trs.webframework.config.ServiceListenerConfig;
import com.trs.webframework.config.ServiceListenerConfigs;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceConfigStartServer
extends BaseConfigServer {
    protected static Logger logger = Logger.getLogger(ServiceConfigStartServer.class);
    private Map MAP_CONFIG_SERVER = null;
    private ServiceFilterConfigs m_oFilterConfigs = new ServiceFilterConfigs();
    private ServiceListenerConfigs m_oListenerConfigs = new ServiceListenerConfigs();

    public ServiceConfigStartServer() {
        this.m_sAppName = "service";
    }

    public ServiceConfig findServiceConfigById(String _sServiceId) {
        return (ServiceConfig)this.MAP_CONFIG_SERVER.get(_sServiceId.toLowerCase());
    }

    public ServiceFilterConfig[] findServiceFilterConfigs(String _sServiceId, String _sMethodName) {
        return this.m_oFilterConfigs.findServiceFilterConfigs(_sServiceId, _sMethodName);
    }

    public ServiceListenerConfig[] findServiceListenerConfigs(String _sServiceId, String _sMethodName) {
        return this.m_oListenerConfigs.findServiceListenerConfigs(_sServiceId, _sMethodName);
    }

    @Override
    protected void doShutdown() {
    }

    @Override
    protected boolean doStart() throws WCMException {
        if (this.MAP_CONFIG_SERVER != null) {
            return true;
        }
        ArrayList arClassPaths = ConfigHelper.getServiceConfigPaths();
        HashMap<String, ServiceConfig> mTemp = new HashMap<String, ServiceConfig>();
        int nSize = arClassPaths.size();
        for (int nClassPathIndex = 0; nClassPathIndex < nSize; ++nClassPathIndex) {
            String sClassPath = (String)arClassPaths.get(nClassPathIndex);
            String sConfigPath = sClassPath + this.m_sAppName + File.separatorChar;
            this.setConfigPath(sConfigPath);
            FileService rootPath = new FileService(sConfigPath);
            if (!rootPath.exists() || !rootPath.isDirectory()) continue;
            FileStore[] files = rootPath.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileService oDirListenerConfigs;
                FileStore fileSubConfigServer = files[i];
                if (!fileSubConfigServer.isDirectory()) continue;
                String sPreServiceId = fileSubConfigServer.getName();
                FileStore[] serviceConfigfiles = fileSubConfigServer.listFiles();
                if (serviceConfigfiles == null) continue;
                for (int j = 0; j < serviceConfigfiles.length; ++j) {
                    String sServiceId;
                    String sServiceConfigFileName;
                    int nPos;
                    FileStore serviceConfigFile = serviceConfigfiles[j];
                    if (!serviceConfigFile.isFile() || (nPos = (sServiceConfigFileName = serviceConfigFile.getName()).lastIndexOf(46)) <= 0 || !"xml".equalsIgnoreCase(sServiceConfigFileName.substring(nPos + 1)) || mTemp.containsKey((sServiceId = sPreServiceId + "_" + sServiceConfigFileName.substring(0, nPos)).toLowerCase())) continue;
                    ServiceConfig config = new ServiceConfig(sServiceId);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("serviceConfigFile.getAbsolutePath:" + serviceConfigFile.getAbsolutePath()));
                    }
                    config.loadFromFile(serviceConfigFile.getAbsolutePath());
                    LoadingErrorReport errReport = config.getLoadingErrorReport();
                    if (errReport != null) {
                        logger.error((Object)(I18NMessage.get(ServiceConfigStartServer.class, "ServiceConfigStartServer.label2", "\u52a0\u8f7d[") + sServiceConfigFileName + I18NMessage.get(ServiceConfigStartServer.class, "ServiceConfigStartServer.label3", "]\u65f6\u51fa\u73b0\u5982\u4e0b\u9519\u8bef\uff1a\n") + errReport.toString()));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(sServiceId.toLowerCase() + ":" + config));
                    }
                    mTemp.put(sServiceId.toLowerCase(), config);
                }
                String sPath = fileSubConfigServer.getAbsolutePath() + File.separator + "filters" + File.separatorChar;
                FileService oDirFilterConfigs = new FileService(sPath);
                if (oDirFilterConfigs.exists()) {
                    FileStore[] pFilterConfigfiles = oDirFilterConfigs.listFiles();
                    for (int j = 0; j < pFilterConfigfiles.length; ++j) {
                        String sConfigFileName;
                        int nPos;
                        FileStore oFilterConfigFile = pFilterConfigfiles[j];
                        if (!oFilterConfigFile.isFile() || (nPos = (sConfigFileName = oFilterConfigFile.getName()).lastIndexOf(46)) <= 0 || !"xml".equalsIgnoreCase(sConfigFileName.substring(nPos + 1))) continue;
                        this.m_oFilterConfigs.addFromFile(sPreServiceId, oFilterConfigFile.getAbsolutePath());
                    }
                }
                if (!(oDirListenerConfigs = new FileService(fileSubConfigServer.getAbsolutePath() + File.separator + "listeners" + File.separatorChar)).exists()) continue;
                FileStore[] pListenerConfigfiles = oDirListenerConfigs.listFiles();
                for (int j = 0; j < pListenerConfigfiles.length; ++j) {
                    String sConfigFileName;
                    int nPos;
                    FileStore oListenerConfigFile = pListenerConfigfiles[j];
                    if (!oListenerConfigFile.isFile() || (nPos = (sConfigFileName = oListenerConfigFile.getName()).lastIndexOf(46)) <= 0 || !"xml".equalsIgnoreCase(sConfigFileName.substring(nPos + 1))) continue;
                    this.m_oListenerConfigs.addFromFile(sPreServiceId, oListenerConfigFile.getAbsolutePath());
                }
            }
        }
        this.MAP_CONFIG_SERVER = mTemp;
        return true;
    }

    public Map getServiceConfigsMap() {
        return this.MAP_CONFIG_SERVER;
    }
}

