/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcmonline;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import org.apache.log4j.Logger;

public class WCMOnlineService {
    private static final Logger LOG = Logger.getLogger(WCMOnlineService.class);

    public String createVip(String sVipId, String sVipName, String sVisitUrl, String sSiteId, String sChnlId) {
        Channel channel;
        User user = User.getSystem();
        ContextHelper.initContext(user);
        int nSiteId = 0;
        WebSite site = null;
        try {
            nSiteId = Integer.parseInt(sSiteId);
            site = WebSite.findById(nSiteId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (site == null) {
            return "site not found[Id=" + sSiteId + "]";
        }
        int nParentId = 0;
        Channel parent = null;
        try {
            nParentId = Integer.parseInt(sChnlId);
            parent = Channel.findById(nParentId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nParentId > 0) {
            if (parent == null) {
                return "parent channel not found[Id=" + nParentId + "]";
            }
            if (parent.getSiteId() != nSiteId) {
                return "parent channel " + parent + " not in site " + site;
            }
        }
        if ((channel = Channel.findByName(nSiteId, sVipName)) != null) {
            return "channel name[" + sVipName + "] exists";
        }
        try {
            channel = new Channel();
            channel.setName(sVipName);
            channel.setDesc(sVipName);
            channel.setType(0);
            channel.setParent(nParentId);
            channel.setSite(nSiteId);
            channel.setAttribute("VipId", sVipId);
            channel.setAttribute("SysUrl", sVisitUrl);
            channel.setCanPub(true);
            channel.save(user);
            return "true";
        }
        catch (Exception e) {
            return "save channel fail:" + e;
        }
    }

    public String getSiteTree() {
        boolean zV6;
        block7: {
            zV6 = true;
            try {
                WebSite site = new WebSite();
                site.setProperty("SITETYPE", 0L);
            }
            catch (WCMException e) {
                if (e.getErrNo() != 1101) break block7;
                zV6 = false;
            }
        }
        try {
            WebSites sites = new WebSites(null);
            WCMFilter filter = new WCMFilter("WCMWEBSITE", "", "");
            filter.setSelect("SITEID,SITEDESC");
            if (zV6) {
                String sSiteType = ConfigServer.getServer().getSysConfigValue("CREATE_INTERVIEW_FOR_SITETYPE", "0");
                filter.setWhere("Status=0 and SiteType in (" + sSiteType + ")");
            } else {
                filter.setWhere("Status=0");
            }
            sites.open(filter);
            StringBuffer buff = new StringBuffer(128 * sites.size());
            buff.append("<SITES>");
            WebSite site = null;
            int size = sites.size();
            for (int i = 0; i < size; ++i) {
                site = (WebSite)sites.getAt(i);
                if (site == null) continue;
                buff.append("<SITE><PROPERTIES>");
                buff.append("<SITEID>");
                buff.append(site.getId());
                buff.append("</SITEID>");
                buff.append("<SITEDESC><![CDATA[");
                buff.append(site.getDesc());
                buff.append("]]></SITEDESC>");
                buff.append("</PROPERTIES></SITE>");
            }
            buff.append("</SITES>");
            return buff.toString();
        }
        catch (Exception e) {
            return "get site from wcm fail:" + e;
        }
    }

    public void updateVisitUrl(String sVisitUrl) throws Exception {
        Channels channels = new Channels(null);
        WCMFilter filter = new WCMFilter("WCMCHANNEL", "Attribute like '%SysUrl%'", "");
        channels.open(filter);
        Channel channel = null;
        User user = User.getSystem();
        int size = channels.size();
        for (int i = 0; i < size; ++i) {
            channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            channel.canEdit(user);
            channel.setAttribute("SysUrl", sVisitUrl);
            channel.update(user);
        }
    }

    public String importPost(String sVipId, String sTitle, String sContent) throws Exception {
        int nChnlId = 0;
        try {
            nChnlId = Integer.parseInt(sVipId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nChnlId == 0) {
            return "\u8bbf\u8c08\u5bf9\u5e94\u7684\u680f\u76ee\u4e0d\u5b58\u5728!";
        }
        ContextHelper.initContext(User.getSystem());
        Channels channels = new Channels(null);
        WCMFilter filter = new WCMFilter("WCMCHANNEL", "Attribute like '%SysUrl%'", "");
        channels.open(filter);
        Channel docchannel = null;
        boolean zFound = false;
        int size = channels.size();
        for (int i = 0; i < size && !zFound; ++i) {
            docchannel = (Channel)channels.getAt(i);
            if (docchannel == null) continue;
            zFound = sVipId.equals(docchannel.getAttributeValue("VipId"));
            nChnlId = docchannel.getId();
        }
        if (!zFound) {
            return "\u8bbf\u8c08\u5bf9\u5e94\u7684\u680f\u76ee\u4e0d\u5b58\u5728!";
        }
        try {
            Document doc = new Document();
            doc.setChannel(nChnlId);
            doc.setTitle(sTitle);
            doc.setHtmlContent(sContent);
            doc.setProperty("DOCWORDSCOUNT", sContent.length());
            doc.setType(20);
            DocumentMgr docmgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
            docmgr.save(doc);
        }
        catch (Exception ex) {
            LOG.error((Object)"fail", (Throwable)ex);
            return String.valueOf(ex);
        }
        return "true";
    }

    public String loadTree(String parentid, String siteid) throws Exception {
        StringBuffer buff = new StringBuffer(256);
        User user = User.getSystem();
        ContextHelper.initContext(user);
        int id = 0;
        try {
            id = Integer.parseInt(parentid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BaseChannel parent = null;
        if (id == 0) {
            try {
                id = Integer.parseInt(siteid);
            }
            catch (Exception exception) {
                // empty catch block
            }
            parent = WebSite.findById(id);
        } else {
            parent = Channel.findById(id);
        }
        List<Channel> children = parent.getChildren(user, 0);
        Channel channel = null;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            channel = children.get(i);
            if (channel == null) continue;
            buff.append("<div title='");
            buff.append(CMyString.filterForHTMLValue(channel.getDesc()));
            buff.append("' SValue='").append(channel.getId()).append("'");
            buff.append(" path='").append(this.getPath(channel)).append("'");
            buff.append(" id='chnl").append('_');
            buff.append(channel.getId()).append("'><a href='#'>");
            buff.append(CMyString.filterForHTMLValue(channel.getDesc()));
            buff.append("</a></div>");
            if (!this.hasChildren(channel.getId())) continue;
            buff.append("<ul></ul>");
        }
        return buff.toString();
    }

    private Object getPath(Channel channel) {
        StringBuffer buff = new StringBuffer(64);
        buff.insert(0, channel.getDesc());
        try {
            for (channel = channel.getParent(); channel != null; channel = channel.getParent()) {
                buff.insert(0, ">>");
                buff.insert(0, channel.getDesc());
            }
            return CMyString.filterForHTMLValue(buff.toString());
        }
        catch (Exception ex) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasChildren(int id) {
        String sql = "select count(channelid) from wcmchannel where status=0 and chnltype=0 and parentid=?";
        DBManager dbmanager = DBManager.getDBManager();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, id);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                boolean bl = rs.getInt(1) > 0;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbmanager.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public String checkExists(String sVipName, String sSiteId) {
        User user = User.getSystem();
        ContextHelper.initContext(user);
        int nSiteId = 0;
        WebSite site = null;
        try {
            nSiteId = Integer.parseInt(sSiteId);
            site = WebSite.findById(nSiteId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (site == null) {
            return "site not found[Id=" + sSiteId + "]";
        }
        Channel channel = Channel.findByName(nSiteId, sVipName);
        return channel == null ? "false" : "true";
    }

    public String canPub(String sVipId) throws Exception {
        int nChnlId = 0;
        try {
            nChnlId = Integer.parseInt(sVipId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nChnlId == 0) {
            return "\u8bbf\u8c08\u5bf9\u5e94\u7684\u680f\u76ee\u4e0d\u5b58\u5728!";
        }
        ContextHelper.initContext(User.getSystem());
        Channels channels = new Channels(null);
        WCMFilter filter = new WCMFilter("WCMCHANNEL", "Attribute like '%SysUrl%'", "");
        channels.open(filter);
        Channel docchannel = null;
        int size = channels.size();
        for (int i = 0; i < size; ++i) {
            docchannel = (Channel)channels.getAt(i);
            if (docchannel == null || !sVipId.equals(docchannel.getAttributeValue("VipId"))) continue;
            return String.valueOf(docchannel.isCanPub());
        }
        return "\u8bbf\u8c08\u5bf9\u5e94\u7684\u680f\u76ee\u4e0d\u5b58\u5728!";
    }
}

