/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.store.FileService;
import com.trs.tools.MediaFilesMD5Digest;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Set;

public class ModifiedFilesCollector {
    private static final int BUFFER_LENGTH = 4096;
    private final byte[] BUFFER = new byte[4096];
    private String m_sAppDir;
    private int m_nAppDirLength;
    private String m_sDigestStoreFile;
    private String m_sCollectDir;
    private FileService m_fCollectDir;
    private boolean m_bCollectAddedFiles;

    public ModifiedFilesCollector(String _sAppDir, String _sDigestStoreFile) {
        this.m_sAppDir = _sAppDir;
        this.m_sDigestStoreFile = _sDigestStoreFile;
    }

    public void setCollectDir(String _sCollectDir) {
        this.m_sCollectDir = _sCollectDir;
    }

    public void setCollectAddedFiles(boolean _bCollectAddedFiles) {
        this.m_bCollectAddedFiles = _bCollectAddedFiles;
    }

    public void collect() throws Exception {
        if (this.isEmpty(this.m_sDigestStoreFile)) {
            this.m_sDigestStoreFile = new FileService(this.m_sAppDir, "media_digest.txt").getAbsolutePath();
        }
        MediaFilesMD5Digest digest = new MediaFilesMD5Digest(this.m_sAppDir, this.m_sDigestStoreFile);
        System.out.println("collecting changed files.");
        Set fileSet = digest.getDifference();
        if (fileSet.isEmpty()) {
            System.out.println("No files changed.");
            return;
        }
        if (this.isEmpty(this.m_sCollectDir)) {
            this.m_sCollectDir = System.getProperty("java.io.tmpdir");
        }
        this.m_fCollectDir = new FileService(this.m_sCollectDir, "wcmmodifies_" + System.currentTimeMillis());
        if (!this.m_fCollectDir.exists()) {
            this.m_fCollectDir.mkdirs();
        }
        this.m_nAppDirLength = new FileService(this.m_sAppDir).getAbsolutePath().length();
        Iterator itr = fileSet.iterator();
        int nCount = 0;
        while (itr.hasNext()) {
            MediaFilesMD5Digest.DifferenceRecord r = (MediaFilesMD5Digest.DifferenceRecord)itr.next();
            if (!r.isModified() && !this.m_bCollectAddedFiles) continue;
            this.copyFile(r.getName());
            ++nCount;
        }
        if (nCount == 0) {
            System.out.println("Total [" + fileSet.size() + "] files are added.");
            return;
        }
        System.out.println("Total [" + nCount + "] files.");
        System.out.println("Done. Files collect in :" + this.m_fCollectDir.getAbsolutePath());
    }

    protected boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String _sFileName) throws Exception {
        InputStream fins = null;
        OutputStream fos = null;
        try {
            fins = new FileService(_sFileName).getInputStream();
            FileService file = new FileService(this.m_fCollectDir, _sFileName.substring(this.m_nAppDirLength));
            if (!file.getParentFileStore().exists()) {
                file.getParentFileStore().mkdirs();
            }
            fos = file.getOutputStream();
            int len = -1;
            while ((len = fins.read(this.BUFFER, 0, 4096)) != -1) {
                fos.write(this.BUFFER, 0, len);
            }
            fos.flush();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
            if (fins != null) {
                try {
                    fins.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: ");
            System.out.println("\t1.App files dir");
            System.out.println("\t2.Digest file(optional, default: media_digest.txt)");
            System.out.println("\t3.Collect dir(optional, default: system tempdir)");
            System.out.println("\t4.Wether collect addedfiles or not(optional, defualt: no)");
            return;
        }
        try {
            String sAppDir = args[0];
            String sDigestFile = null;
            if (args.length > 1) {
                sDigestFile = args[1];
            }
            ModifiedFilesCollector collector = new ModifiedFilesCollector(sAppDir, sDigestFile);
            if (args.length > 2) {
                collector.setCollectDir(args[2]);
            }
            if (args.length > 3) {
                collector.setCollectAddedFiles("true".equals(args[3]));
            }
            collector.collect();
        }
        catch (Exception e) {
            System.out.println("collect modified files failed.");
            e.printStackTrace(System.out);
        }
    }
}

